/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValueWithSource;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsResolver;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.PathListEntry;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.ResolvingContext;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.UnresolvedPathListEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class BuildSetting {
    @NlsSafe
    public static final String RECURSIVE_PREFIX = "/**";
    private static final Set<String> STRING_BASED_LISTS = new HashSet<String>(Collections.singletonList("USER_HEADER_SEARCH_PATHS"));
    @NotNull
    private final String myName;
    @NotNull
    private final BuildSettingsResolver myProvider;
    @Nullable
    private final String myBaseDir;
    @Nullable
    private volatile Ref<Object> mySetUnresolvedValue;

    public BuildSetting(@NotNull String name, @NotNull BuildSettingsResolver provider, @Nullable String baseDir) {
        if (name == null) {
            BuildSetting.j(0);
        }
        if (provider == null) {
            BuildSetting.j(1);
        }
        this.mySetUnresolvedValue = null;
        this.myName = name;
        this.myProvider = provider;
        this.myBaseDir = baseDir;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            BuildSetting.j(2);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getString() {
        return this.getString(new ResolvingContext());
    }

    @NotNull
    @NlsSafe
    public String getNotNullString() {
        String string = this.getString();
        return string != null ? string : "";
    }

    @Nullable
    @NlsSafe
    String getString(@NotNull ResolvingContext context2) {
        if (context2 == null) {
            BuildSetting.j(3);
        }
        context2.startResolving(this.myName);
        String string = this.myProvider.resolveValue(this.myName, (String)this.j(context2), context2);
        context2.finishResolving(this.myName);
        return string;
    }

    public boolean getBoolean() {
        return "YES".equals(this.getString());
    }

    @Nullable
    @NlsSafe
    public String getAbsolutePath() {
        return this.getAbsolutePath(this.myBaseDir);
    }

    @Nullable
    @NlsSafe
    public String getAbsolutePath(@Nullable String baseDir) {
        File file2 = this.getAbsoluteFile(baseDir);
        return file2 == null ? null : file2.getPath();
    }

    @Nullable
    public File getAbsoluteFile() {
        return this.getAbsoluteFile(this.myBaseDir);
    }

    @Nullable
    public File getAbsoluteFile(@Nullable String baseDir) {
        return BuildSetting.j(this.getString(new ResolvingContext(ResolvingContext.ResolveKind.PATH)), baseDir);
    }

    @Nullable
    private static File j(@Nullable String string, @Nullable String string2) {
        if (string == null || StringUtil.isEmptyOrSpaces((String)string)) {
            return null;
        }
        if (string.startsWith("~")) {
            return new File(SystemProperties.getUserHome(), string.substring(1));
        }
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            return file2;
        }
        return string2 == null ? null : new File(string2, string).getAbsoluteFile();
    }

    public @NotNull List<@NlsSafe String> getStringList() {
        List<String> list = this.getStringList(new ResolvingContext(true));
        if (list == null) {
            BuildSetting.j(4);
        }
        return list;
    }

    @NotNull List<@NlsSafe String> getStringList(@NotNull ResolvingContext context2) {
        String string;
        if (context2 == null) {
            BuildSetting.j(5);
        }
        return (string = this.getString(context2)) == null ? Collections.emptyList() : BuildSetting.splitString(string);
    }

    @NotNull
    public List<PathListEntry> getPathList() {
        List<String> list = this.getStringList(new ResolvingContext(ResolvingContext.ResolveKind.PATH, true));
        ArrayList<PathListEntry> arrayList = new ArrayList<PathListEntry>(list.size());
        for (String string : list) {
            if (string == null) continue;
            String string2 = BuildSetting.j(string);
            Pair<String, Boolean> pair2 = BuildSetting.toPathAndRecursiveFlag(string2);
            string2 = (String)pair2.first;
            File file2 = BuildSetting.j(string2, this.myBaseDir);
            if (file2 == null) continue;
            arrayList.add(new PathListEntry(string2, file2, (Boolean)pair2.second));
        }
        List<PathListEntry> list2 = Collections.unmodifiableList(arrayList);
        if (list2 == null) {
            BuildSetting.j(6);
        }
        return list2;
    }

    @NotNull
    public List<UnresolvedPathListEntry> getUnresolvedPathList() {
        List<String> list = this.getUnresolvedStringList();
        ArrayList<UnresolvedPathListEntry> arrayList = new ArrayList<UnresolvedPathListEntry>(list.size());
        for (String string : list) {
            Pair<String, Boolean> pair2 = BuildSetting.toPathAndRecursiveFlag(string);
            arrayList.add(new UnresolvedPathListEntry((String)pair2.first, (Boolean)pair2.second));
        }
        List<UnresolvedPathListEntry> list2 = Collections.unmodifiableList(arrayList);
        if (list2 == null) {
            BuildSetting.j(7);
        }
        return list2;
    }

    @NotNull
    public static Pair<String, Boolean> toPathAndRecursiveFlag(@NotNull String value2) {
        boolean bl;
        if (value2 == null) {
            BuildSetting.j(8);
        }
        if (bl = value2.endsWith(RECURSIVE_PREFIX)) {
            value2 = value2.substring(0, value2.length() - RECURSIVE_PREFIX.length());
        }
        Pair pair2 = Pair.create((Object)value2, (Object)bl);
        if (pair2 == null) {
            BuildSetting.j(9);
        }
        return pair2;
    }

    @Nullable
    public AppleSdk getSdk() {
        return AppleSdkManager.getInstance().findSdkBySettingValue(this.getString());
    }

    @NotNull
    public Set<ArchitectureValue> getArchitectures() {
        List<String> list = this.getStringList();
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)list.size());
        for (String string : list) {
            builder.add((Object)new ArchitectureValue(string));
        }
        ImmutableSet immutableSet = builder.build();
        if (immutableSet == null) {
            BuildSetting.j(10);
        }
        return immutableSet;
    }

    public boolean isDefinedIn(@Nullable BuildSettingValuesProvider source) {
        return this.getUnresolvedValueSource() == source;
    }

    @Nullable
    public BuildSettingValuesProvider getUnresolvedValueSource() {
        ResolvingContext resolvingContext = new ResolvingContext();
        resolvingContext.startGettingValue(this.myName);
        BuildSettingValueWithSource buildSettingValueWithSource = this.myProvider.getUnresolvedValueWithSource(this.myName, resolvingContext);
        resolvingContext.finishGettingValue(this.myName);
        return buildSettingValueWithSource == null ? null : buildSettingValueWithSource.source;
    }

    @Nullable
    public Object getUnresolvedValue() {
        return this.j(new ResolvingContext());
    }

    @Nullable
    private Object j(ResolvingContext resolvingContext) {
        return this.j(resolvingContext, false);
    }

    @Nullable
    private Object j(ResolvingContext resolvingContext, boolean bl) {
        BuildSettingValueWithSource buildSettingValueWithSource;
        resolvingContext.startGettingValue(this.myName);
        Ref<Object> ref = this.mySetUnresolvedValue;
        Object object = !bl && ref != null ? ref.get() : ((buildSettingValueWithSource = this.myProvider.getUnresolvedValueWithSource(this.myName, resolvingContext)) == null ? null : buildSettingValueWithSource.value);
        resolvingContext.finishGettingValue(this.myName);
        return object;
    }

    @Nullable
    @NlsSafe
    public String getUnresolvedString() {
        return this.j(new ResolvingContext());
    }

    @Nullable
    @NlsSafe
    private String j(@NotNull ResolvingContext resolvingContext) {
        if (resolvingContext == null) {
            BuildSetting.j(11);
        }
        return BuildSetting.convertToString(this.j(resolvingContext));
    }

    public @NotNull List<@NlsSafe String> getUnresolvedStringList() {
        return BuildSetting.j(this.j(new ResolvingContext()));
    }

    public boolean isModified() {
        Ref<Object> ref = this.mySetUnresolvedValue;
        if (ref == null) {
            return false;
        }
        List<String> list = this.j(new ResolvingContext(), true);
        List<String> list2 = ref.get();
        if (list instanceof List) {
            list2 = BuildSetting.j(list2);
        } else if (list2 instanceof List) {
            list = BuildSetting.j(list);
        }
        return !Comparing.equal(list2, list);
    }

    public void reset() {
        this.mySetUnresolvedValue = null;
    }

    public void setUnresolvedValue(@NonNls @Nullable Object value2) {
        this.mySetUnresolvedValue = new Ref(value2);
    }

    public void setUnresolvedString(@NonNls @Nullable String value2) {
        this.setUnresolvedValue(value2);
    }

    public void appendUnresolvedStringList(@Nullable String value2) {
        this.j(BuildSetting.j(value2, false));
    }

    public void appendUnresolvedPathList(@Nullable String value2, boolean recursive) {
        if ((value2 = BuildSetting.j((String)value2, true)) != null && recursive) {
            value2 = (String)value2 + RECURSIVE_PREFIX;
        }
        this.j((String)value2);
    }

    @Nullable
    @Contract(pure=true)
    private static String j(@Nullable String object, boolean bl) {
        if (object == null || StringUtil.isEmptyOrSpaces((String)object)) {
            return null;
        }
        if ((StringUtil.containsWhitespaces((CharSequence)object) || bl && VariableExtractor.PATTERN.matcher((CharSequence)object).find()) && (!((String)object).startsWith("\"") || !((String)object).endsWith("\""))) {
            object = "\"" + StringUtil.escapeQuotes((String)object) + "\"";
        }
        return object;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    private static String j(@Nullable String string) {
        if (string == null) {
            return null;
        }
        string = QuotationExtractor.unquoted(string);
        string = StringUtil.unescapeChar((String)string, (char)'\"');
        string = StringUtil.unescapeChar((String)string, (char)'\'');
        return string;
    }

    private void j(@Nullable String string) {
        if (string == null) {
            return;
        }
        Object object = this.getUnresolvedValue();
        if (object == null) {
            this.setUnresolvedValue(string);
        } else if (object instanceof List) {
            ArrayList<String> arrayList = new ArrayList<String>((List)object);
            arrayList.add(string);
            this.setUnresolvedValue(arrayList);
        } else if (object instanceof String) {
            List<String> list = BuildSetting.splitString((String)object);
            if (list.size() == 1 && !this.j()) {
                list = new ArrayList<String>(list);
                list.add(string);
                this.setUnresolvedValue(list);
            } else {
                this.setUnresolvedValue((object + " " + string).trim());
            }
        } else {
            this.setUnresolvedValue((object + " " + string).trim());
        }
    }

    private boolean j() {
        return STRING_BASED_LISTS.contains(this.myName);
    }

    @NotNull
    private static List<String> j(@Nullable Object object) {
        if (object == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                BuildSetting.j(12);
            }
            return list;
        }
        if (object instanceof List) {
            List<String> list = Collections.unmodifiableList((List)object);
            if (list == null) {
                BuildSetting.j(13);
            }
            return list;
        }
        if (object instanceof String) {
            List<String> list = Collections.unmodifiableList(BuildSetting.splitString((String)object));
            if (list == null) {
                BuildSetting.j(14);
            }
            return list;
        }
        List<String> list = Collections.singletonList(object.toString());
        if (list == null) {
            BuildSetting.j(15);
        }
        return list;
    }

    @NotNull
    static List<String> splitString(@NotNull String s10) {
        int n2;
        if (s10 == null) {
            BuildSetting.j(16);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher2 = QuotationExtractor.PATTERN.matcher(s10);
        int n3 = 0;
        IntRange intRange = QuotationExtractor.findRange(matcher2);
        do {
            int n4 = n3;
            int n5 = s10.length();
            n2 = s10.indexOf(32, n4);
            while (n2 >= 0) {
                block6: {
                    while (intRange != null && n2 >= intRange.getStart()) {
                        if (n2 > intRange.getEndInclusive()) {
                            intRange = QuotationExtractor.findRange(matcher2);
                            continue;
                        }
                        break block6;
                    }
                    n5 = n2;
                    n3 = n5 + 1;
                    break;
                }
                n2 = s10.indexOf(32, n2 + 1);
            }
            if (n4 == n5) continue;
            arrayList.add(s10.substring(n4, n5));
        } while (n2 >= 0);
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            BuildSetting.j(17);
        }
        return arrayList2;
    }

    @NlsSafe
    static String convertToString(@Nullable Object o2) {
        if (o2 instanceof Collection) {
            return StringUtil.join((Collection)((Collection)o2), object -> BuildSetting.convertToString(object), (String)" ");
        }
        return o2 == null ? null : o2.toString();
    }

    public String toString() {
        return this.myName + "=" + this.getUnresolvedString();
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 4, 6, 7, 9, 10, 12, 13, 14, 15, 17 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSetting";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSetting";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedPathList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toPathAndRecursiveFlag";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchitectures";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "splitString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStringList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toPathAndRecursiveFlag";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "splitString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7, 9, 10, 12, 13, 14, 15, 17 -> new IllegalStateException(string);
        };
    }

    public static final class VariableExtractor {
        public static final Pattern PATTERN = Pattern.compile("\\$\\(([\\w.]+)((?::[^:)]*)*)\\)|\\$\\{([\\w.]+)((?::[^:}]*)*)\\}|\\$\\[([\\w.]+)((?::[^:\\]]*)*)\\]|\\$([\\w.]+)");

        @Nullable
        public static Pair<String, List<String>> getVariableAndQualifiers(@NotNull MatchResult m2) {
            if (m2 == null) {
                VariableExtractor.j(0);
            }
            for (int i2 = 1; i2 <= m2.groupCount(); i2 += 2) {
                String string;
                String string2 = m2.group(i2);
                if (string2 == null) continue;
                List list = Collections.emptyList();
                String string3 = string = i2 < m2.groupCount() ? m2.group(i2 + 1) : null;
                if (!StringUtil.isEmptyOrSpaces(string)) {
                    list = StringUtil.split((String)string, (String)":", (boolean)true, (boolean)true);
                }
                return Pair.create((Object)string2, list);
            }
            return null;
        }

        private static /* synthetic */ void j(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSetting$VariableExtractor", "getVariableAndQualifiers"));
        }
    }

    public static final class QuotationExtractor {
        @NotNull
        public static final Pattern PATTERN = Pattern.compile("(?<!\\\\)(?:\\\\\\\\)*(?<quote>[\"'])(?<quoted>.*?)(?:(?<!\\\\)(?:\\\\\\\\)*\\k<quote>|$)");

        public static char getChar(@NotNull Matcher m2) {
            if (m2 == null) {
                QuotationExtractor.j(0);
            }
            return StringsKt.single((CharSequence)m2.group("quote"));
        }

        @Nullable
        public static IntRange findRange(@NotNull Matcher m2) {
            if (m2 == null) {
                QuotationExtractor.j(1);
            }
            return m2.find() ? QuotationExtractor.getRange(m2) : null;
        }

        @NotNull
        public static IntRange getRange(@NonNls @NotNull Matcher m2) {
            if (m2 == null) {
                QuotationExtractor.j(2);
            }
            IntRange intRange = RangesKt.until((int)m2.start("quoted"), (int)m2.end("quoted"));
            if (intRange == null) {
                QuotationExtractor.j(3);
            }
            return intRange;
        }

        @NotNull
        public static String unquoted(@NotNull String str) {
            if (str == null) {
                QuotationExtractor.j(4);
            }
            String string = PATTERN.matcher(str).replaceAll("${quoted}");
            if (string == null) {
                QuotationExtractor.j(5);
            }
            return string;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 3, 5 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "m";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSetting$QuotationExtractor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSetting$QuotationExtractor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unquoted";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getChar";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRange";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "unquoted";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 3, 5 -> new IllegalStateException(string);
            };
        }
    }
}

