/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.google.common.collect.ImmutableSet;
import com.intellij.util.system.CpuArch;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.ArchitectureType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArchitectureValues {
    @NotNull
    public static Set<ArchitectureValue> getSimulatorBuildArchs(@NotNull Collection<ArchitectureValue> buildArchs) {
        if (buildArchs == null) {
            ArchitectureValues.j(0);
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)3);
        for (ArchitectureValue architectureValue : buildArchs) {
            List<ArchitectureValue> list = ArchitectureValues.j(architectureValue);
            if (list != null) {
                for (ArchitectureValue architectureValue2 : list) {
                    if (!architectureValue2.equals(architectureValue) && buildArchs.contains(architectureValue2)) continue;
                    builder.add((Object)architectureValue2);
                }
                continue;
            }
            builder.add((Object)architectureValue);
        }
        ImmutableSet immutableSet = builder.build();
        if (immutableSet == null) {
            ArchitectureValues.j(1);
        }
        return immutableSet;
    }

    @Nullable
    private static List<ArchitectureValue> j(@NotNull ArchitectureValue architectureValue) {
        if (architectureValue == null) {
            ArchitectureValues.j(2);
        }
        if (!CpuArch.isIntel64()) {
            return Collections.singletonList(architectureValue);
        }
        ArchitectureType architectureType = architectureValue.getType();
        if (architectureType != ArchitectureType.UNKNOWN) {
            return switch (architectureType.getBits()) {
                case 32 -> Collections.singletonList(ArchitectureValue.i386);
                case 64 -> Arrays.asList(ArchitectureValue.arm64, ArchitectureValue.x86_64);
                default -> null;
            };
        }
        return null;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildArchs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/ArchitectureValues";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildArch";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/ArchitectureValues";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimulatorBuildArchs";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimulatorBuildArchs";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSimulatorBuildArch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

