/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescription;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptionProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptions;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSpecification;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSpecificationProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProviderWithBase;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsUtilKt;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAware;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001;B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010.\u001a\u00020$2\b\u0010/\u001a\u0004\u0018\u000100H\u0096\u0002J\u0014\u00101\u001a\u0004\u0018\u00010\f2\b\u00102\u001a\u0004\u0018\u00010\fH\u0016J\b\u00103\u001a\u000204H\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u00010\fH\u0016J\u0014\u00107\u001a\u0004\u0018\u00010+2\b\u00106\u001a\u0004\u0018\u00010\fH\u0016J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\fH\u0017R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u0011\u0010\u001e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0018R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020+0*\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006<"}, d2={"Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler;", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingValuesProvider;", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSpecificationProvider;", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptionProvider;", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/DomainAware;", "file", "Ljava/io/File;", "plist", "Lcom/jetbrains/cidr/xcode/plist/Plist;", "platform", "Lcom/jetbrains/cidr/xcode/frameworks/ApplePlatform;", "domain", "", "(Ljava/io/File;Lcom/jetbrains/cidr/xcode/plist/Plist;Lcom/jetbrains/cidr/xcode/frameworks/ApplePlatform;Ljava/lang/String;)V", "baseCompiler", "getBaseCompiler", "()Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler;", "basedOnRef", "buildSettings", "", "getBuildSettings", "()Ljava/util/Set;", "description", "getDescription", "()Ljava/lang/String;", "descriptions", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptions;", "getDescriptions", "()Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescriptions;", "getDomain", "id", "getId", "inputFileTypes", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler$InputFileType;", "getInputFileTypes", "isAbstract", "", "()Z", "name", "getName", "settingValuesProvider", "settings", "", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingSpecification;", "getSettings", "()Ljava/util/Map;", "equals", "other", "", "getCategoryDescription", "categoryName", "getDeclaredBuildSettingValues", "Lcom/jetbrains/cidr/xcode/Dictionary;", "Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/BuildSettingDescription;", "settingName", "getSpecification", "hashCode", "", "toString", "InputFileType", "intellij.cidr.xcodeModel.core"})
@SourceDebugExtension(value={"SMAP\nAppleCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppleCompiler.kt\ncom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class AppleCompiler
implements BuildSettingValuesProvider,
BuildSettingSpecificationProvider,
BuildSettingDescriptionProvider,
DomainAware {
    @NotNull
    private final ApplePlatform platform;
    @NotNull
    private final String id;
    @Nullable
    private final String basedOnRef;
    @Nullable
    private final String domain;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    private final boolean isAbstract;
    @NotNull
    private final Map<String, BuildSettingSpecification> settings;
    @Nullable
    private final BuildSettingDescriptions descriptions;
    @NotNull
    private final Set<InputFileType> inputFileTypes;
    @NotNull
    private final BuildSettingValuesProvider settingValuesProvider;

    public AppleCompiler(@NotNull File file2, @NotNull Plist plist, @NotNull ApplePlatform platform, @Nullable String domain) {
        List<Object> list;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
        String string = plist.getNotNullString("Identifier");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNotNullString(...)");
        this.id = string;
        this.basedOnRef = plist.getString("BasedOn");
        this.domain = plist.getString("Domain", domain);
        this.name = plist.getString("Name");
        this.description = plist.getString("Description");
        Boolean bl = plist.getBoolean("IsAbstract", false);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"getBoolean(...)");
        this.isAbstract = bl;
        List<Dictionary> list2 = plist.getAttributeList("Options", Dictionary.class, CollectionsKt.emptyList());
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Dictionary object : list2) {
            AppleBuildSystem.readSetting(file2, object, linkedHashMap, null);
        }
        Map map = Collections.unmodifiableMap(linkedHashMap);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        this.settings = map;
        if (this.name != null) {
            list = file2.getParent();
            String string2 = this.name + ".strings";
            File[] fileArray = new File[3];
            fileArray[0] = new File((String)((Object)list), string2);
            String[] stringArray = new String[]{"English.lproj", string2};
            fileArray[1] = new File((String)((Object)list), FileUtil.join((String[])stringArray));
            stringArray = new String[]{"en.lproj", string2};
            fileArray[2] = new File((String)((Object)list), FileUtil.join((String[])stringArray));
            this.descriptions = BuildSettingsUtilKt.loadDescriptionsLayout(fileArray);
        } else {
            this.descriptions = null;
        }
        list = plist.getAttributeList("InputFileTypes", Object.class, CollectionsKt.emptyList());
        Intrinsics.checkNotNull(list);
        this.inputFileTypes = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)1.INSTANCE));
        this.settingValuesProvider = new BuildSettingValuesProviderWithBase(){

            @Override
            @Nullable
            protected BuildSettingValuesProvider getBase() {
                return this.getBaseCompiler();
            }

            @Override
            @NotNull
            protected Dictionary getSettings() {
                Dictionary dictionary = new Dictionary();
                for (Map.Entry<String, BuildSettingSpecification> entry2 : this.getSettings().entrySet()) {
                    String string = entry2.getKey();
                    BuildSettingSpecification buildSettingSpecification = entry2.getValue();
                    Object object = buildSettingSpecification.getDefaultValue();
                    if (object == null) continue;
                    ((Map)dictionary).put(string, object);
                }
                return dictionary;
            }
        };
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    @NotNull
    public final Map<String, BuildSettingSpecification> getSettings() {
        return this.settings;
    }

    @Nullable
    public final BuildSettingDescriptions getDescriptions() {
        return this.descriptions;
    }

    @NotNull
    public final Set<InputFileType> getInputFileTypes() {
        return this.inputFileTypes;
    }

    @Nullable
    public final AppleCompiler getBaseCompiler() {
        return this.platform.findCompilerByRef(this.basedOnRef);
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.settingValuesProvider.getDeclaredBuildSettingValues();
        Intrinsics.checkNotNullExpressionValue((Object)dictionary, (String)"getDeclaredBuildSettingValues(...)");
        return dictionary;
    }

    @Override
    @NotNull
    public Set<String> getBuildSettings() {
        Object object;
        return SetsKt.plus(this.settings.keySet(), (Iterable)((object = this.getBaseCompiler()) != null && (object = ((AppleCompiler)object).getBuildSettings()) != null ? (Iterable)object : (Iterable)SetsKt.emptySet()));
    }

    @Override
    @Nullable
    public BuildSettingSpecification getSpecification(@Nullable String settingName) {
        if (settingName == null) {
            return null;
        }
        BuildSettingSpecification buildSettingSpecification = this.settings.get(settingName);
        if (buildSettingSpecification == null) {
            AppleCompiler appleCompiler = this.getBaseCompiler();
            buildSettingSpecification = appleCompiler != null ? appleCompiler.getSpecification(settingName) : null;
        }
        return buildSettingSpecification;
    }

    @Override
    @Nullable
    public BuildSettingDescription getDescription(@Nullable String settingName) {
        if (settingName == null) {
            return null;
        }
        Object object = this.descriptions;
        if (object == null || (object = ((BuildSettingDescriptions)object).getDescription(settingName)) == null) {
            AppleCompiler appleCompiler = this.getBaseCompiler();
            object = appleCompiler != null ? appleCompiler.getDescription(settingName) : null;
        }
        return object;
    }

    @Override
    @Nullable
    public String getCategoryDescription(@Nullable String categoryName) {
        if (categoryName == null) {
            return null;
        }
        Object object = this.descriptions;
        if (object == null || (object = ((BuildSettingDescriptions)object).getCategoryDescription(categoryName)) == null) {
            AppleCompiler appleCompiler = this.getBaseCompiler();
            object = appleCompiler != null ? appleCompiler.getCategoryDescription(categoryName) : null;
            if (object == null) {
                object = categoryName;
            }
        }
        Object object2 = object;
        return this.name + " - " + (String)object2;
    }

    @NonNls
    @NotNull
    public String toString() {
        Object object;
        String string;
        Object object2;
        block7: {
            block6: {
                boolean bl;
                String string2;
                block5: {
                    block4: {
                        object2 = this.getDomain();
                        if (object2 == null) break block4;
                        string2 = object2;
                        bl = false;
                        String string3 = string2 + ":";
                        object2 = string3;
                        if (string3 != null) break block5;
                    }
                    object2 = "";
                }
                string = this.id;
                object = this.basedOnRef;
                if (object == null) break block6;
                string2 = object;
                String string4 = string;
                Object object3 = object2;
                bl = false;
                String string5 = "Based on: " + string2;
                object2 = object3;
                string = string4;
                String string6 = string5;
                object = string6;
                if (string6 != null) break block7;
            }
            object = "";
        }
        return "Compiler: " + (String)object2 + string + " " + (String)object;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleCompiler");
        AppleCompiler cfr_ignored_0 = (AppleCompiler)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)((AppleCompiler)other).id)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getDomain(), (Object)((AppleCompiler)other).getDomain());
    }

    public int hashCode() {
        int n2 = this.id.hashCode();
        String string = this.getDomain();
        n2 = 31 * n2 + (string != null ? string.hashCode() : 0);
        return n2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/xcode/frameworks/buildSystem/AppleCompiler$InputFileType;", "", "dictionary", "Lcom/jetbrains/cidr/xcode/Dictionary;", "(Lcom/jetbrains/cidr/xcode/Dictionary;)V", "fileType", "", "(Ljava/lang/String;)V", "getFileType", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.xcodeModel.core"})
    public static final class InputFileType {
        @NotNull
        private final String fileType;

        public InputFileType(@NotNull String fileType) {
            Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
            this.fileType = fileType;
        }

        @NotNull
        public final String getFileType() {
            return this.fileType;
        }

        public InputFileType(@NotNull Dictionary dictionary) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            String string = dictionary.getNotNullString("FileType");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNotNullString(...)");
            this(string);
        }

        @NotNull
        public final String component1() {
            return this.fileType;
        }

        @NotNull
        public final InputFileType copy(@NotNull String fileType) {
            Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
            return new InputFileType(fileType);
        }

        public static /* synthetic */ InputFileType copy$default(InputFileType inputFileType, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = inputFileType.fileType;
            }
            return inputFileType.copy(string);
        }

        @NotNull
        public String toString() {
            return "InputFileType(fileType=" + this.fileType + ")";
        }

        public int hashCode() {
            return this.fileType.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InputFileType)) {
                return false;
            }
            InputFileType inputFileType = (InputFileType)other;
            return Intrinsics.areEqual((Object)this.fileType, (Object)inputFileType.fileType);
        }
    }
}

