/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAndID;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAwareKt;
import org.jetbrains.annotations.Nullable;

public abstract class AppleBuildSystemProviderImpl
implements AppleBuildSystemProvider {
    @Nullable
    private final AppleBuildSystemProvider myParent;

    public AppleBuildSystemProviderImpl(@Nullable AppleBuildSystemProvider parent) {
        this.myParent = parent;
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable String id, @Nullable String domain) {
        if (id == null) {
            return null;
        }
        for (AppleBuildSystem appleBuildSystem : this.getBuildSystems()) {
            if (!appleBuildSystem.getId().equals(id) || !DomainAwareKt.isSuitableDomain(appleBuildSystem, domain)) continue;
            return appleBuildSystem;
        }
        return this.myParent == null ? null : this.myParent.findBuildSystem(id, this.myParent.getDomain());
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable AppleBuildSystem.Type type, @Nullable String domain) {
        return this.findBuildSystem(type == null ? null : type.getId(), domain);
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystemByRef(@Nullable String ref) {
        if (ref == null) {
            return null;
        }
        DomainAndID domainAndID = new DomainAndID(ref);
        String string = domainAndID.getDomain();
        if (string != null) {
            AppleBuildSystemProvider appleBuildSystemProvider;
            AppleBuildSystemProvider appleBuildSystemProvider2 = appleBuildSystemProvider = "default".equals(string) ? this.myParent : this;
            if (appleBuildSystemProvider != null) {
                return appleBuildSystemProvider.findBuildSystem(domainAndID.getId(), string);
            }
        }
        return this.findBuildSystem(domainAndID.getId(), this.getDomain());
    }
}

