/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks.buildSystem;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.NullableFunction;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescription;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptionProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingDescriptions;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSpecification;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingSpecificationProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProviderWithBase;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsUtilKt;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAware;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.EnumBuildSettingSpecification;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppleBuildSystem
implements BuildSettingValuesProvider,
BuildSettingSpecificationProvider,
BuildSettingDescriptionProvider,
DomainAware {
    @NotNull
    private final AppleBuildSystemProvider myProvider;
    @NotNull
    private final String myId;
    @Nullable
    private final String myName;
    @Nullable
    private final String myDomain;
    @Nullable
    private final String myBasedOnRef;
    @NotNull
    private final Map<String, BuildSettingSpecification> mySettings;
    @NotNull
    private final BuildSettingValuesProvider mySettingValuesProvider;
    @Nullable
    private final BuildSettingDescriptions myDescriptions;

    public AppleBuildSystem(@NotNull File file2, @NotNull Plist plist, @NotNull AppleBuildSystemProvider provider, @Nullable NullableFunction<String, List<Object>> enumValuesOverrider, @Nullable String domain) {
        if (file2 == null) {
            AppleBuildSystem.j(0);
        }
        if (plist == null) {
            AppleBuildSystem.j(1);
        }
        if (provider == null) {
            AppleBuildSystem.j(2);
        }
        this.myProvider = provider;
        this.myId = plist.getNotNullString("Identifier");
        this.myName = plist.getString("Name");
        this.myBasedOnRef = plist.getString("BasedOn");
        this.myDomain = domain;
        List<Dictionary> list = plist.getAttributeList("Options", Dictionary.class, null);
        if (list == null) {
            list = plist.getAttributeList("Properties", Dictionary.class, Collections.emptyList());
        }
        LinkedHashMap<String, BuildSettingSpecification> linkedHashMap = new LinkedHashMap<String, BuildSettingSpecification>();
        for (Dictionary object2 : list) {
            AppleBuildSystem.readSetting(file2, object2, linkedHashMap, enumValuesOverrider);
        }
        this.mySettings = Collections.unmodifiableMap(linkedHashMap);
        this.mySettingValuesProvider = new BuildSettingValuesProviderWithBase(){

            @Override
            protected BuildSettingValuesProvider getBase() {
                return AppleBuildSystem.this.getBaseBuildSystem();
            }

            @Override
            @NotNull
            protected Dictionary getSettings() {
                Dictionary dictionary = new Dictionary();
                for (Map.Entry<String, BuildSettingSpecification> entry2 : AppleBuildSystem.this.mySettings.entrySet()) {
                    Object object = entry2.getValue().getDefaultValue();
                    if (object == null) continue;
                    dictionary.put(entry2.getKey(), object);
                }
                Dictionary dictionary2 = dictionary;
                if (dictionary2 == null) {
                    1.N(0);
                }
                return dictionary2;
            }

            private static /* synthetic */ void N(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/buildSystem/AppleBuildSystem$1", "getSettings"));
            }
        };
        String string = file2.getParent();
        String string2 = this.myName + ".strings";
        this.myDescriptions = BuildSettingsUtilKt.loadDescriptionsLayout(new File(string, string2), new File(string, FileUtil.join((String[])new String[]{"English.lproj", string2})), new File(string, FileUtil.join((String[])new String[]{"en.lproj", string2})));
    }

    public static void readSetting(@NotNull File file2, @NotNull Dictionary each, @NotNull Map<String, BuildSettingSpecification> result2, @Nullable NullableFunction<String, List<Object>> enumValuesOverrider) {
        BuildSettingSpecification buildSettingSpecification;
        if (file2 == null) {
            AppleBuildSystem.j(3);
        }
        if (each == null) {
            AppleBuildSystem.j(4);
        }
        if (result2 == null) {
            AppleBuildSystem.j(5);
        }
        String string = each.getString("Name");
        String string2 = each.getString("DisplayName");
        String string3 = each.getString("Description");
        @NonNls String string4 = each.getString("Type");
        String string5 = each.getString("UIType");
        String string6 = each.getString("Category");
        Object t10 = each.getAttribute("DefaultValue", null);
        if (string == null) {
            XCLog.LOG.debug("Cannot read build option's name in file: " + file2 + ":\n" + each);
            return;
        }
        if ("Enumeration".equalsIgnoreCase(string4) || "enum".equalsIgnoreCase(string4)) {
            List<Object> list = null;
            if (enumValuesOverrider != null) {
                list = (List<Object>)enumValuesOverrider.fun((Object)string);
            }
            if (list == null) {
                list = each.getAttributeList("Values", Object.class, Collections.emptyList());
            }
            buildSettingSpecification = new EnumBuildSettingSpecification(string, list, string2, string3, string5, string6, t10);
        } else {
            BuildSettingSpecification.Type type;
            if (string4 == null || "String".equalsIgnoreCase(string4)) {
                type = BuildSettingSpecification.Type.STRING;
            } else if ("Boolean".equalsIgnoreCase(string4) || "bool".equalsIgnoreCase(string4)) {
                type = BuildSettingSpecification.Type.BOOLEAN;
            } else if ("StringList".equalsIgnoreCase(string4)) {
                type = BuildSettingSpecification.Type.STRING_LIST;
            } else if ("Path".equalsIgnoreCase(string4)) {
                type = BuildSettingSpecification.Type.PATH;
            } else if ("PathList".equalsIgnoreCase(string4)) {
                type = BuildSettingSpecification.Type.PATH_LIST;
            } else if ("CompilerVersion".equalsIgnoreCase(string4) || "CodeSignIdentity".equalsIgnoreCase(string4) || "ProvisioningProfile".equalsIgnoreCase(string4) || "ProvisioningProfileSpecifier".equalsIgnoreCase(string4) || "DevelopmentTeam".equalsIgnoreCase(string4) || "CodeSignStyle".equalsIgnoreCase(string4)) {
                type = BuildSettingSpecification.Type.STRING;
            } else {
                XCLog.LOG.warn("unknown build setting type in file " + file2 + ":\n" + each);
                type = BuildSettingSpecification.Type.STRING;
            }
            buildSettingSpecification = new BuildSettingSpecification(type, string, string2, string3, string5, string6, t10);
        }
        result2.put(string, buildSettingSpecification);
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            AppleBuildSystem.j(6);
        }
        return string;
    }

    @Nullable
    public String getName() {
        if (this.myName != null) {
            return this.myName;
        }
        AppleBuildSystem appleBuildSystem = this.getBaseBuildSystem();
        return appleBuildSystem == null ? null : appleBuildSystem.getName();
    }

    @Override
    @Nullable
    public String getDomain() {
        return this.myDomain;
    }

    @Nullable
    public AppleBuildSystem getBaseBuildSystem() {
        return this.myBasedOnRef == null ? null : this.myProvider.findBuildSystemByRef(this.myBasedOnRef);
    }

    @Nullable
    public String getBaseBuildSystemRef() {
        return this.myBasedOnRef;
    }

    @Override
    @NotNull
    public Set<String> getBuildSettings() {
        Set<String> set = this.mySettings.keySet();
        AppleBuildSystem appleBuildSystem = this.getBaseBuildSystem();
        if (appleBuildSystem != null) {
            set = new HashSet<String>(set);
            set.addAll(appleBuildSystem.getBuildSettings());
        }
        Set<String> set2 = Collections.unmodifiableSet(set);
        if (set2 == null) {
            AppleBuildSystem.j(7);
        }
        return set2;
    }

    @Override
    @Nullable
    public BuildSettingSpecification getSpecification(@Nullable String settingName) {
        if (settingName == null) {
            return null;
        }
        BuildSettingSpecification buildSettingSpecification = this.mySettings.get(settingName);
        if (buildSettingSpecification == null) {
            AppleBuildSystem appleBuildSystem = this.getBaseBuildSystem();
            buildSettingSpecification = appleBuildSystem != null ? appleBuildSystem.getSpecification(settingName) : null;
        }
        return buildSettingSpecification;
    }

    @Override
    @Nullable
    public BuildSettingDescription getDescription(@Nullable String settingName) {
        BuildSettingDescription buildSettingDescription;
        if (settingName == null) {
            return null;
        }
        BuildSettingDescription buildSettingDescription2 = buildSettingDescription = this.myDescriptions != null ? this.myDescriptions.getDescription(settingName) : null;
        if (buildSettingDescription == null) {
            AppleBuildSystem appleBuildSystem = this.getBaseBuildSystem();
            buildSettingDescription = appleBuildSystem != null ? appleBuildSystem.getDescription(settingName) : null;
        }
        return buildSettingDescription;
    }

    @Override
    @Nullable
    public String getCategoryDescription(@Nullable String category) {
        String string;
        if (category == null) {
            return null;
        }
        String string2 = string = this.myDescriptions != null ? this.myDescriptions.getCategoryDescription(category) : null;
        if (string == null) {
            AppleBuildSystem appleBuildSystem = this.getBaseBuildSystem();
            string = appleBuildSystem != null ? appleBuildSystem.getCategoryDescription(category) : null;
        }
        return string;
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.mySettingValuesProvider.getDeclaredBuildSettingValues();
        if (dictionary == null) {
            AppleBuildSystem.j(8);
        }
        return dictionary;
    }

    @NonNls
    public String toString() {
        return "Build System: " + (String)(this.myDomain != null ? this.myDomain + ":" : "") + this.myId + (String)(this.myBasedOnRef != null ? " Based on: " + this.myBasedOnRef : "");
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/AppleBuildSystem";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/AppleBuildSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSetting";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type CORE = new Type("com.apple.build-system.core");
        public static final /* enum */ Type NATIVE = new Type("com.apple.build-system.native");
        public static final /* enum */ Type STANDARD_SETTINGS = new Type("com.apple.buildsettings.standard");
        @NotNull
        @NonNls
        private final String myId;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String id) {
            if (id == null) {
                Type.j(0);
            }
            this.myId = id;
        }

        @NotNull
        @NonNls
        public String getId() {
            String string = this.myId;
            if (string == null) {
                Type.j(1);
            }
            return string;
        }

        private static /* synthetic */ Type[] j() {
            return new Type[]{CORE, NATIVE, STANDARD_SETTINGS};
        }

        static {
            $VALUES = Type.j();
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/AppleBuildSystem$Type";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/buildSystem/AppleBuildSystem$Type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

