/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecListHelper {
    private static final ConcurrentMap<File, Plist> ourSpecs = ContainerUtil.createConcurrentSoftValueMap();

    public static <T> List<T> readSpecs(@NotNull File file2, @Nullable @NonNls String type, Factory<T> factory) {
        Plist plist;
        if (file2 == null) {
            SpecListHelper.j(0);
        }
        if ((plist = (Plist)ourSpecs.get(file2)) == null) {
            plist = PlistDriver.readAnyFormatSafe(file2);
            if (plist == null) {
                return Collections.emptyList();
            }
            ourSpecs.put(file2, plist);
        }
        return SpecListHelper.j(file2, plist, type, factory);
    }

    public static <T> List<T> readSpecs(@NotNull Plist plist, @Nullable @NonNls String type, Factory<T> factory) {
        if (plist == null) {
            SpecListHelper.j(1);
        }
        return SpecListHelper.j(null, plist, type, factory);
    }

    private static <T> List<T> j(@Nullable File file2, @NotNull Plist plist, @Nullable @NonNls String string, Factory<T> factory) {
        if (plist == null) {
            SpecListHelper.j(2);
        }
        ArrayList arrayList = new ArrayList();
        if (string == null || !SpecListHelper.j(string, factory, plist, arrayList)) {
            for (Plist plist2 : plist.getObjects(Plist.class)) {
                try {
                    SpecListHelper.j(string, factory, plist2, arrayList);
                }
                catch (InvalidSpecException invalidSpecException) {
                    if (file2 != null) {
                        XCLog.LOG.error("Invalid plist file: " + file2, (Throwable)invalidSpecException);
                        continue;
                    }
                    XCLog.LOG.error("Invalid plist: " + plist, (Throwable)invalidSpecException);
                }
            }
        }
        return arrayList;
    }

    private static <T> boolean j(@Nullable @NonNls String string, Factory<T> factory, Plist plist, List<T> list) {
        T t10;
        if ((string == null || string.equals(plist.getString("Type"))) && (t10 = factory.create(plist)) != null) {
            list.add(t10);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/SpecListHelper";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readSpecs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doReadSpecs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface Factory<T> {
        @Nullable
        public T create(@NotNull Plist var1) throws InvalidSpecException;
    }
}

