/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.apple.sdk.AppleSdkManagerBase;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.frameworks.AppleArchitecture;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.SpecListHelper;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProviderImpl;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import com.jetbrains.cidr.xcode.xcspec.XCSpecFile;
import com.jetbrains.cidr.xcode.xcspec.XcodeExtensionsManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppleSdkManager
extends AppleSdkManagerBase
implements AppleBuildSystemProvider,
BuildSettingValuesProvider {
    private static final Pattern PLUGIN_PATTERN = Pattern.compile(".+\\.(?!ideplugin\\b)\\w*plugin\\w*");
    @NotNull
    private List<ApplePlatform> mySortedPlatforms;
    @NotNull
    private List<AppleSdk> mySortedSdks;
    @NotNull
    private List<AppleSdk> mySwiftPackageSdks;
    @NotNull
    private List<AppleBuildSystem> myBuildSystems;
    @NotNull
    private AppleBuildSystemProvider myBuildSystemProvider;
    @NotNull
    private Dictionary myBuiltInBuildSettings;

    @NotNull
    public static AppleSdkManager getInstance() {
        AppleSdkManager appleSdkManager = (AppleSdkManager)AppleSdkManagerBase.getInstance();
        if (appleSdkManager == null) {
            AppleSdkManager.N(0);
        }
        return appleSdkManager;
    }

    public AppleSdkManager() {
        XcodeBase xcodeBase = XcodeBase.getInstance();
        XcodeExtensionsManager xcodeExtensionsManager = XcodeExtensionsManager.getInstance();
        ReadAction.run(() -> {
            XCLog.LOG.info("Configuring SDKs for Xcode " + xcodeBase.getDisplayVersion() + " located in " + xcodeBase.getBaseFile());
            ArrayList<ApplePlatform> arrayList = new ArrayList<ApplePlatform>();
            ArrayList<AppleSdk> arrayList2 = new ArrayList<AppleSdk>();
            ArrayList<AppleBuildSystem> arrayList3 = new ArrayList<AppleBuildSystem>();
            File file2 = xcodeBase.getSubFile("Platforms");
            this.w(file2, arrayList);
            ContainerUtil.sort(arrayList);
            arrayList.trimToSize();
            this.mySortedPlatforms = Collections.unmodifiableList(arrayList);
            for (ApplePlatform applePlatform2 : arrayList) {
                this.N(applePlatform2.getSdksRoot(), arrayList2);
            }
            this.j(ContainerUtil.map2Set(arrayList, applePlatform -> applePlatform.getType().getPlatformName()), arrayList3, xcodeExtensionsManager);
            ContainerUtil.sort(arrayList2);
            arrayList2.trimToSize();
            this.j(arrayList2);
            arrayList3.trimToSize();
            this.myBuildSystems = Collections.unmodifiableList(arrayList3);
            this.myBuildSystemProvider = new AppleBuildSystemProviderImpl(null){

                @Override
                @NotNull
                public List<AppleBuildSystem> getBuildSystems() {
                    List<AppleBuildSystem> list = AppleSdkManager.this.myBuildSystems;
                    if (list == null) {
                        1.j(0);
                    }
                    return list;
                }

                @Override
                @NotNull
                public String getDomain() {
                    return "default";
                }

                private static /* synthetic */ void j(int n2) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/AppleSdkManager$1", "getBuildSystems"));
                }
            };
            this.myBuiltInBuildSettings = this.j();
        });
    }

    private void j(@NotNull List<AppleSdk> list) {
        if (list == null) {
            AppleSdkManager.N(1);
        }
        this.mySortedSdks = Collections.unmodifiableList(list);
        this.mySwiftPackageSdks = AppleSdkManager.j(this.mySortedSdks);
    }

    private void w(@NotNull File file2, List<ApplePlatform> list) {
        File[] fileArray;
        if (file2 == null) {
            AppleSdkManager.N(2);
        }
        if ((fileArray = file2.listFiles(FileFilters.withExtension((String)"platform"))) == null) {
            return;
        }
        for (File file3 : fileArray) {
            try {
                Plist plist = AppleSdkManager.j(new File(file3, "Info.plist"));
                if (plist == null) continue;
                ApplePlatform applePlatform = new ApplePlatform(file3, plist, this);
                list.add(applePlatform);
                XCLog.LOG.info("Platform configured: '" + applePlatform + "'");
            }
            catch (InvalidSpecException invalidSpecException) {
                XCLog.LOG.info("invalid platform: " + file3.getPath(), (Throwable)invalidSpecException);
            }
        }
    }

    private void N(@NotNull File file2, List<AppleSdk> list) {
        File[] fileArray;
        if (file2 == null) {
            AppleSdkManager.N(3);
        }
        if ((fileArray = file2.listFiles(FileFilters.withExtension((String)"sdk"))) == null) {
            return;
        }
        for (File file3 : fileArray) {
            try {
                file3 = file3.getCanonicalFile();
            }
            catch (IOException iOException) {
                XCLog.LOG.warn((Throwable)iOException);
            }
            String string = FileUtil.toSystemIndependentName((String)file3.getAbsolutePath());
            VirtualFile virtualFile2 = StandardFileSystems.local().refreshAndFindFileByPath(string);
            if (virtualFile2 == null || AppleSdkManager.j(virtualFile2, list) != null) continue;
            try {
                Plist plist = AppleSdkManager.j(new File(virtualFile2.getPath(), "SDKSettings.plist"));
                if (plist == null) continue;
                AppleSdk appleSdk = AppleSdk.createFromSpec(virtualFile2, plist, this);
                list.add(appleSdk);
                XCLog.LOG.info("SDK configured: '" + appleSdk + "' for platform: '" + appleSdk.getPlatform() + "'");
            }
            catch (InvalidSpecException invalidSpecException) {
                XCLog.LOG.info("invalid sdk: " + virtualFile2.getPath(), (Throwable)invalidSpecException);
            }
        }
    }

    private void j(@NotNull Set<String> set, List<AppleBuildSystem> list, @NotNull XcodeExtensionsManager xcodeExtensionsManager) {
        if (set == null) {
            AppleSdkManager.N(4);
        }
        if (xcodeExtensionsManager == null) {
            AppleSdkManager.N(5);
        }
        NullableFunction nullableFunction = string -> {
            if ("MACOSX_DEPLOYMENT_TARGET".equals(string)) {
                AppleSdk appleSdk = (AppleSdk)ContainerUtil.getFirstItem(this.findSdksForPlatform(ApplePlatform.Type.MACOS));
                if (appleSdk == null) {
                    return null;
                }
                String string2 = appleSdk.getVersionString();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add("");
                for (int i2 = 6; i2 < 15; ++i2) {
                    String string3 = "10." + i2;
                    arrayList.add(string3);
                    if (string2.equals(string3)) break;
                    if (i2 != 14) continue;
                    XCLog.LOG.error("Unexpected OS X version: " + string2);
                }
                arrayList.trimToSize();
                return arrayList;
            }
            return null;
        };
        Set set2 = set.stream().flatMap(string -> xcodeExtensionsManager.getXCSpecFileList((String)string).stream()).collect(Collectors.toSet());
        for (XCSpecFile object : set2) {
            XCLog.LOG.debug("Processing xcspec file from XCSpecProvider: " + object);
            list.addAll(SpecListHelper.readSpecs(object.getFile(), "BuildSystem", plist -> new AppleBuildSystem(object.getFile(), plist, this, (NullableFunction<String, List<Object>>)nullableFunction, object.getDomain())));
        }
        for (File file2 : AppleSdkManager.getSpecsFolders()) {
            File[] fileArray = file2.listFiles();
            if (fileArray == null) continue;
            for (File file3 : fileArray) {
                if (!StringUtil.endsWithIgnoreCase((String)file3.getName(), (String)".xcspec")) continue;
                list.addAll(SpecListHelper.readSpecs(file3, "BuildSystem", plist -> new AppleBuildSystem(file2, plist, this, (NullableFunction<String, List<Object>>)nullableFunction, "default")));
            }
        }
    }

    @Deprecated
    @NotNull
    static List<File> getSpecsFolders() {
        XcodeBase xcodeBase = XcodeBase.getInstance();
        if (xcodeBase.getVersion().isOrGreaterThan(Integer.valueOf(13), Integer.valueOf(3))) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                AppleSdkManager.N(6);
            }
            return list;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        AppleSdkManager.j(xcodeBase.getBaseFile(), arrayList);
        AppleSdkManager.j(xcodeBase.getApplicationContentsSubFile(null), arrayList);
        AppleSdkManager.j(xcodeBase.getSubFile("Library"), arrayList);
        AppleSdkManager.j(xcodeBase.getSubFile("Library/Xcode"), arrayList);
        ArrayList<File> arrayList2 = arrayList;
        if (arrayList2 == null) {
            AppleSdkManager.N(7);
        }
        return arrayList2;
    }

    private static void j(File file2, List<File> list) {
        File[] fileArray = file2.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file3 : fileArray) {
            File[] fileArray2;
            if ("OtherFrameworks".equals(file3.getName()) || (fileArray2 = file3.listFiles()) == null) continue;
            for (File file4 : fileArray2) {
                File[] fileArray3;
                String string = file4.getName();
                if (string.endsWith(".framework")) {
                    list.add(new File(file4, "Resources"));
                } else if (PLUGIN_PATTERN.matcher(string).matches()) {
                    list.add(new File(file4, "Contents/Resources"));
                }
                if (!string.endsWith(".ideplugin") || (fileArray3 = new File(file4, "Contents/Frameworks").listFiles()) == null) continue;
                for (File file5 : fileArray3) {
                    String string2 = file5.getName();
                    if (!string2.endsWith(".framework")) continue;
                    list.add(new File(file5, "Resources"));
                }
            }
        }
    }

    @Nullable
    private static Plist j(File file2) {
        return !file2.exists() || file2.isDirectory() ? null : PlistDriver.readAnyFormatSafe(file2);
    }

    private Dictionary j() {
        Dictionary dictionary = new Dictionary();
        dictionary.setAttribute("MAC_OS_X_VERSION_ACTUAL", SystemInfo.getMacOSVersionCode());
        dictionary.setAttribute("MAC_OS_X_VERSION_MAJOR", SystemInfo.getMacOSMajorVersionCode());
        dictionary.setAttribute("MAC_OS_X_VERSION_MINOR", SystemInfo.getMacOSMinorVersionCode());
        dictionary.setAttribute("HOME", "~");
        AppleSdkManager.j(dictionary, "SYSTEM_APPS_DIR", "/Applications");
        AppleSdkManager.j(dictionary, "SYSTEM_ADMIN_APPS_DIR", "/Applications/Utilities");
        AppleSdkManager.j(dictionary, "SYSTEM_DEMOS_DIR", "/Applications/Extras");
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_DIR", XcodeBase.getInstance().getBasePath());
        AppleSdkManager.j(dictionary, "DEVELOPER_DIR", "$(SYSTEM_DEVELOPER_DIR)");
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_APPS_DIR", XcodeBase.getInstance().getApplicationsSubFilePath(null));
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_JAVA_TOOLS_DIR", "$(SYSTEM_DEVELOPER_APPS_DIR}/Java Tools");
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_PERFORMANCE_TOOLS_DIR", "$(SYSTEM_DEVELOPER_APPS_DIR}/Performance Tools");
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_GRAPHICS_TOOLS_DIR", "$(SYSTEM_DEVELOPER_APPS_DIR}/Graphics Tools");
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_UTILITIES_DIR", "$(SYSTEM_DEVELOPER_APPS_DIR}/Utilities");
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_DEMOS_DIR", "$(SYSTEM_DEVELOPER_APPS_DIR}/Utilities/Built Examples");
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_DOC_DIR", "$(SYSTEM_DEVELOPER_DIR)/ADC Reference Library");
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_TOOLS_DOC_DIR", "$(SYSTEM_DEVELOPER_DIR)/ADC Reference Library/documentation/DeveloperTools");
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_RELEASENOTES_DIR", "$(SYSTEM_DEVELOPER_DIR)/ADC Reference Library/releasenotes");
        AppleSdkManager.j(dictionary, "SYSTEM_DEVELOPER_TOOLS_RELEASENOTES_DIR", "$(SYSTEM_DEVELOPER_DIR)/ADC Reference Library/releasenotes/DeveloperTools");
        AppleSdkManager.j(dictionary, "SYSTEM_LIBRARY_DIR", "/System/Library");
        AppleSdkManager.j(dictionary, "SYSTEM_CORE_SERVICES_DIR", "/System/Library/CoreServices");
        AppleSdkManager.j(dictionary, "SYSTEM_DOCUMENTATION_DIR", "/Library/Documentation");
        AppleSdkManager.j(dictionary, "LOCAL_ADMIN_APPS_DIR", "/Applications/Utilities");
        AppleSdkManager.j(dictionary, "LOCAL_APPS_DIR", "/Applications");
        AppleSdkManager.j(dictionary, "LOCAL_DEVELOPER_DIR", "/Library/Developer");
        AppleSdkManager.j(dictionary, "LOCAL_LIBRARY_DIR", "/Library");
        AppleSdkManager.j(dictionary, "USER_APPS_DIR", "$(HOME)/Applications");
        AppleSdkManager.j(dictionary, "USER_LIBRARY_DIR", "$(HOME)/Library");
        AppleSdkManager.j(dictionary, "MAN_PAGE_DIRECTORIES", "/usr/share/man");
        AppleSdk appleSdk = this.getDefaultSdk();
        AppleSdkManager.j(dictionary, "DEVELOPER_SDK_DIR", appleSdk != null ? appleSdk.getRoot().getParent().getPath() : "$(SYSTEM_DEVELOPER_DIR)/SDKs");
        AppleSdkManager.j(dictionary, "CONFIGURATION_BUILD_DIR", "$(BUILD_DIR)/$(CONFIGURATION)$(EFFECTIVE_PLATFORM_NAME)");
        AppleSdkManager.j(dictionary, "CONFIGURATION_TEMP_DIR", "$(PROJECT_TEMP_DIR)/$(CONFIGURATION)$(EFFECTIVE_PLATFORM_NAME)");
        return dictionary;
    }

    private static void j(Dictionary dictionary, @NonNls @NotNull String string, @NonNls @NotNull String string2) {
        if (string == null) {
            AppleSdkManager.N(8);
        }
        if (string2 == null) {
            AppleSdkManager.N(9);
        }
        dictionary.setAttribute(string, (string2 = string2.trim()).contains(" ") ? "\"" + StringUtil.escapeQuotes((String)string2) + "\"" : string2);
    }

    @NotNull
    public List<ApplePlatform> getPlatforms() {
        List<ApplePlatform> list = this.mySortedPlatforms;
        if (list == null) {
            AppleSdkManager.N(10);
        }
        return list;
    }

    @Nullable
    public ApplePlatform findPlatformByName(@Nullable String platformName) {
        if (platformName == null) {
            return null;
        }
        for (ApplePlatform applePlatform : this.mySortedPlatforms) {
            if (!applePlatform.getName().equals(platformName)) continue;
            return applePlatform;
        }
        return null;
    }

    @Nullable
    public ApplePlatform findPlatformByType(@Nullable ApplePlatform.Type type) {
        if (type == null) {
            return null;
        }
        for (ApplePlatform applePlatform : this.mySortedPlatforms) {
            if (applePlatform.getType() != type) continue;
            return applePlatform;
        }
        return null;
    }

    @Nullable
    public ApplePlatform findPlatformBySettingValue(@Nullable String settingValue) {
        return this.findPlatformByType(AppleSdkManager.getPlatformTypeBySettingValue(settingValue));
    }

    @Nullable
    public ApplePlatform findPlatformByID(@NotNull String identifier) {
        if (identifier == null) {
            AppleSdkManager.N(11);
        }
        for (ApplePlatform applePlatform : this.mySortedPlatforms) {
            if (!identifier.equalsIgnoreCase(applePlatform.getIdentifier())) continue;
            return applePlatform;
        }
        return null;
    }

    @NotNull
    public static ApplePlatform.Type getPlatformTypeBySettingValue(@Nullable String value2) {
        if (value2 != null) {
            for (ApplePlatform.Type type : ApplePlatform.Type.values()) {
                if (!value2.startsWith(type.getPlatformName())) continue;
                ApplePlatform.Type type2 = type;
                if (type2 == null) {
                    AppleSdkManager.N(12);
                }
                return type2;
            }
        }
        ApplePlatform.Type type = ApplePlatform.Type.MACOS;
        if (type == null) {
            AppleSdkManager.N(13);
        }
        return type;
    }

    @NotNull
    public List<AppleSdk> getSdks() {
        List<AppleSdk> list = this.mySortedSdks;
        if (list == null) {
            AppleSdkManager.N(14);
        }
        return list;
    }

    @NotNull
    public List<AppleSdk> getSwiftSdks() {
        List<AppleSdk> list = this.mySwiftPackageSdks;
        if (list == null) {
            AppleSdkManager.N(15);
        }
        return list;
    }

    @NotNull
    private static List<AppleSdk> j(@NotNull List<AppleSdk> list) {
        if (list == null) {
            AppleSdkManager.N(16);
        }
        ArrayList<AppleSdk> arrayList = new ArrayList<AppleSdk>();
        for (AppleSdk appleSdk : list) {
            ApplePlatform applePlatform = appleSdk.getPlatform();
            if (applePlatform.getFamilyIdentifier().equals("driverkit") || applePlatform.getFamilyIdentifier().equals("xros")) continue;
            if (applePlatform.isIOS() || applePlatform.isTv()) {
                arrayList.add(appleSdk);
                continue;
            }
            if (!applePlatform.isMacOS()) continue;
            arrayList.add(appleSdk);
            AppleSdk appleSdk2 = appleSdk.getCatalystVariant();
            if (appleSdk2 == null) continue;
            arrayList.add(appleSdk2);
        }
        ArrayList<AppleSdk> arrayList2 = arrayList;
        if (arrayList2 == null) {
            AppleSdkManager.N(17);
        }
        return arrayList2;
    }

    @Override
    @Nullable
    public AppleSdk getHostSwiftSdk() {
        return this.getDefaultSdk();
    }

    @Nullable
    public AppleSdk getDefaultSdk() {
        return (AppleSdk)ContainerUtil.find(this.findSdksForPlatform(ApplePlatform.Type.MACOS), appleSdk -> appleSdk.getName().startsWith("macosx"));
    }

    @Override
    @Nullable
    public AppleSdk findSdk(@NotNull String name) {
        if (name == null) {
            AppleSdkManager.N(18);
        }
        for (AppleSdk appleSdk : this.mySortedSdks) {
            if (!name.equals(appleSdk.getName())) continue;
            return appleSdk;
        }
        return null;
    }

    @Nullable
    public AppleSdk findSdkByRootFile(@Nullable VirtualFile root) {
        return AppleSdkManager.j(root != null ? root.getCanonicalFile() : null, this.mySortedSdks);
    }

    @Nullable
    private static AppleSdk j(@Nullable VirtualFile virtualFile2, @NotNull List<AppleSdk> list) {
        if (list == null) {
            AppleSdkManager.N(19);
        }
        if (virtualFile2 == null) {
            return null;
        }
        for (AppleSdk appleSdk : list) {
            if (!virtualFile2.equals(appleSdk.getRoot())) continue;
            return appleSdk;
        }
        return null;
    }

    @Nullable
    public AppleSdk findSdkBySettingValue(@Nullable String value2) {
        if (StringUtil.isEmptyOrSpaces((String)value2)) {
            return this.getDefaultSdk();
        }
        AppleSdk appleSdk = this.findSdk(value2);
        if (appleSdk != null) {
            return appleSdk;
        }
        ApplePlatform applePlatform = this.findPlatformByName(value2);
        if (applePlatform != null) {
            return (AppleSdk)ContainerUtil.getFirstItem(applePlatform.getSdks());
        }
        return this.findSdkByPath(value2);
    }

    @Override
    @Nullable
    public AppleSdk findSdkByPath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        try {
            path = new File(path).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (AppleSdk appleSdk : this.mySortedSdks) {
            if (!FileUtil.pathsEqual((String)appleSdk.getRoot().getPath(), (String)path)) continue;
            return appleSdk;
        }
        return null;
    }

    @NotNull
    public List<AppleSdk> findSdksForPlatformName(@NotNull String name) {
        if (name == null) {
            AppleSdkManager.N(20);
        }
        List<AppleSdk> list = this.findSdksForPlatform(AppleSdkManager.getPlatformTypeBySettingValue(name));
        if (list == null) {
            AppleSdkManager.N(21);
        }
        return list;
    }

    @NotNull
    public List<AppleSdk> findSdksForPlatform(@Nullable ApplePlatform.Type type) {
        if (type == null) {
            List<AppleSdk> list = Collections.emptyList();
            if (list == null) {
                AppleSdkManager.N(22);
            }
            return list;
        }
        SmartList smartList = new SmartList();
        for (AppleSdk appleSdk : this.mySortedSdks) {
            if (type != appleSdk.getPlatformType()) continue;
            smartList.add(appleSdk);
        }
        List<AppleSdk> list = Collections.unmodifiableList(smartList);
        if (list == null) {
            AppleSdkManager.N(23);
        }
        return list;
    }

    @NotNull
    public static String getStandardNativeArchitectureId(@Nullable ApplePlatform platform) {
        AppleArchitecture appleArchitecture;
        if (platform != null && (appleArchitecture = platform.getStandardNativeArchitecture()) != null) {
            List<String> list = appleArchitecture.getRealArchitectures();
            if (list.contains(ArchitectureValue.HOST_ARCH.getId())) {
                String string = ArchitectureValue.HOST_ARCH.getId();
                if (string == null) {
                    AppleSdkManager.N(24);
                }
                return string;
            }
            String string = (String)ContainerUtil.getFirstItem(list);
            if (string != null) {
                String string2 = string;
                if (string2 == null) {
                    AppleSdkManager.N(25);
                }
                return string2;
            }
        }
        return AppleSdkManager.getActualMacOSNativeArchitectureId();
    }

    @NotNull
    @NonNls
    public static String getActualMacOSNativeArchitectureId() {
        String string = ArchitectureValue.HOST_ARCH.getId();
        if (string == null) {
            AppleSdkManager.N(26);
        }
        return string;
    }

    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable AppleBuildSystem.Type type) {
        return this.myBuildSystemProvider.findBuildSystem(type, this.myBuildSystemProvider.getDomain());
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable AppleBuildSystem.Type type, @Nullable String domain) {
        return this.myBuildSystemProvider.findBuildSystem(type, domain);
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable String id, @Nullable String domain) {
        return this.myBuildSystemProvider.findBuildSystem(id, domain);
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystemByRef(@Nullable String ref) {
        return this.myBuildSystemProvider.findBuildSystemByRef(ref);
    }

    @Override
    @NotNull
    public List<AppleBuildSystem> getBuildSystems() {
        List<AppleBuildSystem> list = this.myBuildSystemProvider.getBuildSystems();
        if (list == null) {
            AppleSdkManager.N(27);
        }
        return list;
    }

    @Override
    @Nullable
    public String getDomain() {
        return this.myBuildSystemProvider.getDomain();
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.myBuiltInBuildSettings;
        if (dictionary == null) {
            AppleSdkManager.N(28);
        }
        return dictionary;
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 2, 3, 4, 5, 8, 9, 11, 16, 18, 19, 20 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/AppleSdkManager";
                break;
            }
            case 1: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformDomains";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsManager";
                break;
            }
            case 8: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/AppleSdkManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecsFolders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatforms";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformTypeBySettingValue";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdks";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwiftSdks";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSwiftPackageSdks";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findSdksForPlatformName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findSdksForPlatform";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardNativeArchitectureId";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualMacOSNativeArchitectureId";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSystems";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateSortedSdks";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readPlatforms";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSdksFrom";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readBuildSystems";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBuildSettingPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPlatformByID";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterSwiftPackageSdks";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findSdk";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByRootFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findSdksForPlatformName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 8, 9, 11, 16, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }
}

