/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.apple.sdk.AppleSdkBase;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingsProvider;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AppleSdk
extends AppleSdkBase
implements BuildSettingValuesProvider {
    @NonNls
    public static final String[] DEFAULT_INCLUDE_PATHS = new String[]{"usr/include"};
    @NonNls
    public static final String[] DEFAULT_LIBRARIES_PATHS = new String[]{"usr/lib"};
    @NonNls
    public static final String[] DEFAULT_FRAMEWORK_PATHS = new String[]{"System/Library/Frameworks", "Library/Frameworks"};
    @NonNls
    public static final String[] DEVELOPER_FRAMEWORK_PATHS = new String[]{"Library/Frameworks"};
    @NonNls
    private static final String CATALYST_SDK_VARIANT = "iosmac";
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final String myCanonicalName;
    @NotNull
    @NlsSafe
    private final String myDisplayName;
    @NotNull
    private final String myVersionString;
    @NotNull
    private final String myFullVersion;
    @Nullable
    private final String myBuildVersion;
    @NotNull
    private final ApplePlatform myPlatform;
    @NotNull
    private final Dictionary myDeclaredBuildSettings;
    @Nullable
    @NlsSafe
    private final String myVariant;
    @NotNull
    private final Map<String, AppleSdk> myVariantsMap;
    private final boolean myIsDefaultVariant;
    private final String myUniqueId;
    private final String myDefaultLLVMTargetTripleBase;

    private AppleSdk(@NotNull VirtualFile root, @NotNull String canonicalName, @NotNull String displayName2, @NotNull String versionString, @NotNull String fullVersion, @Nullable String buildVersion, @NotNull ApplePlatform platform, @NotNull Dictionary declaredBuildSettings, @Nullable String sdkVariant, @NotNull String defaultLLVMTargetTripleBase, boolean isDefaultVariant, @NotNull Map<String, AppleSdk> variantsMap) {
        if (root == null) {
            AppleSdk.j(0);
        }
        if (canonicalName == null) {
            AppleSdk.j(1);
        }
        if (displayName2 == null) {
            AppleSdk.j(2);
        }
        if (versionString == null) {
            AppleSdk.j(3);
        }
        if (fullVersion == null) {
            AppleSdk.j(4);
        }
        if (platform == null) {
            AppleSdk.j(5);
        }
        if (declaredBuildSettings == null) {
            AppleSdk.j(6);
        }
        if (defaultLLVMTargetTripleBase == null) {
            AppleSdk.j(7);
        }
        if (variantsMap == null) {
            AppleSdk.j(8);
        }
        this.myRoot = root;
        this.myCanonicalName = canonicalName;
        this.myDisplayName = displayName2;
        this.myVersionString = versionString;
        this.myFullVersion = fullVersion;
        this.myBuildVersion = buildVersion;
        this.myPlatform = platform;
        this.myVariant = sdkVariant;
        this.myDeclaredBuildSettings = declaredBuildSettings;
        this.myIsDefaultVariant = isDefaultVariant;
        this.myVariantsMap = variantsMap;
        this.myDefaultLLVMTargetTripleBase = defaultLLVMTargetTripleBase;
        this.myUniqueId = this.myCanonicalName + ":" + this.myVariant + ":" + this.myFullVersion;
    }

    @Nullable
    public AppleSdk getCatalystVariant() {
        return this.getVariant(CATALYST_SDK_VARIANT);
    }

    @Nullable
    public AppleSdk getVariant(@NotNull String variant) {
        if (variant == null) {
            AppleSdk.j(9);
        }
        return this.myVariantsMap.get(variant);
    }

    @Override
    public boolean isMacCatalyst() {
        return this.getPlatform().isMacOS() && CATALYST_SDK_VARIANT.equals(this.myVariant);
    }

    @Override
    public boolean isIOSDevice() {
        return this.getPlatform().isIOSDevice();
    }

    @Override
    public boolean isIOSSimulator() {
        return this.getPlatform().isIOSSimulator();
    }

    @Override
    public boolean isTvDevice() {
        return this.getPlatform().isTvDevice();
    }

    @Override
    public boolean isTvSimulator() {
        return this.getPlatform().isTvSimulator();
    }

    @Override
    public boolean isVisionDevice() {
        return this.getPlatform().isVisionDevice();
    }

    @Override
    public boolean isVisionSimulator() {
        return this.getPlatform().isVisionSimulator();
    }

    @Override
    public boolean isWatchDevice() {
        return this.getPlatform().isWatchDevice();
    }

    @Override
    public boolean isWatchSimulator() {
        return this.getPlatform().isWatchSimulator();
    }

    @Override
    public boolean isMacOS() {
        return this.getPlatform().isMacOS();
    }

    @Override
    public boolean isLinux() {
        return false;
    }

    @Override
    public boolean isWindows() {
        return false;
    }

    @Override
    @NotNull
    public String getUniqueID() {
        String string = this.myUniqueId;
        if (string == null) {
            AppleSdk.j(10);
        }
        return string;
    }

    @NotNull
    public static AppleSdk createFromSpec(@NotNull VirtualFile root, @NotNull Plist spec, @NotNull AppleSdkManager manager) throws InvalidSpecException {
        if (root == null) {
            AppleSdk.j(11);
        }
        if (spec == null) {
            AppleSdk.j(12);
        }
        if (manager == null) {
            AppleSdk.j(13);
        }
        Object object = spec.getString("CanonicalName");
        String string = spec.getString("DisplayName");
        Dictionary dictionary = AppleSdk.j(spec);
        @NonNls String string2 = dictionary.getString("PLATFORM_NAME");
        String string3 = spec.getString("Version");
        String string4 = spec.getString("DefaultVariant");
        if (object == null || string == null) {
            string = spec.getString("name");
            string2 = "macosx";
            string3 = spec.getString("MaximumDeploymentTarget");
            object = string2 + string3;
        }
        if (string == null || string2 == null || string3 == null) {
            throw InvalidSpecException.unexpectedPListFormat(spec);
        }
        File file2 = new File(root.getPath(), "System/Library/CoreServices/SystemVersion.plist");
        Plist plist = file2.exists() ? PlistDriver.readAnyFormatSafe(file2) : null;
        String string5 = null;
        String string6 = null;
        if (plist != null) {
            string5 = plist.getString("ProductVersion");
            string6 = plist.getString("ProductBuildVersion");
        }
        string5 = string5 == null ? string3 : string5;
        ApplePlatform applePlatform2 = manager.findPlatformByName(string2);
        if (applePlatform2 == null) {
            List<ApplePlatform> list = manager.getPlatforms();
            String string7 = list.isEmpty() ? "<none>" : "\n" + StringUtil.join(list, applePlatform -> applePlatform.toString(), (String)"\n");
            throw new InvalidSpecException("Platform '" + string2 + "' not found. Available:" + string7);
        }
        Map<String, Couple<String>> map = AppleSdk.j(spec, (String)object);
        HashMap<String, AppleSdk> hashMap = new HashMap<String, AppleSdk>();
        for (Pair<String, Dictionary> pair2 : AppleSdk.j(spec)) {
            String string8 = (String)pair2.first;
            Dictionary dictionary2 = (Dictionary)pair2.second;
            Dictionary dictionary3 = AppleSdk.j(dictionary, dictionary2);
            dictionary3.put("SDK_NAME", object);
            boolean bl = Objects.equals(string4, string8);
            Couple<String> couple = AppleSdk.j((String)object, bl ? string2 : string8, map);
            String string9 = (String)couple.first;
            String string10 = (String)couple.second;
            if (XcodeBase.getInstance().getVersion().isOrGreaterThan(Integer.valueOf(14))) {
                dictionary3.put("SWIFT_PLATFORM_TARGET_PREFIX", (Object)string10);
            }
            AppleSdk appleSdk = new AppleSdk(root, (String)object, string, string3, string5, string6, applePlatform2, dictionary3, string8, string9, bl, hashMap);
            hashMap.put(string8, appleSdk);
        }
        AppleSdk appleSdk = (AppleSdk)hashMap.get(string4);
        if (appleSdk == null) {
            AppleSdk.j(14);
        }
        return appleSdk;
    }

    @NotNull
    private static Couple<String> j(@NotNull String string, @Nullable String string2, @NotNull Map<String, Couple<String>> map) {
        Couple couple;
        if (string == null) {
            AppleSdk.j(15);
        }
        if (map == null) {
            AppleSdk.j(16);
        }
        if ((couple = string2 != null ? map.get(string2) : (Couple)ContainerUtil.getFirstItem(map.values())) == null) {
            XCLog.LOG.warn("Can't infer default LLVM triple base for sdk " + string + " variant " + string2);
            couple = Couple.of((Object)"unknown", (Object)"");
        }
        Couple couple2 = couple;
        if (couple2 == null) {
            AppleSdk.j(17);
        }
        return couple2;
    }

    @NotNull
    private static Map<String, Couple<String>> j(@NotNull Plist plist, @NotNull String string) {
        if (plist == null) {
            AppleSdk.j(18);
        }
        if (string == null) {
            AppleSdk.j(19);
        }
        Dictionary dictionary = plist.getDictionary("SupportedTargets", Dictionary.EMPTY_DICTIONARY);
        HashMap<String, Couple<String>> hashMap = new HashMap<String, Couple<String>>();
        for (Map.Entry<String, Object> entry2 : dictionary.entrySet()) {
            Object object;
            Object object2 = entry2.getValue();
            if (!(object2 instanceof Dictionary)) continue;
            Dictionary dictionary2 = (Dictionary)object2;
            String string2 = entry2.getKey();
            String string3 = dictionary2.getString("LLVMTargetTripleVendor", "unknown");
            String string4 = dictionary2.getString("DefaultDeploymentTarget", "");
            String string5 = dictionary2.getString("LLVMTargetTripleSys", "unknown");
            Object object3 = AppleSdk.j(plist).getString("LLVM_TARGET_TRIPLE_SUFFIX");
            if (object3 == null && (object = StringUtil.nullize((String)dictionary2.getString("LLVMTargetTripleEnvironment"))) != null) {
                object3 = "-" + (String)object;
            }
            if (((String)(object = string3 + "-" + string5 + string4 + StringUtil.notNullize((String)object3))).contains("unknown")) {
                XCLog.LOG.warn("Failed to infer default LLVM triple base value for " + string + " for target " + string2);
            }
            hashMap.put(string2, (Couple<String>)Couple.of((Object)object, (Object)string5));
        }
        HashMap<String, Couple<String>> hashMap2 = hashMap;
        if (hashMap2 == null) {
            AppleSdk.j(20);
        }
        return hashMap2;
    }

    @NonNls
    @NotNull
    private static Dictionary j(@NotNull Plist plist) {
        if (plist == null) {
            AppleSdk.j(21);
        }
        Dictionary dictionary = plist.getDictionary("DefaultProperties", Dictionary.EMPTY_DICTIONARY);
        if (dictionary == null) {
            AppleSdk.j(22);
        }
        return dictionary;
    }

    @Override
    @NotNull
    public String getDefaultLLVMTargetTripleBase() {
        String string = this.myDefaultLLVMTargetTripleBase;
        if (string == null) {
            AppleSdk.j(23);
        }
        return string;
    }

    @Override
    @NotNull
    public File getPlatformRootSubFilePath(@NotNull String relativePath) {
        if (relativePath == null) {
            AppleSdk.j(24);
        }
        File file2 = this.getPlatform().getRootSubFile(relativePath);
        if (file2 == null) {
            AppleSdk.j(25);
        }
        return file2;
    }

    @NotNull
    private static List<Pair<String, Dictionary>> j(@NotNull Plist plist) {
        if (plist == null) {
            AppleSdk.j(26);
        }
        List<Dictionary> list = plist.getAttributeList("Variants", Dictionary.class, Collections.emptyList());
        ArrayList<Pair<String, Dictionary>> arrayList = new ArrayList<Pair<String, Dictionary>>();
        for (Dictionary dictionary : list) {
            String string = dictionary.getString("Name");
            Dictionary dictionary2 = dictionary.getDictionary("BuildSettings", Dictionary.EMPTY_DICTIONARY);
            if (string == null) continue;
            arrayList.add((Pair<String, Dictionary>)Pair.create((Object)string, (Object)dictionary2));
        }
        if (arrayList.isEmpty()) {
            arrayList.add((Pair<String, Dictionary>)Pair.create(null, (Object)Dictionary.EMPTY_DICTIONARY));
        }
        ArrayList<Pair<String, Dictionary>> arrayList2 = arrayList;
        if (arrayList2 == null) {
            AppleSdk.j(27);
        }
        return arrayList2;
    }

    @NotNull
    private static Dictionary j(@NotNull Dictionary dictionary, @Nullable Dictionary dictionary2) {
        if (dictionary == null) {
            AppleSdk.j(28);
        }
        Dictionary dictionary3 = new Dictionary();
        dictionary3.putAll(dictionary);
        if (dictionary2 != null) {
            dictionary3.putAll(dictionary2);
        }
        Dictionary dictionary4 = dictionary3;
        if (dictionary4 == null) {
            AppleSdk.j(29);
        }
        return dictionary4;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile2 = this.myRoot;
        if (virtualFile2 == null) {
            AppleSdk.j(30);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    @NonNls
    public String getName() {
        String string = this.myCanonicalName;
        if (string == null) {
            AppleSdk.j(31);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getMajorVersionString() {
        Version version = Version.parseVersion((String)this.myVersionString);
        String string = version != null ? Version.toCompactString((int)version.major, (int)version.minor, (int)0) : this.myVersionString;
        if (string == null) {
            AppleSdk.j(32);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getVersionString() {
        String string = this.myVersionString;
        if (string == null) {
            AppleSdk.j(33);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getFullVersion() {
        String string = this.myFullVersion;
        if (string == null) {
            AppleSdk.j(34);
        }
        return string;
    }

    @Override
    @Nullable
    @NlsSafe
    public String getBuildVersion() {
        return this.myBuildVersion;
    }

    public boolean isDeploymentTargetValid(@NotNull String deploymentTarget) {
        if (deploymentTarget == null) {
            AppleSdk.j(35);
        }
        return StringUtil.compareVersionNumbers((String)this.myFullVersion, (String)deploymentTarget) >= 0;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getDisplayName() {
        Object object = this.myIsDefaultVariant ? this.myDisplayName : this.myDisplayName + " (" + this.myVariant + ")";
        if (object == null) {
            AppleSdk.j(36);
        }
        return object;
    }

    @NotNull
    @NlsSafe
    public String getShortDisplayName() {
        String string = this.getDisplayName().replaceFirst("Simulator", "Sim");
        if (string == null) {
            AppleSdk.j(37);
        }
        return string;
    }

    @NotNull
    public ApplePlatform getPlatform() {
        ApplePlatform applePlatform = this.myPlatform;
        if (applePlatform == null) {
            AppleSdk.j(38);
        }
        return applePlatform;
    }

    @Override
    @Nullable
    public String getVariant() {
        return this.myVariant;
    }

    @NotNull
    public ApplePlatform.Type getPlatformType() {
        ApplePlatform.Type type = this.myPlatform.getType();
        if (type == null) {
            AppleSdk.j(39);
        }
        return type;
    }

    @NotNull
    public AppleSdk getBaseSdk() {
        AppleSdk appleSdk;
        ApplePlatform applePlatform = this.myPlatform.getBasePlatform();
        if (this.myPlatform != applePlatform && (appleSdk = applePlatform.findSuitableSdk(this)) != null) {
            AppleSdk appleSdk2 = appleSdk;
            if (appleSdk2 == null) {
                AppleSdk.j(40);
            }
            return appleSdk2;
        }
        AppleSdk appleSdk3 = this;
        if (appleSdk3 == null) {
            AppleSdk.j(41);
        }
        return appleSdk3;
    }

    @NotNull
    public List<File> getAllFrameworkSearchPaths() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)this.getRoot());
        for (String string : DEFAULT_FRAMEWORK_PATHS) {
            arrayList.add(new File(file2, string));
        }
        File file3 = new File(file2, "Developer");
        for (String string : DEVELOPER_FRAMEWORK_PATHS) {
            arrayList.add(new File(file3, string));
        }
        ApplePlatform applePlatform = this.getPlatform();
        for (File file4 : applePlatform.getDeveloperRoots()) {
            for (String string : DEVELOPER_FRAMEWORK_PATHS) {
                arrayList.add(new File(file4, string));
            }
        }
        ArrayList<File> arrayList2 = arrayList;
        if (arrayList2 == null) {
            AppleSdk.j(42);
        }
        return arrayList2;
    }

    public boolean processFrameworkFiles(Processor<VirtualFile> processor) {
        return AppleSdk.j(processor, "framework", this.myRoot, DEFAULT_FRAMEWORK_PATHS);
    }

    public boolean processLibraryFiles(Processor<VirtualFile> processor) {
        return AppleSdk.j(processor, "dylib", this.myRoot, DEFAULT_LIBRARIES_PATHS);
    }

    public static boolean processDeveloperFrameworkFiles(BuildSettingsProvider settingsProvider, Processor<VirtualFile> processor) {
        VirtualFile virtualFile2;
        String string = settingsProvider.getBuildSetting("DEVELOPER_DIR").getAbsolutePath();
        VirtualFile virtualFile3 = virtualFile2 = string != null ? StandardFileSystems.local().findFileByPath(string) : null;
        if (virtualFile2 != null) {
            return AppleSdk.j(processor, "framework", virtualFile2, DEVELOPER_FRAMEWORK_PATHS);
        }
        return true;
    }

    private static boolean j(@NotNull Processor<VirtualFile> processor, @NotNull @NonNls String string, @NotNull VirtualFile virtualFile2, String[] stringArray) {
        if (processor == null) {
            AppleSdk.j(43);
        }
        if (string == null) {
            AppleSdk.j(44);
        }
        if (virtualFile2 == null) {
            AppleSdk.j(45);
        }
        for (String string2 : stringArray) {
            VirtualFile virtualFile3 = virtualFile2.findFileByRelativePath(string2);
            if (virtualFile3 == null) continue;
            for (VirtualFile virtualFile4 : virtualFile3.getChildren()) {
                if (!string.equals(virtualFile4.getExtension()) || processor.process((Object)virtualFile4)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.myDeclaredBuildSettings;
        if (dictionary == null) {
            AppleSdk.j(46);
        }
        return dictionary;
    }

    @Override
    @NotNull
    public String getHomePath() {
        String string = this.myRoot.getPath();
        if (string == null) {
            AppleSdk.j(47);
        }
        return string;
    }

    @NotNull
    public VirtualFile getHomeDirectory() {
        VirtualFile virtualFile2 = this.myRoot;
        if (virtualFile2 == null) {
            AppleSdk.j(48);
        }
        return virtualFile2;
    }

    @NotNull
    public File getSubFile(@NonNls @Nullable String relativePath) {
        return relativePath == null ? new File(this.getHomePath()) : new File(this.getHomePath(), relativePath);
    }

    @NotNull
    public String getSubFilePath(@NonNls @Nullable String relativePath) {
        String string = this.getSubFile(relativePath).getPath();
        if (string == null) {
            AppleSdk.j(49);
        }
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.myDisplayName).append(" (").append(this.myCanonicalName);
        if (this.myVariant != null) {
            stringBuilder.append(":").append(this.myVariant);
        }
        stringBuilder.append(" ").append(this.myFullVersion);
        if (this.myBuildVersion != null) {
            stringBuilder.append(":").append(this.myBuildVersion);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(@NotNull AppleSdkBase other) {
        if (other == null) {
            AppleSdk.j(50);
        }
        if (!(other instanceof AppleSdk)) {
            return 1;
        }
        AppleSdk appleSdk = (AppleSdk)other;
        int n2 = this.getPlatform().compareTo(appleSdk.getPlatform());
        if (n2 != 0) {
            return n2;
        }
        if (this.getPlatformType() == ApplePlatform.Type.MACOS && (this.getPlatform().getFamilyIdentifier().equals("driverkit") || this.getPlatform().getFamilyIdentifier().equals("xros"))) {
            return 1;
        }
        if (appleSdk.getPlatformType() == ApplePlatform.Type.MACOS && (appleSdk.getPlatform().getFamilyIdentifier().equals("driverkit") || appleSdk.getPlatform().getFamilyIdentifier().equals("xros"))) {
            return -1;
        }
        return StringUtil.compareVersionNumbers((String)appleSdk.getVersionString(), (String)this.getVersionString());
    }

    @NotNull
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    @NlsSafe
    public String getPlatformName() {
        String string = this.getPlatform().getName();
        if (string == null) {
            AppleSdk.j(51);
        }
        return string;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 10, 14, 17, 20, 22, 23, 25, 27, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 46, 47, 48, 49, 51 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredBuildSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultLLVMTargetTripleBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantsMap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/AppleSdk";
                break;
            }
            case 12: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "llvmTargetInfo";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDictionary";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentTarget";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/AppleSdk";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueID";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromSpec";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTargetTripleBase";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLLVMTargetInfo";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLLVMTargetTripleBase";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformRootSubFilePath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBuildSettingsForSDKVariants";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeDictionaries";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorVersionString";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionString";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullVersion";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortDisplayName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseSdk";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFrameworkSearchPaths";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeDirectory";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFilePath";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVariant";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFromSpec";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTargetTripleBase";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLLVMTargetInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProperties";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformRootSubFilePath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectBuildSettingsForSDKVariants";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "mergeDictionaries";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isDeploymentTargetValid";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processFiles";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 10, 14, 17, 20, 22, 23, 25, 27, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 46, 47, 48, 49, 51 -> new IllegalStateException(string);
        };
    }
}

