/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.frameworks.ApplePackageType;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProviderWithBase;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppleProductType
implements BuildSettingValuesProvider {
    @NonNls
    public static final String TOOL_TYPE_ID = "com.apple.product-type.tool";
    @NonNls
    public static final String APPLICATION_TYPE_ID = "com.apple.product-type.application";
    @NonNls
    public static final String APPLICATION_EXTENSION_TYPE_ID = "com.apple.product-type.app-extension";
    @NonNls
    public static final String TV_APPLICATION_EXTENSION_TYPE_ID = "com.apple.product-type.tv-app-extension";
    @NonNls
    public static final String FRAMEWORK_TYPE_ID = "com.apple.product-type.framework";
    @NonNls
    public static final String STATIC_LIBRARY_TYPE_ID = "com.apple.product-type.library.static";
    @NonNls
    public static final String BUNDLE_TYPE_ID = "com.apple.product-type.bundle";
    @NonNls
    public static final String UNIT_TEST_TYPE_ID = "com.apple.product-type.bundle.unit-test";
    @NonNls
    public static final String UI_UNIT_TEST_TYPE_ID = "com.apple.product-type.bundle.ui-testing";
    @NotNull
    private final ApplePlatform myPlatform;
    @NotNull
    private final String myId;
    @Nullable
    private final String myBasedOn;
    @Nullable
    private final String myName;
    @Nullable
    private final String myDescription;
    @Nullable
    private final String myDefaultTargetName;
    @Nullable
    private final String myIconNamePrefix;
    @Nullable
    private final String myDomain;
    @NotNull
    private final List<String> myPackageTypes;
    @NotNull
    private final List<Dictionary> myBuildPhaseInjections;
    @NotNull
    private final Dictionary myBuildSettings;
    @NotNull
    private final BuildSettingValuesProvider mySettingsValuesProvider;

    AppleProductType(@NotNull Plist plist, @NotNull ApplePlatform platform) {
        if (plist == null) {
            AppleProductType.j(0);
        }
        if (platform == null) {
            AppleProductType.j(1);
        }
        this.myPlatform = platform;
        this.myId = plist.getNotNullString("Identifier");
        this.myBasedOn = plist.getString("BasedOn");
        this.myName = plist.getString("Name");
        this.myDescription = plist.getString("Description");
        this.myDefaultTargetName = plist.getString("DefaultTargetName");
        this.myIconNamePrefix = plist.getString("IconNamePrefix");
        this.myDomain = plist.getString("Domain");
        this.myPackageTypes = plist.getAttributeList("PackageTypes", String.class, Collections.emptyList());
        this.myBuildPhaseInjections = plist.getAttributeList("BuildPhaseInjectionsWhenEmbedding", Dictionary.class, Collections.emptyList());
        this.myBuildSettings = plist.getDictionary("DefaultBuildProperties", new Dictionary());
        this.mySettingsValuesProvider = new BuildSettingValuesProviderWithBase(){

            @Override
            protected BuildSettingValuesProvider getBase() {
                return AppleProductType.this.getBaseType();
            }

            @Override
            @NotNull
            protected Dictionary getSettings() {
                Dictionary dictionary = AppleProductType.this.myBuildSettings;
                if (dictionary == null) {
                    1.N(0);
                }
                return dictionary;
            }

            private static /* synthetic */ void N(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/AppleProductType$1", "getSettings"));
            }
        };
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            AppleProductType.j(2);
        }
        return string;
    }

    @Nullable
    public AppleProductType getBaseType() {
        return this.myPlatform.findProductType(this.myBasedOn);
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public String getDefaultTargetName() {
        if (this.myDefaultTargetName != null) {
            return this.myDefaultTargetName;
        }
        AppleProductType appleProductType = this.getBaseType();
        return appleProductType == null ? null : appleProductType.getDefaultTargetName();
    }

    @Nullable
    public String getIconNamePrefix() {
        return this.myIconNamePrefix;
    }

    @Nullable
    public String getDomain() {
        return this.myDomain;
    }

    @NotNull
    public List<ApplePackageType> getPackageTypes() {
        ArrayList<ApplePackageType> arrayList = new ArrayList<ApplePackageType>(this.myPackageTypes.size());
        for (String string : this.myPackageTypes) {
            arrayList.add(this.myPlatform.findPackageType(string));
        }
        AppleProductType appleProductType = this.getBaseType();
        if (appleProductType != null) {
            arrayList.addAll(appleProductType.getPackageTypes());
        }
        List<ApplePackageType> list = Collections.unmodifiableList(arrayList);
        if (list == null) {
            AppleProductType.j(3);
        }
        return list;
    }

    @Nullable
    public ApplePackageType getDefaultPackageType() {
        AppleProductType appleProductType;
        String string = (String)ContainerUtil.getFirstItem(this.myPackageTypes, null);
        if (string == null && (appleProductType = this.getBaseType()) != null) {
            return appleProductType.getDefaultPackageType();
        }
        return this.myPlatform.findPackageType(string);
    }

    @NotNull
    public List<Dictionary> getBuildPhaseInjections() {
        List<Dictionary> list = Collections.unmodifiableList(this.myBuildPhaseInjections);
        if (list == null) {
            AppleProductType.j(4);
        }
        return list;
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.mySettingsValuesProvider.getDeclaredBuildSettingValues();
        if (dictionary == null) {
            AppleProductType.j(5);
        }
        return dictionary;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.myId);
        if (this.myBasedOn != null) {
            stringBuilder.append("(").append(this.myBasedOn).append(")");
        }
        stringBuilder.append(": ").append(this.myName);
        return stringBuilder.toString();
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/AppleProductType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/AppleProductType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildPhaseInjections";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

