/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeBase;
import com.jetbrains.cidr.xcode.frameworks.AppleArchitecture;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.ApplePackageType;
import com.jetbrains.cidr.xcode.frameworks.AppleProductType;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.SpecListHelper;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystem;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleBuildSystemProviderImpl;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.AppleCompiler;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.BuildSettingValuesProvider;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAndID;
import com.jetbrains.cidr.xcode.frameworks.buildSystem.DomainAwareKt;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.xcspec.XCSpecFile;
import com.jetbrains.cidr.xcode.xcspec.XcodeExtensionsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplePlatform
implements AppleBuildSystemProvider,
BuildSettingValuesProvider,
Comparable<ApplePlatform> {
    @NonNls
    private static final String IDEPLUGIN_EXTENSION = "ideplugin";
    private static final Map<Type, Type> BASE_PLATFORMS = ImmutableMap.of((Object)((Object)Type.IOS_SIMULATOR), (Object)((Object)Type.IOS), (Object)((Object)Type.WATCH_SIMULATOR), (Object)((Object)Type.WATCH), (Object)((Object)Type.TVOS_SIMULATOR), (Object)((Object)Type.TVOS), (Object)((Object)Type.VISION_SIMULATOR), (Object)((Object)Type.VISION));
    @NotNull
    private final File myRoot;
    @NotNull
    private final AppleSdkManager myManager;
    @NotNull
    private final String myName;
    @NotNull
    private final String myFamilyDisplayName;
    @NotNull
    private final String myFamilyIdentifier;
    @NotNull
    private final String myVersion;
    @NotNull
    private final String myIdentifier;
    @NotNull
    private final Type myType;
    @NotNull
    private final Dictionary myDeclaredBuildSettingValues;
    @NotNull
    private List<AppleArchitecture> myArchitectures;
    @NotNull
    private List<AppleProductType> myProductTypes;
    @NotNull
    private List<ApplePackageType> myPackageTypes;
    @NotNull
    private List<AppleBuildSystem> myBuildSystems;
    @NotNull
    private List<AppleCompiler> myCompilers;
    @NotNull
    private final Map<Pair<AppleFileType, String>, List<AppleCompiler>> myFileTypeToCompilersCache;
    @NotNull
    private final AppleBuildSystemProviderImpl myBuildSystemProvider;

    @NotNull
    public String getFamilyIdentifier() {
        String string = this.myFamilyIdentifier;
        if (string == null) {
            ApplePlatform.j(0);
        }
        return string;
    }

    ApplePlatform(@NotNull File root, @NotNull Plist spec, @NotNull AppleSdkManager manager) throws InvalidSpecException {
        if (root == null) {
            ApplePlatform.j(1);
        }
        if (spec == null) {
            ApplePlatform.j(2);
        }
        if (manager == null) {
            ApplePlatform.j(3);
        }
        this.myRoot = root;
        this.myManager = manager;
        @NonNls String string = spec.getString("Type");
        if (!"Platform".equals(string)) {
            throw InvalidSpecException.unexpectedPListFormat(spec);
        }
        this.myName = spec.getNotNullString("Name");
        this.myFamilyDisplayName = spec.getString("FamilyDisplayName", spec.getNotNullString("FamilyName"));
        this.myFamilyIdentifier = spec.getNotNullString("FamilyIdentifier");
        this.myIdentifier = spec.getNotNullString("Identifier");
        String string2 = spec.getString("Version");
        if (string2 == null) {
            string2 = spec.getNotNullString("CFBundleShortVersionString");
        }
        this.myVersion = string2;
        this.myType = AppleSdkManager.getPlatformTypeBySettingValue(this.myName);
        this.myDeclaredBuildSettingValues = spec.getDictionary("DefaultProperties", new Dictionary());
        this.j();
        this.myBuildSystemProvider = new AppleBuildSystemProviderImpl(this.myManager){

            @Override
            @NotNull
            public List<AppleBuildSystem> getBuildSystems() {
                List<AppleBuildSystem> list = ApplePlatform.this.myBuildSystems;
                if (list == null) {
                    1.j(0);
                }
                return list;
            }

            @Override
            @Nullable
            public String getDomain() {
                return ApplePlatform.this.myType.getPlatformName();
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/xcode/frameworks/ApplePlatform$1", "getBuildSystems"));
            }
        };
        this.myFileTypeToCompilersCache = new HashMap<Pair<AppleFileType, String>, List<AppleCompiler>>();
    }

    private void j() {
        File[] fileArray;
        ArrayList<AppleArchitecture> arrayList = new ArrayList<AppleArchitecture>();
        ArrayList<AppleProductType> arrayList2 = new ArrayList<AppleProductType>();
        ArrayList<ApplePackageType> arrayList3 = new ArrayList<ApplePackageType>();
        ArrayList<AppleBuildSystem> arrayList4 = new ArrayList<AppleBuildSystem>();
        ArrayList<AppleCompiler> arrayList5 = new ArrayList<AppleCompiler>();
        String string = this.myType.getPlatformName();
        ArrayList<File> arrayList6 = new ArrayList<File>();
        for (File object : this.j()) {
            fileArray = new File(object, "Xcode").listFiles();
            if (fileArray == null) continue;
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) continue;
                arrayList6.add(file2);
                File[] fileArray2 = file2.listFiles();
                if (fileArray2 == null) continue;
                for (File file3 : fileArray2) {
                    if (!file3.isDirectory() || file3.getName().endsWith(IDEPLUGIN_EXTENSION)) continue;
                    arrayList6.add(new File(file3, "Contents/Resources"));
                }
            }
        }
        for (File file4 : arrayList6) {
            fileArray = file4.listFiles();
            if (fileArray == null) continue;
            XCLog.LOG.debug("Processing xcspecs in folder: " + file4);
            boolean bl = FileUtil.isAncestor((File)this.myRoot, (File)file4, (boolean)true);
            for (File file5 : fileArray) {
                this.j(new XCSpecFile(file5, bl ? string : null), arrayList, arrayList3, arrayList4, arrayList2, arrayList5);
            }
        }
        for (XCSpecFile xCSpecFile : XcodeExtensionsManager.getInstance().getXCSpecFileList(string)) {
            XCLog.LOG.debug("Processing xcspec file from XCSpecProvider: " + xCSpecFile);
            this.j(xCSpecFile, arrayList, arrayList3, arrayList4, arrayList2, arrayList5);
        }
        Collections.sort(arrayList);
        arrayList.trimToSize();
        arrayList2.trimToSize();
        arrayList3.trimToSize();
        arrayList4.trimToSize();
        this.myArchitectures = Collections.unmodifiableList(arrayList);
        this.myProductTypes = Collections.unmodifiableList(arrayList2);
        this.myPackageTypes = Collections.unmodifiableList(arrayList3);
        this.myBuildSystems = Collections.unmodifiableList(arrayList4);
        this.myCompilers = Collections.unmodifiableList(arrayList5);
    }

    private void j(XCSpecFile xCSpecFile, ArrayList<AppleArchitecture> arrayList, ArrayList<ApplePackageType> arrayList2, ArrayList<AppleBuildSystem> arrayList3, ArrayList<AppleProductType> arrayList4, ArrayList<AppleCompiler> arrayList5) {
        File file2 = xCSpecFile.getFile();
        String string = file2.getName();
        if (!StringUtil.endsWithIgnoreCase((String)string, (String)".xcspec")) {
            return;
        }
        arrayList.addAll(SpecListHelper.readSpecs(file2, "Architecture", plist -> {
            List<Dictionary> list = plist.getAttributeList("Properties", Dictionary.class, Collections.emptyList());
            for (Dictionary dictionary : list) {
                String string = dictionary.getString("Name");
                String string2 = dictionary.getString("DefaultValue");
                if (string == null || string2 == null) continue;
                this.myDeclaredBuildSettingValues.put(string, (Object)string2);
            }
            return null;
        }));
        arrayList4.addAll(SpecListHelper.readSpecs(file2, "ProductType", plist -> {
            List<Dictionary> list = plist.getAttributeList("Properties", Dictionary.class, Collections.emptyList());
            for (Dictionary dictionary : list) {
                String string = dictionary.getString("Name");
                String string2 = dictionary.getString("DefaultValue");
                if (string == null || string2 == null) continue;
                this.myDeclaredBuildSettingValues.put(string, (Object)string2);
            }
            return null;
        }));
        arrayList2.addAll(SpecListHelper.readSpecs(file2, "PackageType", plist -> {
            List<Dictionary> list = plist.getAttributeList("Properties", Dictionary.class, Collections.emptyList());
            for (Dictionary dictionary : list) {
                String string = dictionary.getString("Name");
                String string2 = dictionary.getString("DefaultValue");
                if (string == null || string2 == null) continue;
                this.myDeclaredBuildSettingValues.put(string, (Object)string2);
            }
            return null;
        }));
        arrayList5.addAll(SpecListHelper.readSpecs(file2, "Compiler", plist -> new AppleCompiler(file2, plist, this, xCSpecFile.getDomain())));
        arrayList3.addAll(SpecListHelper.readSpecs(file2, "BuildSystem", plist -> new AppleBuildSystem(file2, plist, this, null, xCSpecFile.getDomain())));
        this.j(file2);
    }

    private void j(@NotNull File file2) {
        if (file2 == null) {
            ApplePlatform.j(4);
        }
        SpecListHelper.readSpecs(file2, "BuildSettings", plist -> {
            List<Dictionary> list = plist.getAttributeList("Properties", Dictionary.class, Collections.emptyList());
            for (Dictionary dictionary : list) {
                String string = dictionary.getString("Name");
                String string2 = dictionary.getString("DefaultValue");
                if (string == null || string2 == null) continue;
                this.myDeclaredBuildSettingValues.put(string, (Object)string2);
            }
            return null;
        });
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ApplePlatform.j(5);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getDisplayName() {
        String string = this.myFamilyDisplayName;
        if (string == null) {
            ApplePlatform.j(6);
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            ApplePlatform.j(7);
        }
        return string;
    }

    @NotNull
    public String getIdentifier() {
        String string = this.myIdentifier;
        if (string == null) {
            ApplePlatform.j(8);
        }
        return string;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            ApplePlatform.j(9);
        }
        return type;
    }

    public boolean isMacOS() {
        return this.myType == Type.MACOS;
    }

    public boolean isIOS() {
        return this.isIOSDevice() || this.isIOSSimulator();
    }

    public boolean isWatch() {
        return this.isWatchDevice() || this.isWatchSimulator();
    }

    public boolean isVision() {
        return this.isVisionDevice() || this.isVisionSimulator();
    }

    public boolean isTv() {
        return this.isTvDevice() || this.isTvSimulator();
    }

    public boolean isDevice() {
        return !this.isMacOS() && !this.isSimulator();
    }

    public boolean isSimulator() {
        return this.myType.isSimulator();
    }

    public boolean isIOSDevice() {
        return this.myType == Type.IOS;
    }

    public boolean isIOSSimulator() {
        return this.myType == Type.IOS_SIMULATOR;
    }

    public boolean isWatchDevice() {
        return this.myType == Type.WATCH;
    }

    public boolean isWatchSimulator() {
        return this.myType == Type.WATCH_SIMULATOR;
    }

    public boolean isVisionDevice() {
        return this.myType == Type.VISION;
    }

    public boolean isVisionSimulator() {
        return this.myType == Type.VISION_SIMULATOR;
    }

    public boolean isTvDevice() {
        return this.myType == Type.TVOS;
    }

    public boolean isTvSimulator() {
        return this.myType == Type.TVOS_SIMULATOR;
    }

    public boolean isCompatiblePlatform(@Nullable ApplePlatform platform) {
        if (platform == null) {
            return false;
        }
        if (this.isMacOS() == platform.isMacOS()) {
            return true;
        }
        return !this.isMacOS() && !platform.isMacOS();
    }

    @NotNull
    public ApplePlatform getBasePlatform() {
        ApplePlatform applePlatform;
        if (BASE_PLATFORMS.containsKey((Object)this.myType) && (applePlatform = this.myManager.findPlatformByType(BASE_PLATFORMS.get((Object)this.myType))) != null) {
            ApplePlatform applePlatform2 = applePlatform;
            if (applePlatform2 == null) {
                ApplePlatform.j(10);
            }
            return applePlatform2;
        }
        ApplePlatform applePlatform3 = this;
        if (applePlatform3 == null) {
            ApplePlatform.j(11);
        }
        return applePlatform3;
    }

    @NotNull
    public List<AppleSdk> getSdks() {
        List<AppleSdk> list = this.myManager.findSdksForPlatform(this.myType);
        if (list == null) {
            ApplePlatform.j(12);
        }
        return list;
    }

    @Nullable
    public AppleSdk findSuitableSdk(@NotNull AppleSdk sdk) {
        if (sdk == null) {
            ApplePlatform.j(13);
        }
        if (sdk.getPlatform() == this) {
            return sdk;
        }
        for (AppleSdk appleSdk : this.getSdks()) {
            if (!appleSdk.getVersionString().equals(sdk.getVersionString())) continue;
            return appleSdk;
        }
        return null;
    }

    @NotNull
    public List<AppleArchitecture> getArchitectures() {
        List<AppleArchitecture> list = this.myArchitectures;
        if (list == null) {
            ApplePlatform.j(14);
        }
        return list;
    }

    @Nullable
    public AppleArchitecture getStandardNativeArchitecture() {
        for (String string : AppleArchitecture.PLATFORM_STANDARD_ARCHS_ID) {
            AppleArchitecture appleArchitecture2 = this.findArchitectureById(string);
            if (appleArchitecture2 == null) continue;
            return appleArchitecture2;
        }
        XCLog.LOG.error("Standard architecture not found for " + this.getDisplayName() + " among:\n" + StringUtil.join(this.myArchitectures, appleArchitecture -> appleArchitecture.toString(), (String)"\n"));
        return null;
    }

    @Nullable
    public AppleArchitecture findArchitectureById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        for (AppleArchitecture appleArchitecture : this.myArchitectures) {
            if (!appleArchitecture.getId().equals(id)) continue;
            return appleArchitecture;
        }
        return null;
    }

    @Nullable
    public AppleArchitecture findArchitectureBySetting(@Nullable String archSetting) {
        if (archSetting == null) {
            return null;
        }
        for (AppleArchitecture appleArchitecture : this.myArchitectures) {
            if (!Objects.equals(appleArchitecture.getArchitectureSetting(), archSetting)) continue;
            return appleArchitecture;
        }
        return null;
    }

    @NotNull
    public List<AppleProductType> getProductTypes() {
        List<AppleProductType> list = this.myProductTypes;
        if (list == null) {
            ApplePlatform.j(15);
        }
        return list;
    }

    @Nullable
    public AppleProductType findProductType(@Nullable String id) {
        if (id == null) {
            return null;
        }
        for (AppleProductType appleProductType : this.myProductTypes) {
            if (!appleProductType.getId().equals(id)) continue;
            return appleProductType;
        }
        return null;
    }

    @NotNull
    public List<ApplePackageType> getPackageTypes() {
        List<ApplePackageType> list = this.myPackageTypes;
        if (list == null) {
            ApplePlatform.j(16);
        }
        return list;
    }

    @Nullable
    public ApplePackageType findPackageType(@Nullable String id) {
        if (id == null) {
            return null;
        }
        for (ApplePackageType applePackageType : this.myPackageTypes) {
            if (!applePackageType.getId().equals(id)) continue;
            return applePackageType;
        }
        return null;
    }

    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable AppleBuildSystem.Type type) {
        return this.myBuildSystemProvider.findBuildSystem(type, this.myType.getPlatformName());
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable AppleBuildSystem.Type type, @Nullable String domain) {
        return this.myBuildSystemProvider.findBuildSystem(type, domain);
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystem(@Nullable String id, @Nullable String domain) {
        return this.myBuildSystemProvider.findBuildSystem(id, domain);
    }

    @Override
    @Nullable
    public AppleBuildSystem findBuildSystemByRef(@Nullable String ref) {
        return this.myBuildSystemProvider.findBuildSystemByRef(ref);
    }

    @Nullable
    public AppleCompiler findCompilerByRef(@Nullable String ref) {
        if (ref == null) {
            return null;
        }
        DomainAndID domainAndID = new DomainAndID(ref);
        String string = domainAndID.getDomain();
        if (string != null) {
            return this.findCompiler(domainAndID.getId(), string);
        }
        return this.findCompiler(domainAndID.getId(), this.getDomain());
    }

    @NotNull
    public Collection<AppleCompiler> getCompilers() {
        List<AppleCompiler> list = Collections.unmodifiableList(this.myCompilers);
        if (list == null) {
            ApplePlatform.j(17);
        }
        return list;
    }

    @Nullable
    public AppleCompiler findCompiler(@Nullable String id, @Nullable String domain) {
        AppleCompiler appleCompiler2 = (AppleCompiler)ContainerUtil.find(this.myCompilers, appleCompiler -> appleCompiler.getId().equals(id) && ApplePlatform.j(appleCompiler, domain, true));
        if (appleCompiler2 == null) {
            appleCompiler2 = (AppleCompiler)ContainerUtil.find(this.myCompilers, appleCompiler -> appleCompiler.getId().equals(id) && ApplePlatform.j(appleCompiler, null, false));
        }
        return appleCompiler2;
    }

    @NotNull
    public Collection<AppleCompiler> findCompilersForFileType(@Nullable AppleFileType type, @Nullable String domain) {
        if (type == null) {
            List<AppleCompiler> list = Collections.emptyList();
            if (list == null) {
                ApplePlatform.j(18);
            }
            return list;
        }
        Pair pair2 = Pair.create((Object)type, (Object)domain);
        Collection collection = this.myFileTypeToCompilersCache.get(pair2);
        if (collection != null) {
            Collection collection2 = collection;
            if (collection2 == null) {
                ApplePlatform.j(19);
            }
            return collection2;
        }
        ArrayList<AppleCompiler> arrayList = new ArrayList<AppleCompiler>();
        for (AppleCompiler appleCompiler : this.myCompilers) {
            if (appleCompiler.isAbstract() || !appleCompiler.getInputFileTypes().contains(new AppleCompiler.InputFileType(type.getId())) || !ApplePlatform.j(appleCompiler, domain, false)) continue;
            arrayList.add(appleCompiler);
        }
        List list = ContainerUtil.trimToSize(arrayList);
        this.myFileTypeToCompilersCache.put((Pair<AppleFileType, String>)pair2, list);
        Object object = list;
        if (object == null) {
            ApplePlatform.j(20);
        }
        return object;
    }

    private static boolean j(@NotNull AppleCompiler appleCompiler, @Nullable String string, boolean bl) {
        if (appleCompiler == null) {
            ApplePlatform.j(21);
        }
        if (!bl && appleCompiler.getDomain() == null) {
            return true;
        }
        return DomainAwareKt.isSuitableDomain(appleCompiler, string);
    }

    @Override
    @NotNull
    public List<AppleBuildSystem> getBuildSystems() {
        List<AppleBuildSystem> list = this.myBuildSystemProvider.getBuildSystems();
        if (list == null) {
            ApplePlatform.j(22);
        }
        return list;
    }

    @Override
    @Nullable
    public String getDomain() {
        return this.myBuildSystemProvider.getDomain();
    }

    @Override
    @NotNull
    public Dictionary getDeclaredBuildSettingValues() {
        Dictionary dictionary = this.myDeclaredBuildSettingValues;
        if (dictionary == null) {
            ApplePlatform.j(23);
        }
        return dictionary;
    }

    @NotNull
    public File getRoot() {
        File file2 = this.myRoot;
        if (file2 == null) {
            ApplePlatform.j(24);
        }
        return file2;
    }

    @NotNull
    public File getRootSubFile(@Nullable String relativePath) {
        return relativePath == null ? this.myRoot : new File(this.myRoot, relativePath);
    }

    @NotNull
    public String getRootSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getRootSubFile(relativePath).getPath();
        if (string == null) {
            ApplePlatform.j(25);
        }
        return string;
    }

    @NotNull
    public List<File> getDeveloperRoots() {
        File file2 = new File(this.myRoot, "Developer");
        File file3 = XcodeBase.getInstance().getApplicationContentsSubFile("PlugIns/Xcode3Core.ideplugin/Contents/SharedSupport/Developer");
        List<File> list = this.isMacOS() ? Arrays.asList(file2, this.myRoot.getParentFile().getParentFile(), file3) : Arrays.asList(file2, file3);
        if (list == null) {
            ApplePlatform.j(26);
        }
        return list;
    }

    @NotNull
    public List<File> getDeveloperSubFiles(@NonNls @Nullable String relativePath) {
        List<File> list = this.getDeveloperRoots();
        if (relativePath == null) {
            List<File> list2 = list;
            if (list2 == null) {
                ApplePlatform.j(27);
            }
            return list2;
        }
        ArrayList<File> arrayList = new ArrayList<File>(list.size());
        for (File file2 : list) {
            arrayList.add(new File(file2, relativePath));
        }
        ArrayList<File> arrayList2 = arrayList;
        if (arrayList2 == null) {
            ApplePlatform.j(28);
        }
        return arrayList2;
    }

    @Deprecated
    @NotNull
    private List<File> j() {
        if (XcodeBase.getInstance().getVersion().isOrGreaterThan(Integer.valueOf(13), Integer.valueOf(3))) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                ApplePlatform.j(29);
            }
            return list;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : this.getDeveloperRoots()) {
            arrayList.add(new File(file2, "Library"));
        }
        List<File> list = Collections.unmodifiableList(arrayList);
        if (list == null) {
            ApplePlatform.j(30);
        }
        return list;
    }

    @NotNull
    public File getSdksRoot() {
        return new File(this.myRoot, "Developer/SDKs");
    }

    @Override
    public int compareTo(@NotNull ApplePlatform o2) {
        if (o2 == null) {
            ApplePlatform.j(31);
        }
        if (this.getFamilyIdentifier().equals("driverkit") || this.getFamilyIdentifier().equals("xros")) {
            return 1;
        }
        if (o2.getFamilyIdentifier().equals("driverkit") || o2.getFamilyIdentifier().equals("xros")) {
            return -1;
        }
        return this.myType.compareTo(o2.myType);
    }

    public String toString() {
        return this.myFamilyDisplayName + " " + this.myVersion + " (" + this.myName + ")";
    }

    private /* synthetic */ ApplePackageType j(Plist plist) throws InvalidSpecException {
        return new ApplePackageType(plist, this);
    }

    private /* synthetic */ AppleProductType j(Plist plist) throws InvalidSpecException {
        String string = plist.getString("Domain");
        if (string != null && !string.equals(this.myType.getPlatformName())) {
            return null;
        }
        return new AppleProductType(plist, this);
    }

    private /* synthetic */ AppleArchitecture j(Plist plist) throws InvalidSpecException {
        return new AppleArchitecture(plist, this);
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 2, 3, 4, 13, 21, 31 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/ApplePlatform";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyIdentifier";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 21: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/ApplePlatform";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePlatform";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchitectures";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductTypes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageTypes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilers";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findCompilersForFileType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSystems";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBuildSettingValues";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootSubFilePath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeveloperRoots";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeveloperSubFiles";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeveloperLibraryRoots";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultBuildProperties";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableSdk";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableDomain";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 13, 21, 31 -> new IllegalArgumentException(string);
        };
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type MACOS = new Type("macosx", "macOS", new Version(3, 0, 0), false);
        public static final /* enum */ Type IOS = new Type("iphoneos", "iOS", new Version(3, 0, 0), false);
        public static final /* enum */ Type IOS_SIMULATOR = new Type("iphonesimulator", "iOS", new Version(3, 0, 0), true);
        public static final /* enum */ Type TVOS = new Type("appletvos", "tvOS", new Version(7, 1, 0), false);
        public static final /* enum */ Type TVOS_SIMULATOR = new Type("appletvsimulator", "tvOS", new Version(7, 1, 0), true);
        public static final /* enum */ Type WATCH = new Type("watchos", "watchOS", new Version(7, 0, 0), false);
        public static final /* enum */ Type WATCH_SIMULATOR = new Type("watchsimulator", "watchOS", new Version(7, 0, 0), true);
        public static final /* enum */ Type VISION = new Type("xros", "visionOS", new Version(15, 2, 0), false);
        public static final /* enum */ Type VISION_SIMULATOR = new Type("xrsimulator", "visionOS", new Version(15, 2, 0), true);
        @NotNull
        @NonNls
        private final String myPlatformName;
        @NotNull
        @NonNls
        private final String myOSName;
        @NotNull
        private final Version myVersionSince;
        private final boolean myIsSimulator;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(@NotNull String platformName, String OSName, Version versionSince, boolean isSumulator) {
            if (platformName == null) {
                Type.j(0);
            }
            if (OSName == null) {
                Type.j(1);
            }
            if (versionSince == null) {
                Type.j(2);
            }
            this.myPlatformName = platformName;
            this.myOSName = OSName;
            this.myVersionSince = versionSince;
            this.myIsSimulator = isSumulator;
        }

        @NotNull
        @NonNls
        public String getPlatformName() {
            String string = this.myPlatformName;
            if (string == null) {
                Type.j(3);
            }
            return string;
        }

        @NotNull
        @NonNls
        public String getOSName() {
            String string = this.myOSName;
            if (string == null) {
                Type.j(4);
            }
            return string;
        }

        public Version getVersionSince() {
            return this.myVersionSince;
        }

        public boolean isSimulator() {
            return this.myIsSimulator;
        }

        private static /* synthetic */ Type[] j() {
            return new Type[]{MACOS, IOS, IOS_SIMULATOR, TVOS, TVOS_SIMULATOR, WATCH, WATCH_SIMULATOR, VISION, VISION_SIMULATOR};
        }

        static {
            $VALUES = Type.j();
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "platformName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "OSName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionSince";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/ApplePlatform$Type";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/ApplePlatform$Type";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlatformName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOSName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

