/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.xcode.frameworks.AppleFileType;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.frameworks.SpecListHelper;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import com.jetbrains.cidr.xcode.xcspec.XCSpecFile;
import com.jetbrains.cidr.xcode.xcspec.XcodeExtensionsManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class AppleFileTypeManager {
    @NotNull
    private final Map<String, AppleFileType> myIdToFileTypeMap;
    @NotNull
    private final Map<String, AppleFileType> myExtensionToFileTypeMap;
    @NotNull
    private final Map<String, AppleFileType> myLowerCaseExtensionToFileTypeMap;
    @NotNull
    private final Map<Pattern, AppleFileType> myPatternToFileTypeMap;

    @NotNull
    public static AppleFileTypeManager getInstance() {
        AppleFileTypeManager appleFileTypeManager = (AppleFileTypeManager)ApplicationManager.getApplication().getService(AppleFileTypeManager.class);
        if (appleFileTypeManager == null) {
            AppleFileTypeManager.j(0);
        }
        return appleFileTypeManager;
    }

    public AppleFileTypeManager() {
        ArrayList<AppleFileType> arrayList = new ArrayList<AppleFileType>();
        this.j(arrayList);
        for (File hashMap2 : AppleSdkManager.getSpecsFolders()) {
            AppleFileTypeManager.processSpecs(hashMap2, arrayList, plist -> new AppleFileType(plist, this));
        }
        for (XCSpecFile xCSpecFile : XcodeExtensionsManager.getInstance().getXCSpecFileList("default")) {
            AppleFileTypeManager.j(xCSpecFile.getFile(), arrayList, plist -> new AppleFileType(plist, this));
        }
        HashMap hashMap3 = new HashMap();
        HashMap<String, AppleFileType> hashMap = new HashMap<String, AppleFileType>();
        HashMap<String, AppleFileType> hashMap2 = new HashMap<String, AppleFileType>();
        HashMap<Pattern, AppleFileType> hashMap4 = new HashMap<Pattern, AppleFileType>();
        for (AppleFileType appleFileType : arrayList) {
            hashMap3.put(appleFileType.getId(), appleFileType);
            for (String string : appleFileType.getExtensions()) {
                hashMap.put(string, appleFileType);
                hashMap2.put(StringUtil.toLowerCase((String)string), appleFileType);
            }
            for (Pattern pattern : appleFileType.getFilenamePatterns()) {
                hashMap4.put(pattern, appleFileType);
            }
        }
        this.myIdToFileTypeMap = Collections.unmodifiableMap(hashMap3);
        this.myExtensionToFileTypeMap = Collections.unmodifiableMap(hashMap);
        this.myLowerCaseExtensionToFileTypeMap = Collections.unmodifiableMap(hashMap2);
        this.myPatternToFileTypeMap = Collections.unmodifiableMap(hashMap4);
    }

    private void j(List<AppleFileType> list) {
        try (InputStream inputStream = this.getClass().getResourceAsStream("FileTypes.xml");){
            Plist plist2;
            if (inputStream != null && (plist2 = PlistDriver.readAnyFormatSafe(inputStream)) != null) {
                list.addAll(SpecListHelper.readSpecs(plist2, null, plist -> new AppleFileType(plist, this)));
            }
        }
        catch (IOException iOException) {
            Logger.getInstance(AppleFileTypeManager.class).error((Throwable)iOException);
        }
    }

    static <T> void processSpecs(File dir, List<T> result2, SpecListHelper.Factory<T> factory) {
        File[] fileArray = dir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            AppleFileTypeManager.j(file2, result2, factory);
        }
    }

    private static <T> void j(File file2, List<T> list, SpecListHelper.Factory<T> factory) {
        boolean bl = StringUtil.endsWithIgnoreCase((String)file2.getName(), (String)".pbfilespec");
        if (bl || StringUtil.endsWithIgnoreCase((String)file2.getName(), (String)".xcspec")) {
            list.addAll(SpecListHelper.readSpecs(file2, bl ? null : "FileType", factory));
        }
    }

    @Nullable
    public AppleFileType findFileTypeById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.myIdToFileTypeMap.get(id);
    }

    @Nullable
    public AppleFileType findFileTypeByExtension(@Nullable String extension) {
        if (extension == null) {
            return null;
        }
        AppleFileType appleFileType = this.myExtensionToFileTypeMap.get(extension);
        return appleFileType != null ? appleFileType : this.myLowerCaseExtensionToFileTypeMap.get(StringUtil.toLowerCase((String)extension));
    }

    @Nullable
    public AppleFileType findFileTypeByFilename(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        for (Map.Entry<Pattern, AppleFileType> entry2 : this.myPatternToFileTypeMap.entrySet()) {
            if (!entry2.getKey().matcher(fileName).matches()) continue;
            return entry2.getValue();
        }
        AppleFileType appleFileType = this.findFileTypeByExtension(FileUtilRt.getExtension((String)fileName));
        if (appleFileType != null) {
            return appleFileType;
        }
        return null;
    }

    @NotNull
    public String getSuitableFileTypeIdByFile(@Nullable File file2) {
        String string = this.getSuitableFileTypeIdByFilename(file2 != null ? file2.getName() : null, file2 != null && file2.isDirectory());
        if (string == null) {
            AppleFileTypeManager.j(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getSuitableFileTypeIdByFilename(@Nullable String fileName, boolean isDirectory) {
        if (fileName != null) {
            for (Map.Entry<Pattern, AppleFileType> object2 : this.myPatternToFileTypeMap.entrySet()) {
                if (!object2.getKey().matcher(fileName).matches()) continue;
                String string = object2.getValue().getId();
                if (string == null) {
                    AppleFileTypeManager.j(2);
                }
                return string;
            }
            String string = FileUtilRt.getExtension((String)fileName);
            if (string.isEmpty() && isDirectory) {
                return "folder";
            }
            AppleFileType appleFileType = this.findFileTypeByExtension(string);
            if (appleFileType != null) {
                String string2 = appleFileType.getId();
                if (string2 == null) {
                    AppleFileTypeManager.j(3);
                }
                return string2;
            }
            if (isDirectory) {
                return "folder";
            }
            if (!StringUtil.isEmptyOrSpaces((String)string)) {
                String string3 = "file." + (String)string;
                if (string3 == null) {
                    AppleFileTypeManager.j(4);
                }
                return string3;
            }
        }
        return "text";
    }

    public boolean isTextFile(@Nullable String fileName) {
        AppleFileType appleFileType = this.findFileTypeByFilename(fileName);
        return appleFileType != null && appleFileType.isTextFile();
    }

    public boolean isSourceCodeFile(@Nullable String fileName) {
        AppleFileType appleFileType = this.findFileTypeByFilename(fileName);
        return appleFileType != null && appleFileType.isSourceCode();
    }

    public boolean isHeaderFile(@Nullable String fileName) {
        AppleFileType appleFileType = this.findFileTypeByFilename(fileName);
        return appleFileType != null && appleFileType.isHeader();
    }

    public boolean isFramework(@Nullable VirtualFile file2) {
        AppleFileType appleFileType;
        return file2 != null && file2.isDirectory() && (appleFileType = this.findFileTypeByFilename(file2.getName())) != null && appleFileType.isFrameworkWrapper();
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/xcode/frameworks/AppleFileTypeManager";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypeIdByFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypeIdByFilename";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

