/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode.frameworks;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Version;
import com.intellij.util.Range;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppleArchitecture
implements Comparable<AppleArchitecture> {
    @NonNls
    public static final String[] PLATFORM_STANDARD_ARCHS_ID = new String[]{"Standard", "PlatformStandard"};
    @NonNls
    public static final String NATIVE_ARCH = "NATIVE_ARCH";
    @NonNls
    public static final String NATIVE_ARCH_ACTUAL = "NATIVE_ARCH_ACTUAL";
    @NonNls
    public static final String ARCHS_STANDARD = "ARCHS_STANDARD";
    @NonNls
    public static final String ARCHS_STANDARD_INCLUDING_64_BIT = "ARCHS_STANDARD_INCLUDING_64_BIT";
    @NonNls
    public static final String ARCHS_STANDARD_32_BIT = "ARCHS_STANDARD_32_BIT";
    @NotNull
    private final ApplePlatform myPlatform;
    @NotNull
    @NlsSafe
    private final String myId;
    @Nullable
    @NlsSafe
    private final String myName;
    @Nullable
    private final String myDescription;
    @Nullable
    private final String myArchitectureSetting;
    @Nullable
    private final List<String> myRealArchitectures;
    @Nullable
    private final Range<Version> myDeploymentTargetRange;
    private final boolean myListInEnum;
    private final int mySortNumber;

    AppleArchitecture(@NotNull Plist props, @NotNull ApplePlatform platform) throws InvalidSpecException {
        int n2;
        if (props == null) {
            AppleArchitecture.j(0);
        }
        if (platform == null) {
            AppleArchitecture.j(1);
        }
        this.myPlatform = platform;
        this.myId = props.getNotNullString("Identifier");
        this.myName = props.getString("Name");
        this.myDescription = props.getString("Description");
        this.myArchitectureSetting = props.getString("ArchitectureSetting");
        this.myListInEnum = props.getBoolean("ListInEnum", false);
        try {
            n2 = Integer.parseInt(props.getString("SortNumber"));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = Integer.MAX_VALUE;
        }
        this.mySortNumber = n2;
        List<String> list = props.getAttributeList("RealArchitectures", String.class, null);
        if (list == null && NATIVE_ARCH_ACTUAL.equals(this.myArchitectureSetting)) {
            list = Collections.singletonList(AppleSdkManager.getActualMacOSNativeArchitectureId());
        }
        this.myRealArchitectures = list;
        List<String> list2 = props.getAttributeList("DeploymentTargetRange", String.class, null);
        if (list2 == null) {
            this.myDeploymentTargetRange = null;
        } else {
            Version version = Version.parseVersion((String)list2.get(0));
            Version version2 = Version.parseVersion((String)list2.get(1));
            this.myDeploymentTargetRange = version != null && version2 != null ? new Range((Comparable)version, (Comparable)version2) : null;
        }
    }

    @NotNull
    public ApplePlatform getPlatform() {
        ApplePlatform applePlatform = this.myPlatform;
        if (applePlatform == null) {
            AppleArchitecture.j(2);
        }
        return applePlatform;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            AppleArchitecture.j(3);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getDisplayableName() {
        String string = this.myName == null ? this.myId : this.myName;
        if (string == null) {
            AppleArchitecture.j(4);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public String getArchitectureSetting() {
        return this.myArchitectureSetting;
    }

    public boolean isReal() {
        return this.myRealArchitectures == null;
    }

    @NotNull
    public List<String> getRealArchitectures() {
        if (this.myRealArchitectures == null) {
            AppleArchitecture appleArchitecture;
            if (NATIVE_ARCH.equals(this.myArchitectureSetting) && (appleArchitecture = this.myPlatform.getStandardNativeArchitecture()) != null) {
                List<String> list = appleArchitecture.getRealArchitectures();
                if (list == null) {
                    AppleArchitecture.j(5);
                }
                return list;
            }
            List<String> list = Collections.singletonList(this.myId);
            if (list == null) {
                AppleArchitecture.j(6);
            }
            return list;
        }
        List<String> list = Collections.unmodifiableList(this.myRealArchitectures);
        if (list == null) {
            AppleArchitecture.j(7);
        }
        return list;
    }

    public boolean isListInEnum() {
        return this.myListInEnum;
    }

    public boolean matchesDeploymentTarget(@NotNull String target) {
        if (target == null) {
            AppleArchitecture.j(8);
        }
        if (this.myDeploymentTargetRange == null) {
            return true;
        }
        Version version = Version.parseVersion((String)target);
        if (version == null) {
            return true;
        }
        return this.myDeploymentTargetRange.isWithin((Comparable)version, false);
    }

    @Override
    public int compareTo(@NotNull AppleArchitecture o2) {
        if (o2 == null) {
            AppleArchitecture.j(9);
        }
        return this.mySortNumber - o2.mySortNumber;
    }

    public String toString() {
        return this.myId + ":" + this.myName + ":" + this.myDescription + ":" + this.myArchitectureSetting + ":" + this.myRealArchitectures;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/frameworks/AppleArchitecture";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/frameworks/AppleArchitecture";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatform";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayableName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealArchitectures";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchesDeploymentTarget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

