/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.XcodeCoreBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XcodeVersionUtil {
    public static final String MinOS = "13";
    public static final Version MinXcode = new Version(15, 3, 0);
    public static final String UnsupportedOS = "15.0";
    public static final Version UnsupportedXcode = new Version(15, 5, 0);
    public static final String RecommendedOS = "14";
    public static final String RecommendedXcode = "15.4";

    private XcodeVersionUtil() {
    }

    @Nullable
    public static HtmlBuilder isSupportedVersion(@NotNull String currentOS, @NotNull ToolVersion currentXcode) {
        if (currentOS == null) {
            XcodeVersionUtil.j(0);
        }
        if (currentXcode == null) {
            XcodeVersionUtil.j(1);
        }
        String string = SystemInfo.getMacOSMajorVersion((String)currentOS);
        if (StringUtil.compareVersionNumbers((String)currentOS, (String)UnsupportedOS) >= 0 || StringUtil.compareVersionNumbers((String)currentOS, (String)MinOS) < 0) {
            return new HtmlBuilder().append(XcodeCoreBundle.message("settings.macos.notSupported.0", string, currentXcode.toString())).br().append(XcodeCoreBundle.message("settings.macos.notSupported.1", new Object[0])).br().append(XcodeCoreBundle.message("settings.macos.notSupported.2", RecommendedOS, RecommendedXcode));
        }
        if (currentXcode.versionNumber.compareTo(UnsupportedXcode) >= 0) {
            return new HtmlBuilder().append(XcodeCoreBundle.message("settings.xcode.using", currentXcode.toString())).br().append(XcodeCoreBundle.message("settings.xcode.version.too.new", new Object[0])).br().append(XcodeCoreBundle.message("settings.xcode.version.too.new.tip", RecommendedXcode));
        }
        if (currentXcode.versionNumber.compareTo(MinXcode) < 0) {
            return new HtmlBuilder().append(XcodeCoreBundle.message("settings.xcode.using", currentXcode.toString())).br().append(XcodeCoreBundle.message("settings.xcode.version.too.old", MinXcode.toString())).br().append(XcodeCoreBundle.message("settings.xcode.version.too.old.tip", RecommendedXcode));
        }
        return null;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "currentOS";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "currentXcode";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/xcode/XcodeVersionUtil";
        objectArray[2] = "isSupportedVersion";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

