/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.xcode.InstallationSelector;
import com.jetbrains.cidr.xcode.Result;
import com.jetbrains.cidr.xcode.XcodeDiscoverer;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.cidr.xcode.XcodeSettingsBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="XcodeSettings", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
public class XcodeSettings
extends XcodeSettingsBase
implements PersistentStateComponent<State> {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Xcode");
    public static final Comparator<XcodeInstallation> XCODE_COMPARATOR = (xcodeInstallation, xcodeInstallation2) -> {
        int n2 = StringUtil.compareVersionNumbers((String)xcodeInstallation2.getVersionString(), (String)xcodeInstallation.getVersionString());
        return n2 != 0 ? n2 : StringUtil.compare((String)xcodeInstallation2.getBuildVersionString(), (String)xcodeInstallation.getBuildVersionString(), (boolean)true);
    };
    @Nullable
    private volatile Notification myNotification;
    private volatile boolean myNotificationPresented;

    public XcodeSettings() {
        super(new State());
    }

    @NotNull
    public static XcodeSettings getInstance() {
        XcodeSettings xcodeSettings = (XcodeSettings)XcodeSettingsBase.getInstance();
        if (xcodeSettings == null) {
            XcodeSettings.j(0);
        }
        return xcodeSettings;
    }

    @Override
    @NotNull
    public XcodeInstallation chooseXcodeInstallation() {
        if (!SystemInfo.isMac) {
            return new XcodeInstallation(new File("nul"));
        }
        String string = System.getProperty("xcode.base");
        if (string != null) {
            this.getState().selectedXcode = string;
            if (ApplicationManager.getApplication().isUnitTestMode() || Boolean.parseBoolean(System.getProperty("xcode.base.force"))) {
                return new XcodeInstallation(new File(string));
            }
        }
        List<XcodeInstallation> list = XcodeDiscoverer.getInstance().discoverXcodeInstallations();
        if (!PluginUtils.hasAppCode()) {
            XcodeInstallation xcodeInstallation = list.get(0);
            if (xcodeInstallation == null) {
                XcodeSettings.j(1);
            }
            return xcodeInstallation;
        }
        Result result2 = this.updateState(list);
        Notification notification = result2.getNotification();
        if (notification != null) {
            this.myNotification = notification;
            if (!PlatformUtils.isFleetBackend()) {
                this.presentPendingXcodeNotification();
            }
        }
        XcodeInstallation xcodeInstallation = result2.getSelectedInstallation();
        if (xcodeInstallation == null) {
            XcodeSettings.j(2);
        }
        return xcodeInstallation;
    }

    @NotNull
    public Result updateState(@NotNull List<XcodeInstallation> discoveredInstallations) {
        if (discoveredInstallations == null) {
            XcodeSettings.j(3);
        }
        ArrayList<XcodeInstallation> arrayList = new ArrayList<XcodeInstallation>(discoveredInstallations);
        arrayList.sort(XCODE_COMPARATOR);
        State state = this.getState();
        XcodeInstallation xcodeInstallation2 = state.selectedXcode != null ? this.createXcode(new File(state.selectedXcode)) : null;
        List<String> list = state.detectedXcodes;
        InstallationSelector installationSelector = new InstallationSelector(arrayList, xcodeInstallation2, list);
        Result result2 = installationSelector.selectInstallationAndShowCorrespondingNotification();
        XcodeInstallation xcodeInstallation3 = result2.getSelectedInstallation();
        List list2 = ContainerUtil.map(arrayList, xcodeInstallation -> xcodeInstallation.getBasePath());
        this.loadState(new State(xcodeInstallation3.getBasePath(), list2));
        Result result3 = result2;
        if (result3 == null) {
            XcodeSettings.j(4);
        }
        return result3;
    }

    @Override
    @NotNull
    public State getState() {
        State state = (State)super.getState();
        if (state == null) {
            XcodeSettings.j(5);
        }
        return state;
    }

    @Override
    public void setSelectedXcodeBasePath(@NotNull String path) {
        if (path == null) {
            XcodeSettings.j(6);
        }
        Notification notification = this.myNotification;
        if (!PlatformUtils.isFleetBackend()) {
            if (notification != null) {
                notification.expire();
            }
            this.myNotification = null;
        }
        super.setSelectedXcodeBasePath(path);
    }

    @ApiStatus.Internal
    public synchronized void presentPendingXcodeNotification() {
        Notification notification = this.myNotification;
        if (notification != null && !this.myNotificationPresented) {
            this.myNotificationPresented = true;
            ApplicationManager.getApplication().invokeLater(() -> notification.notify(null));
        }
    }

    @NotNull
    public List<String> getDetectedXcodePaths() {
        List<String> list = this.getState().detectedXcodes;
        if (list == null) {
            XcodeSettings.j(7);
        }
        return list;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            XcodeSettings.j(8);
        }
        super.setState(state);
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 3, 6, 8 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/XcodeSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "discoveredInstallations";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseXcodeInstallation";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/XcodeSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectedXcodePaths";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedXcodeBasePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 3, 6, 8 -> new IllegalArgumentException(string);
        };
    }

    public static class State
    extends XcodeSettingsBase.State {
        public List<String> detectedXcodes;

        public State() {
            this(null, Collections.emptyList());
        }

        public State(String selectedXcode, List<String> detectedXcodes) {
            super(selectedXcode);
            this.detectedXcodes = new ArrayList<String>(detectedXcodes);
        }
    }
}

