/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.OCCorePathManager;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeVersionUtil;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class XcodeInstallation {
    @NotNull
    private final File myBaseFile;
    private final AtomicNotNullLazyValue<File> myAppFileCache;
    private final AtomicNotNullLazyValue<ToolVersion> myVersionCache;
    private final AtomicNotNullLazyValue<Plist> mySettingsCache;
    private final AtomicNotNullLazyValue<Plist> myPlistCache;
    private final AtomicNotNullLazyValue<Plist> myVersionPlistCache;

    public XcodeInstallation(@NotNull File baseFile) {
        if (baseFile == null) {
            XcodeInstallation.j(0);
        }
        this.myAppFileCache = AtomicNotNullLazyValue.createValue(() -> XcodeInstallation.N(this.getBaseFile()));
        this.myVersionCache = AtomicNotNullLazyValue.createValue(() -> {
            String string = this.getVersionString();
            List list = StringUtil.split((String)string, (String)".");
            int n2 = XcodeInstallation.j(list, 0);
            int n3 = XcodeInstallation.j(list, 1);
            int n4 = XcodeInstallation.j(list, 2);
            return n2 == 0 ? ToolVersion.createUnknown(string) : new ToolVersion(string, n2, n3, n4);
        });
        this.mySettingsCache = AtomicNotNullLazyValue.createValue(() -> {
            File file2 = OCCorePathManager.getUserPreferencesDirSubFile(this.getBundleID() + ".plist");
            return XcodeInstallation.j(file2);
        });
        this.myPlistCache = AtomicNotNullLazyValue.createValue(() -> {
            File file2 = this.getApplicationContentsSubFile("Info.plist");
            return XcodeInstallation.j(file2);
        });
        this.myVersionPlistCache = AtomicNotNullLazyValue.createValue(() -> {
            File file2 = this.getSubFile("Library/version.plist");
            if (!file2.exists()) {
                file2 = this.getApplicationContentsSubFile("version.plist");
            }
            return XcodeInstallation.j(file2);
        });
        if (!baseFile.getName().equals("Developer")) {
            XCLog.LOG.warn("Specify Developer dir, not Xcode app dir: " + baseFile.getPath());
        }
        this.myBaseFile = XcodeInstallation.j(baseFile);
    }

    @NotNull
    private static File j(@NotNull File file2) {
        File file3;
        if (file2 == null) {
            XcodeInstallation.j(1);
        }
        try {
            file3 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            XCLog.LOG.warn((Throwable)iOException);
            File file4 = file2;
            if (file4 == null) {
                XcodeInstallation.j(3);
            }
            return file4;
        }
        if (file3 == null) {
            XcodeInstallation.j(2);
        }
        return file3;
    }

    public boolean isValid() {
        return this.isInstalled() && this.isSupportedVersion() == null;
    }

    public boolean isInstalled() {
        return !this.getVersion().isUnknown() && "Xcode".equals(this.getBundleName());
    }

    @Nullable
    public HtmlBuilder isSupportedVersion() {
        return XcodeVersionUtil.isSupportedVersion(SystemInfo.OS_VERSION, this.getVersion());
    }

    @NotNull
    @NlsSafe
    public String getBasePath() {
        String string = this.getBaseFile().getPath();
        if (string == null) {
            XcodeInstallation.j(4);
        }
        return string;
    }

    @NotNull
    public File getBaseFile() {
        File file2 = this.myBaseFile;
        if (file2 == null) {
            XcodeInstallation.j(5);
        }
        return file2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        XcodeInstallation xcodeInstallation = (XcodeInstallation)o2;
        return FileUtil.filesEqual((File)this.myBaseFile, (File)xcodeInstallation.myBaseFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myBaseFile);
    }

    @NotNull
    public File getSubFile(@Nullable @NonNls String relativePath) {
        return relativePath == null ? this.getBaseFile() : new File(this.getBaseFile(), relativePath);
    }

    @NotNull
    public String getSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getSubFile(relativePath).getPath();
        if (string == null) {
            XcodeInstallation.j(6);
        }
        return string;
    }

    @NotNull
    public File getApplicationFile() {
        File file2 = (File)this.myAppFileCache.getValue();
        if (file2 == null) {
            XcodeInstallation.j(7);
        }
        return file2;
    }

    @NotNull
    public String getApplicationFilePath() {
        String string = this.getApplicationFile().getPath();
        if (string == null) {
            XcodeInstallation.j(8);
        }
        return string;
    }

    @NotNull
    public File getApplicationContentsSubFile(@Nullable @NonNls String relativePath) {
        File file2 = new File(this.getApplicationFile(), "Contents");
        File file3 = relativePath != null ? new File(file2, relativePath) : file2;
        if (file3 == null) {
            XcodeInstallation.j(9);
        }
        return file3;
    }

    @NotNull
    public String getApplicationContentsSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getApplicationContentsSubFile(relativePath).getPath();
        if (string == null) {
            XcodeInstallation.j(10);
        }
        return string;
    }

    @NotNull
    public File getApplicationsSubFile(@Nullable @NonNls String relativePath) {
        File file2 = this.getApplicationContentsSubFile("Applications");
        if (!file2.exists()) {
            file2 = this.getSubFile("Applications");
        }
        return relativePath == null ? file2 : new File(file2, relativePath);
    }

    @NotNull
    public String getApplicationsSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getApplicationsSubFile(relativePath).getPath();
        if (string == null) {
            XcodeInstallation.j(11);
        }
        return string;
    }

    @NotNull
    public List<File> getXcodeFrameworksFolders() {
        List<File> list = Arrays.asList(this.getApplicationContentsSubFile("Frameworks"), this.getApplicationContentsSubFile("OtherFrameworks"), this.getApplicationContentsSubFile("SharedFrameworks"), this.getSubFile("/Library/PrivateFrameworks"));
        if (list == null) {
            XcodeInstallation.j(12);
        }
        return list;
    }

    @NotNull
    public List<File> getXcodePluginsFolders() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(this.getApplicationContentsSubFile("SharedFrameworks/XCBuild.framework/Versions/A/PlugIns/XCBBuildService.bundle/Contents/PlugIns"));
        arrayList.add(this.getSubFile("Library/Xcode/Plug-Ins"));
        arrayList.add(this.getApplicationContentsSubFile("PlugIns"));
        File[] fileArray = this.getSubFile("Platforms").listFiles(FileFilters.withExtension((String)"platform"));
        if (fileArray != null) {
            for (File file2 : fileArray) {
                arrayList.add(new File(file2, "Developer/Library/Xcode/PrivatePlugIns"));
            }
        }
        ArrayList<File> arrayList2 = arrayList;
        if (arrayList2 == null) {
            XcodeInstallation.j(13);
        }
        return arrayList2;
    }

    @Nullable
    public String getBundleName() {
        return this.w().getString("CFBundleName");
    }

    @NotNull
    public String getVersionString() {
        String string = this.w().getString("CFBundleShortVersionString", "unknown");
        if (string == null) {
            XcodeInstallation.j(14);
        }
        return string;
    }

    @NotNull
    public String getBuildVersionString() {
        String string = ((Plist)this.myVersionPlistCache.getValue()).getString("ProductBuildVersion", "unknown");
        if (string == null) {
            XcodeInstallation.j(15);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getDisplayVersion() {
        String string = this.getVersionString() + " (" + this.getBuildVersionString() + ")";
        if (string == null) {
            XcodeInstallation.j(16);
        }
        return string;
    }

    @NotNull
    public ToolVersion getVersion() {
        ToolVersion toolVersion = (ToolVersion)this.myVersionCache.getValue();
        if (toolVersion == null) {
            XcodeInstallation.j(17);
        }
        return toolVersion;
    }

    private static int j(List<String> list, int n2) {
        if (n2 > list.size() - 1) {
            return 0;
        }
        try {
            return Integer.parseInt(list.get(n2));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @NotNull
    public String getBundleID() {
        String string = this.w().getString("CFBundleIdentifier", "com.apple.Xcode");
        if (string == null) {
            XcodeInstallation.j(18);
        }
        return string;
    }

    @NotNull
    public Plist getSettings() {
        Plist plist = (Plist)this.mySettingsCache.getValue();
        if (plist == null) {
            XcodeInstallation.j(19);
        }
        return plist;
    }

    @NotNull
    private Plist w() {
        Plist plist = (Plist)this.myPlistCache.getValue();
        if (plist == null) {
            XcodeInstallation.j(20);
        }
        return plist;
    }

    @NotNull
    public Dictionary getBuildSettings() {
        Dictionary dictionary = this.getSettings().getDictionary(this.getBuildSettingsKey(), Dictionary.EMPTY_DICTIONARY);
        if (dictionary == null) {
            XcodeInstallation.j(21);
        }
        return dictionary;
    }

    @NotNull
    @NonNls
    public String getBuildSettingsKey() {
        return this.getVersion().versionNumber.is(Integer.valueOf(3)) ? "PBXApplicationwideBuildSettings" : "IDEApplicationwideBuildSettings";
    }

    @NotNull
    private static Plist j(@NotNull File file2) {
        if (file2 == null) {
            XcodeInstallation.j(22);
        }
        Plist plist = null;
        if (file2.exists()) {
            plist = PlistDriver.readAnyFormatSafe(file2);
        }
        Plist plist2 = plist == null ? new Plist() : plist;
        if (plist2 == null) {
            XcodeInstallation.j(23);
        }
        return plist2;
    }

    @NotNull
    private static File N(@NotNull File file2) {
        String string;
        if (file2 == null) {
            XcodeInstallation.j(24);
        }
        if ((string = FileUtil.toCanonicalPath((String)file2.getPath())).endsWith(".app/Contents/Developer")) {
            File file3 = file2.getParentFile().getParentFile();
            if (file3 == null) {
                XcodeInstallation.j(25);
            }
            return file3;
        }
        return new File(file2, "/Applications/Xcode.app");
    }

    @NonNls
    public String toString() {
        return "Xcode@" + this.myBaseFile;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 25 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/XcodeInstallation";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xcodeBase";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/XcodeInstallation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalSafe";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFilePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationContentsSubFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationContentsSubFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationsSubFilePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodeFrameworksFolders";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodePluginsFolders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildVersionString";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayVersion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleID";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodeAppPlist";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSettings";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadPlist";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverApplicationFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canonicalSafe";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doReadPlist";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "discoverApplicationFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 25 -> new IllegalStateException(string);
        };
    }
}

