/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FileCollectionFactory;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class XcodeDiscoverer {
    public static XcodeDiscoverer getInstance() {
        return (XcodeDiscoverer)ApplicationManager.getApplication().getService(XcodeDiscoverer.class);
    }

    @NotNull
    public List<XcodeInstallation> discoverXcodeInstallations() {
        Map map = FileCollectionFactory.createCanonicalFileMap();
        SmartList smartList = new SmartList();
        XcodeInstallation xcodeInstallation = XcodeDiscoverer.j(CidrToolsUtil.getXcodeSelect(), (List<XcodeInstallation>)smartList, map);
        ArrayList<XcodeInstallation> arrayList = XcodeDiscoverer.j("/Applications").iterator();
        while (arrayList.hasNext()) {
            Iterator<File> iterator = arrayList.next();
            XcodeDiscoverer.j(this.getXcodeAppBaseFile((File)((Object)iterator)), (List<XcodeInstallation>)smartList, map);
        }
        if (xcodeInstallation != null && !FileUtil.pathsEqual(arrayList = xcodeInstallation.getApplicationFile().getParent(), (String)"/Applications")) {
            for (File object : XcodeDiscoverer.j(arrayList)) {
                XcodeDiscoverer.j(this.getXcodeAppBaseFile(object), (List<XcodeInstallation>)smartList, map);
            }
        }
        arrayList = new ArrayList<XcodeInstallation>(smartList.size());
        for (XcodeInstallation xcodeInstallation2 : smartList) {
            if (!xcodeInstallation2.isInstalled()) continue;
            XCLog.LOG.info("Xcode found in '" + xcodeInstallation2 + "'");
            arrayList.add(xcodeInstallation2);
        }
        if (arrayList.isEmpty()) {
            List<XcodeInstallation> list = Collections.singletonList(new XcodeInstallation(new File("/Applications/Xcode.app/Contents/Developer")));
            if (list == null) {
                XcodeDiscoverer.j(0);
            }
            return list;
        }
        List<XcodeInstallation> list = Collections.unmodifiableList(arrayList);
        if (list == null) {
            XcodeDiscoverer.j(1);
        }
        return list;
    }

    @NotNull
    public File getXcodeAppBaseFile(@NotNull File appPath) {
        if (appPath == null) {
            XcodeDiscoverer.j(2);
        }
        return new File(appPath, "/Contents/Developer");
    }

    @NotNull
    private static List<File> j(@NonNls String string2) {
        Pattern pattern = Pattern.compile("xcode.*\\.app", 2);
        File[] fileArray = new File(string2).listFiles((file2, string) -> pattern.matcher(string).matches());
        List<Object> list = fileArray == null ? Collections.emptyList() : Arrays.asList(fileArray);
        if (list == null) {
            XcodeDiscoverer.j(3);
        }
        return list;
    }

    @Contract(value="null,_,_-> null; !null,_,_-> !null")
    private static XcodeInstallation j(@Nullable File file2, List<XcodeInstallation> list, Map<File, XcodeInstallation> map) {
        if (file2 == null) {
            return null;
        }
        XcodeInstallation xcodeInstallation = map.get(file2);
        if (xcodeInstallation == null) {
            xcodeInstallation = new XcodeInstallation(file2);
            list.add(xcodeInstallation);
            map.put(file2, xcodeInstallation);
        }
        return xcodeInstallation;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/XcodeDiscoverer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverXcodeInstallations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/XcodeDiscoverer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodesAt";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getXcodeAppBaseFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

