/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Version;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.cidr.xcode.XcodeSettingsBase;
import com.jetbrains.cidr.xcode.plist.Plist;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XcodeBase
implements Disposable {
    @NotNull
    private final XcodeInstallation myInstallation = XcodeSettingsBase.getInstance().chooseXcodeInstallation();
    private volatile boolean myBroken = false;

    public XcodeBase() {
        XCLog.LOG.info("Using Xcode installation " + this.myInstallation);
    }

    public void dispose() {
    }

    @NotNull
    public static XcodeBase getInstance() {
        XcodeBase xcodeBase = (XcodeBase)ApplicationManager.getApplication().getService(XcodeBase.class);
        if (xcodeBase == null) {
            XcodeBase.j(0);
        }
        return xcodeBase;
    }

    @NotNull
    public XcodeInstallation getInstallation() {
        XcodeInstallation xcodeInstallation = this.myInstallation;
        if (xcodeInstallation == null) {
            XcodeBase.j(1);
        }
        return xcodeInstallation;
    }

    public boolean isInstalled() {
        return this.getInstallation().isInstalled();
    }

    @NotNull
    public String getBasePath() {
        String string = this.getInstallation().getBasePath();
        if (string == null) {
            XcodeBase.j(2);
        }
        return string;
    }

    @NotNull
    public File getBaseFile() {
        File file2 = this.getInstallation().getBaseFile();
        if (file2 == null) {
            XcodeBase.j(3);
        }
        return file2;
    }

    @NotNull
    public File getSubFile(@NonNls @Nullable String relativePath) {
        File file2 = this.getInstallation().getSubFile(relativePath);
        if (file2 == null) {
            XcodeBase.j(4);
        }
        return file2;
    }

    @NotNull
    public String getSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getInstallation().getSubFilePath(relativePath);
        if (string == null) {
            XcodeBase.j(5);
        }
        return string;
    }

    @NotNull
    public String getXcodebuildPath() {
        String string = this.getSubFilePath("usr/bin/xcodebuild");
        if (string == null) {
            XcodeBase.j(6);
        }
        return string;
    }

    @NotNull
    public String getSimctlPath() {
        String string = this.getSubFilePath("usr/bin/simctl");
        if (string == null) {
            XcodeBase.j(7);
        }
        return string;
    }

    @NotNull
    public File getApplicationFile() {
        File file2 = this.getInstallation().getApplicationFile();
        if (file2 == null) {
            XcodeBase.j(8);
        }
        return file2;
    }

    @NotNull
    public String getApplicationFilePath() {
        String string = this.getInstallation().getApplicationFilePath();
        if (string == null) {
            XcodeBase.j(9);
        }
        return string;
    }

    @NotNull
    public File getApplicationContentsSubFile(@Nullable @NonNls String relativePath) {
        File file2 = this.getInstallation().getApplicationContentsSubFile(relativePath);
        if (file2 == null) {
            XcodeBase.j(10);
        }
        return file2;
    }

    @NotNull
    public String getApplicationContentsSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getInstallation().getApplicationContentsSubFilePath(relativePath);
        if (string == null) {
            XcodeBase.j(11);
        }
        return string;
    }

    @NotNull
    public File getApplicationsSubFile(@Nullable @NonNls String relativePath) {
        File file2 = this.getInstallation().getApplicationsSubFile(relativePath);
        if (file2 == null) {
            XcodeBase.j(12);
        }
        return file2;
    }

    @NotNull
    public String getApplicationsSubFilePath(@Nullable @NonNls String relativePath) {
        String string = this.getInstallation().getApplicationsSubFilePath(relativePath);
        if (string == null) {
            XcodeBase.j(13);
        }
        return string;
    }

    @NotNull
    public List<File> getXcodeFrameworksFolders() {
        List<File> list = this.getInstallation().getXcodeFrameworksFolders();
        if (list == null) {
            XcodeBase.j(14);
        }
        return list;
    }

    @NotNull
    public String getVersionString() {
        String string = this.getInstallation().getVersionString();
        if (string == null) {
            XcodeBase.j(15);
        }
        return string;
    }

    @NotNull
    public String getDisplayVersion() {
        String string = this.getInstallation().getDisplayVersion();
        if (string == null) {
            XcodeBase.j(16);
        }
        return string;
    }

    @NotNull
    public ToolVersion getToolVersion() {
        ToolVersion toolVersion = this.getInstallation().getVersion();
        if (toolVersion == null) {
            XcodeBase.j(17);
        }
        return toolVersion;
    }

    @NotNull
    public Version getVersion() {
        Version version = this.getToolVersion().versionNumber;
        if (version == null) {
            XcodeBase.j(18);
        }
        return version;
    }

    @NotNull
    public String getBuildVersionString() {
        String string = this.getInstallation().getBuildVersionString();
        if (string == null) {
            XcodeBase.j(19);
        }
        return string;
    }

    @NotNull
    public Plist getSettings() {
        Plist plist = this.getInstallation().getSettings();
        if (plist == null) {
            XcodeBase.j(20);
        }
        return plist;
    }

    @NotNull
    public Dictionary getBuildSettings() {
        Dictionary dictionary = this.getInstallation().getBuildSettings();
        if (dictionary == null) {
            XcodeBase.j(21);
        }
        return dictionary;
    }

    public void setBroken() {
        this.myBroken = true;
    }

    public boolean isBroken() {
        return this.myBroken;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/xcode/XcodeBase";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodebuildPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimctlPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationContentsSubFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationContentsSubFilePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationsSubFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationsSubFilePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getXcodeFrameworksFolders";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionString";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayVersion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolVersion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildVersionString";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSettings";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

