/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.model.PBXProjectFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XCConfigParser {
    @NotNull
    public static Dictionary parseFile(@NotNull PBXProjectFile file2, @Nullable VirtualFile xconfigFile) {
        if (file2 == null) {
            XCConfigParser.j(0);
        }
        return XCConfigParser.parseFile(file2.getBaseDir(), xconfigFile);
    }

    @NotNull
    public static Dictionary parseFile(@NotNull VirtualFile baseDir, @Nullable VirtualFile xconfigFile) {
        if (baseDir == null) {
            XCConfigParser.j(1);
        }
        return XCConfigParser.j(baseDir, xconfigFile, new HashSet<VirtualFile>());
    }

    @NotNull
    private static Dictionary j(@NotNull VirtualFile virtualFile2, @Nullable VirtualFile virtualFile3, @NotNull Set<VirtualFile> set) {
        if (virtualFile2 == null) {
            XCConfigParser.j(2);
        }
        if (set == null) {
            XCConfigParser.j(3);
        }
        if (virtualFile3 == null || virtualFile3.isDirectory() || virtualFile3.getFileType().isBinary()) {
            Dictionary dictionary = Dictionary.EMPTY_DICTIONARY;
            if (dictionary == null) {
                XCConfigParser.j(4);
            }
            return dictionary;
        }
        if (!set.add(virtualFile3)) {
            Dictionary dictionary = Dictionary.EMPTY_DICTIONARY;
            if (dictionary == null) {
                XCConfigParser.j(5);
            }
            return dictionary;
        }
        Dictionary dictionary = new Dictionary();
        String string = XCConfigParser.j(virtualFile3);
        for (String string2 : StringUtil.split((String)string, (String)"\n")) {
            int n2 = string2.indexOf("//");
            if (n2 != -1) {
                string2 = string2.substring(0, n2);
            }
            string2 = string2.trim();
            if ((string2 = StringUtil.trimEnd((String)string2, (String)";")).startsWith("#include")) {
                VirtualFile virtualFile4;
                String string3 = StringUtil.trimStart((String)StringUtil.trimStart((String)string2, (String)"#include"), (String)"?").trim();
                if (string3.startsWith("\"") || string3.startsWith("<")) {
                    string3 = string3.substring(1);
                }
                if (string3.endsWith("\"") || string3.endsWith(">")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if ((virtualFile4 = virtualFile3.getParent().findFileByRelativePath(string3)) == null) {
                    virtualFile4 = virtualFile2.findFileByRelativePath(string3);
                }
                dictionary.putAll(XCConfigParser.j(virtualFile2, virtualFile4, set));
                continue;
            }
            int n3 = -1;
            int n4 = 0;
            boolean bl = false;
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                if (c2 == '\"' && (i2 == 0 || string2.charAt(i2 - 1) != '\\')) {
                    bl = !bl;
                    continue;
                }
                if (bl) continue;
                if (n4 == 0 && c2 == '=') {
                    n3 = i2;
                    break;
                }
                if (c2 == '[' || c2 == '(' || c2 == '{' || c2 == '<') {
                    ++n4;
                    continue;
                }
                if (c2 != ']' && c2 != ')' && c2 != '}' && c2 != '>') continue;
                --n4;
            }
            if (n3 <= 0) continue;
            String string4 = string2.substring(0, n3).trim();
            String string5 = string2.substring(n3 + 1).trim();
            dictionary.put(string4, (Object)string5);
        }
        Dictionary dictionary2 = dictionary;
        if (dictionary2 == null) {
            XCConfigParser.j(6);
        }
        return dictionary2;
    }

    @NotNull
    private static String j(@NotNull VirtualFile virtualFile2) {
        String string;
        if (virtualFile2 == null) {
            XCConfigParser.j(7);
        }
        try {
            virtualFile2.setCharset(StandardCharsets.UTF_8);
            string = LoadTextUtil.getTextByBinaryPresentation((byte[])virtualFile2.contentsToByteArray(), (Charset)StandardCharsets.UTF_8).toString();
        }
        catch (IOException iOException) {
            return "";
        }
        if (string == null) {
            XCConfigParser.j(8);
        }
        return string;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 4, 5, 6, 8 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursionGuard";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/XCConfigParser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xconfigFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/XCConfigParser";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doParseFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doParseFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

