/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import com.jetbrains.cidr.execution.CidrExecUtil;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J5\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/xcode/SwiftToolchain;", "", "bundleId", "", "path", "displayName", "isXcodeDefault", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getBundleId", "()Ljava/lang/String;", "getDisplayName", "()Z", "getPath", "appendEnvironmentVariables", "", "map", "", "type", "Lcom/jetbrains/cidr/xcode/frameworks/ApplePlatform$Type;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.cidr.cocoaCommon"})
@SourceDebugExtension(value={"SMAP\nSwiftToolchain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwiftToolchain.kt\ncom/jetbrains/cidr/xcode/SwiftToolchain\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class SwiftToolchain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String bundleId;
    @NotNull
    private final String path;
    @Nullable
    private final String displayName;
    private final boolean isXcodeDefault;

    public SwiftToolchain(@Nullable String bundleId, @NotNull String path, @Nullable String displayName2, boolean isXcodeDefault) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.bundleId = bundleId;
        this.path = path;
        this.displayName = displayName2;
        this.isXcodeDefault = isXcodeDefault;
    }

    public /* synthetic */ SwiftToolchain(String string, String string2, String string3, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(string, string2, string3, bl);
    }

    @Nullable
    public final String getBundleId() {
        return this.bundleId;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final String getDisplayName() {
        return this.displayName;
    }

    public final boolean isXcodeDefault() {
        return this.isXcodeDefault;
    }

    public final void appendEnvironmentVariables(@NotNull Map<String, String> map, @NotNull ApplePlatform.Type type) {
        File file2;
        File file3;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (this.isXcodeDefault) {
            return;
        }
        File file4 = file3 = new File(this.path, "usr/lib/swift/" + type.getPlatformName());
        boolean bl = false;
        File file5 = file2 = file4.isDirectory() ? file3 : null;
        if (file2 != null) {
            CidrExecUtil.appendSearchPath(map, "DYLD_LIBRARY_PATH", file2.getAbsolutePath());
        }
    }

    @Nullable
    public final String component1() {
        return this.bundleId;
    }

    @NotNull
    public final String component2() {
        return this.path;
    }

    @Nullable
    public final String component3() {
        return this.displayName;
    }

    public final boolean component4() {
        return this.isXcodeDefault;
    }

    @NotNull
    public final SwiftToolchain copy(@Nullable String bundleId, @NotNull String path, @Nullable String displayName2, boolean isXcodeDefault) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new SwiftToolchain(bundleId, path, displayName2, isXcodeDefault);
    }

    public static /* synthetic */ SwiftToolchain copy$default(SwiftToolchain swiftToolchain, String string, String string2, String string3, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = swiftToolchain.bundleId;
        }
        if ((n2 & 2) != 0) {
            string2 = swiftToolchain.path;
        }
        if ((n2 & 4) != 0) {
            string3 = swiftToolchain.displayName;
        }
        if ((n2 & 8) != 0) {
            bl = swiftToolchain.isXcodeDefault;
        }
        return swiftToolchain.copy(string, string2, string3, bl);
    }

    @NotNull
    public String toString() {
        return "SwiftToolchain(bundleId=" + this.bundleId + ", path=" + this.path + ", displayName=" + this.displayName + ", isXcodeDefault=" + this.isXcodeDefault + ")";
    }

    public int hashCode() {
        int n2 = this.bundleId == null ? 0 : this.bundleId.hashCode();
        n2 = n2 * 31 + this.path.hashCode();
        n2 = n2 * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        n2 = n2 * 31 + Boolean.hashCode(this.isXcodeDefault);
        return n2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwiftToolchain)) {
            return false;
        }
        SwiftToolchain swiftToolchain = (SwiftToolchain)other;
        if (!Intrinsics.areEqual((Object)this.bundleId, (Object)swiftToolchain.bundleId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)swiftToolchain.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.displayName, (Object)swiftToolchain.displayName)) {
            return false;
        }
        return this.isXcodeDefault == swiftToolchain.isXcodeDefault;
    }

    @JvmStatic
    @NotNull
    public static final SwiftToolchain getXcodeSelectedToolchain(@NotNull XcodeInstallation xcodeInstallation) {
        return Companion.getXcodeSelectedToolchain(xcodeInstallation);
    }

    @JvmStatic
    @Nullable
    public static final SwiftToolchain findInstalledToolchain(@NotNull String bundleIdentifier) {
        return Companion.findInstalledToolchain(bundleIdentifier);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/xcode/SwiftToolchain$Companion;", "", "()V", "j", "Lcom/jetbrains/cidr/xcode/SwiftToolchain;", "bundleId", "", "findInstalledToolchain", "bundleIdentifier", "j", "xcodeInstallation", "Lcom/jetbrains/cidr/xcode/XcodeInstallation;", "getXcodeSelectedToolchain", "intellij.cidr.cocoaCommon"})
    @SourceDebugExtension(value={"SMAP\nSwiftToolchain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwiftToolchain.kt\ncom/jetbrains/cidr/xcode/SwiftToolchain$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1360#2:73\n1446#2,5:74\n*S KotlinDebug\n*F\n+ 1 SwiftToolchain.kt\ncom/jetbrains/cidr/xcode/SwiftToolchain$Companion\n*L\n54#1:73\n54#1:74,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SwiftToolchain getXcodeSelectedToolchain(@NotNull XcodeInstallation xcodeInstallation) {
            Intrinsics.checkNotNullParameter((Object)xcodeInstallation, (String)"xcodeInstallation");
            Object object = new String[]{"sh", "-c", "defaults read com.apple.dt.Xcode DVTDefaultToolchainOverrideIdentifer"};
            String string = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(object));
            object = null;
            CharSequence charSequence = string;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                object = this.findInstalledToolchain(string);
            }
            Object object2 = object;
            if (object == null) {
                object2 = this.j(xcodeInstallation);
            }
            return object2;
        }

        private final SwiftToolchain j(XcodeInstallation xcodeInstallation) {
            String string = xcodeInstallation.getSubFilePath("Toolchains/XcodeDefault.xctoolchain/");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubFilePath(...)");
            return new SwiftToolchain(null, string, null, true);
        }

        @JvmStatic
        @Nullable
        public final SwiftToolchain findInstalledToolchain(@NotNull String bundleIdentifier) {
            Intrinsics.checkNotNullParameter((Object)bundleIdentifier, (String)"bundleIdentifier");
            SwiftToolchain swiftToolchain = this.j(bundleIdentifier);
            if (swiftToolchain == null) {
                XCLog.LOG.warn("Failed to find selected swift toolchain with identifier: " + bundleIdentifier);
            }
            return swiftToolchain;
        }

        private final SwiftToolchain j(String string) {
            String string2 = "/Library/Developer/Toolchains/";
            Object object = new String[]{string2, SystemProperties.getUserHome() + string2};
            List list = CollectionsKt.listOf((Object[])object);
            Object object2 = list;
            boolean bl = false;
            Object object3 = object2;
            Object object4 = new ArrayList();
            boolean bl2 = false;
            Object object5 = object3.iterator();
            while (object5.hasNext()) {
                List list2;
                Object t10 = object5.next();
                Object object6 = (String)t10;
                boolean bl3 = false;
                Object[] objectArray = new File((String)object6).listFiles(Companion::j);
                object6 = objectArray != null && (list2 = ArraysKt.toList((Object[])objectArray)) != null ? list2 : CollectionsKt.emptyList();
                CollectionsKt.addAll((Collection)object4, (Iterable)object6);
            }
            object = (List)object4;
            object2 = object.iterator();
            while (object2.hasNext()) {
                File file2 = (File)object2.next();
                object3 = new File(file2, "Info.plist");
                Object object7 = object4 = PlistDriver.readAnyFormatSafe((File)object3);
                String string3 = object7 != null ? ((Dictionary)object7).getString("CFBundleIdentifier") : null;
                Object object8 = object4;
                Object object9 = object5 = object8 != null ? ((Dictionary)object8).getString("DisplayName") : null;
                if (!Intrinsics.areEqual((Object)string3, (Object)string)) continue;
                String string4 = file2.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
                return new SwiftToolchain(string, string4, (String)object5, false, 8, null);
            }
            return null;
        }

        private static final boolean j(File file2) {
            return FileUtilRt.extensionEquals((String)file2.getPath(), (String)"xctoolchain");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

