/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.notification.NotificationType;
import com.jetbrains.cidr.CocoaCommonBundle;
import com.jetbrains.cidr.xcode.Action;
import com.jetbrains.cidr.xcode.OpenXcodeSettingsAction;
import com.jetbrains.cidr.xcode.SwitchXcodeAction;
import com.jetbrains.cidr.xcode.XCLog;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003J.\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/xcode/Message;", "", "type", "Lcom/intellij/notification/NotificationType;", "message", "", "Lorg/jetbrains/annotations/Nls;", "action", "Lcom/jetbrains/cidr/xcode/Action;", "(Lcom/intellij/notification/NotificationType;Ljava/lang/String;Lcom/jetbrains/cidr/xcode/Action;)V", "getAction", "()Lcom/jetbrains/cidr/xcode/Action;", "getMessage", "()Ljava/lang/String;", "getType", "()Lcom/intellij/notification/NotificationType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.cidr.cocoaCommon"})
public final class Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotificationType type;
    @NotNull
    private final String message;
    @Nullable
    private final Action action;

    public Message(@NotNull NotificationType type, @NotNull String message2, @Nullable Action action2) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.type = type;
        this.message = message2;
        this.action = action2;
        if (this.action != null) {
            XCLog.LOG.assertTrue(((CharSequence)this.message).length() > 0);
        }
    }

    @NotNull
    public final NotificationType getType() {
        return this.type;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final Action getAction() {
        return this.action;
    }

    @NotNull
    public String toString() {
        return ((CharSequence)this.message).length() == 0 ? "-----" : (this.action != null ? this.type + ":" + this.message + " -> " + this.action : this.type + ":" + this.message);
    }

    @NotNull
    public final NotificationType component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.message;
    }

    @Nullable
    public final Action component3() {
        return this.action;
    }

    @NotNull
    public final Message copy(@NotNull NotificationType type, @NotNull String message2, @Nullable Action action2) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        return new Message(type, message2, action2);
    }

    public static /* synthetic */ Message copy$default(Message message2, NotificationType notificationType, String string, Action action2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            notificationType = message2.type;
        }
        if ((n2 & 2) != 0) {
            string = message2.message;
        }
        if ((n2 & 4) != 0) {
            action2 = message2.action;
        }
        return message2.copy(notificationType, string, action2);
    }

    public int hashCode() {
        int n2 = this.type.hashCode();
        n2 = n2 * 31 + this.message.hashCode();
        n2 = n2 * 31 + (this.action == null ? 0 : this.action.hashCode());
        return n2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Message)) {
            return false;
        }
        Message message2 = (Message)other;
        if (this.type != message2.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)message2.message)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.action, (Object)message2.action);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0015\u0010\u0007\u001a\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u0010J\u0013\u0010\u0011\u001a\u00020\u00042\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u0010J\u0006\u0010\u0012\u001a\u00020\u0004J\u001b\u0010\u0013\u001a\u00020\u00042\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/xcode/Message$Companion;", "", "()V", "newBundleMessage", "Lcom/jetbrains/cidr/xcode/Message;", "type", "Lcom/intellij/notification/NotificationType;", "message", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.CocoaCommonBundle", "params", "", "(Lcom/intellij/notification/NotificationType;Ljava/lang/String;[Ljava/lang/Object;)Lcom/jetbrains/cidr/xcode/Message;", "newMessage", "Lorg/jetbrains/annotations/Nls;", "newSelectXcodeManuallyMessage", "newSeparator", "newSwitchMessage", "switchTo", "Ljava/io/File;", "intellij.cidr.cocoaCommon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Message newBundleMessage(@NotNull NotificationType type, @NotNull String message2, Object ... params2) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
            String string = CocoaCommonBundle.message(message2, Arrays.copyOf(params2, params2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.newMessage(type, string);
        }

        @NotNull
        public final Message newMessage(@NotNull NotificationType type, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            return new Message(type, message2, null);
        }

        @NotNull
        public final Message newSeparator() {
            return new Message(NotificationType.INFORMATION, "", null);
        }

        @NotNull
        public final Message newSwitchMessage(@NotNull String message2, @NotNull File switchTo) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)switchTo, (String)"switchTo");
            return new Message(NotificationType.INFORMATION, message2, new SwitchXcodeAction(switchTo));
        }

        @NotNull
        public final Message newSelectXcodeManuallyMessage(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            return new Message(NotificationType.INFORMATION, message2, OpenXcodeSettingsAction.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

