/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.xcode;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Dictionary
implements Map<String, Object> {
    private static final SimpleModificationTracker NEVER_CHANGED = new MyNeverChangedModificationTracker();
    private static final NotNullProducer<Map<String, Object>> DEFAULT_PRODUCER = () -> new LinkedHashMap();
    private static final NotNullProducer<Map<String, Object>> EMPTY_PRODUCER = () -> Collections.emptyMap();
    public static final Dictionary EMPTY_DICTIONARY = new Dictionary(true);
    private final NotNullProducer<Map<String, Object>> myMapFactory;
    @NotNull
    protected final SimpleModificationTracker myAttributesModificationTracker;
    private final Map<String, Object> myAttributes;
    private static final Logger LOG = Logger.getInstance(Dictionary.class);

    public Dictionary() {
        this(DEFAULT_PRODUCER);
    }

    public Dictionary(boolean emptyFlag) {
        this(EMPTY_PRODUCER);
    }

    public Dictionary(@NotNull NotNullProducer<Map<String, Object>> mapFactory) {
        if (mapFactory == null) {
            Dictionary.j(0);
        }
        this.myMapFactory = mapFactory;
        this.myAttributesModificationTracker = this.createAttributesModificationTracker();
        this.myAttributes = this.j();
    }

    @NotNull
    protected SimpleModificationTracker createAttributesModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = NEVER_CHANGED;
        if (simpleModificationTracker == null) {
            Dictionary.j(1);
        }
        return simpleModificationTracker;
    }

    private Map<String, Object> j() {
        return (Map)this.myMapFactory.produce();
    }

    @Override
    public boolean isEmpty() {
        return this.myAttributes.isEmpty();
    }

    @Override
    public int size() {
        return this.myAttributes.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myAttributes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.myAttributes.containsValue(value2);
    }

    @Override
    public Object put(@NonNls String key, Object value2) {
        return this.put(key, value2, true);
    }

    public Object put(@NonNls String key, Object value2, boolean checkValue) {
        if (checkValue) {
            this.checkAttribute(value2);
        }
        Object object = this.myAttributes.put(key, value2);
        this.myAttributesModificationTracker.incModificationCount();
        return object;
    }

    protected void checkAttribute(Object value2) {
        if (!this.isValidAttribute(value2)) {
            Object object = "Unsupported attribute: ";
            if (value2 != null) {
                object = (String)object + "(" + value2.getClass().getName() + ")";
            }
            object = (String)object + String.valueOf(value2);
            throw new IllegalArgumentException((String)object);
        }
        if (value2 instanceof Collection) {
            for (Object e2 : (Collection)value2) {
                this.checkAttribute(e2);
            }
        }
    }

    protected boolean isValidAttribute(@Nullable Object value2) {
        return true;
    }

    private void j(Map<? extends String, ?> map) {
        for (Object obj : map.values()) {
            this.checkAttribute(obj);
        }
    }

    @Override
    public Object remove(Object key) {
        Object object = this.myAttributes.remove(key);
        this.myAttributesModificationTracker.incModificationCount();
        return object;
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ?> m2) {
        if (m2 == null) {
            Dictionary.j(2);
        }
        this.j(m2);
        this.myAttributes.putAll(m2);
        this.myAttributesModificationTracker.incModificationCount();
    }

    public void setAttribute(@NonNls @NotNull String key, @NonNls @Nullable Object value2) {
        if (key == null) {
            Dictionary.j(3);
        }
        this.setAttribute(key, value2, true);
    }

    public void setAttribute(@NonNls @NotNull String key, @Nullable Object value2, boolean checkValue) {
        if (key == null) {
            Dictionary.j(4);
        }
        if (value2 == null) {
            this.remove(key);
        } else {
            this.put(key, value2, checkValue);
        }
    }

    @Override
    public void clear() {
        this.myAttributes.clear();
        this.myAttributesModificationTracker.incModificationCount();
    }

    @Override
    @Nullable
    public Object get(@NotNull Object key) {
        if (key == null) {
            Dictionary.j(5);
        }
        return this.myAttributes.get(key);
    }

    @Contract(value="_,!null -> !null")
    public Dictionary getDictionary(@NonNls @NotNull String key, @Nullable Dictionary defValue) {
        if (key == null) {
            Dictionary.j(6);
        }
        return this.getAttribute(key, Dictionary.class, defValue);
    }

    @Nullable
    public String getString(@NotNull @NonNls String key) {
        if (key == null) {
            Dictionary.j(7);
        }
        return this.getString(key, null);
    }

    @Contract(value="_,!null -> !null")
    public String getString(@NonNls @NotNull String key, @Nullable String defValue) {
        Object object;
        if (key == null) {
            Dictionary.j(8);
        }
        if ((object = this.get(key)) == null) {
            return defValue;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return this.checked(object, String.class);
    }

    @Nullable
    public String tryGetString(@NotNull @NonNls String key) {
        Object object;
        if (key == null) {
            Dictionary.j(9);
        }
        return (object = this.get(key)) instanceof String ? (String)object : null;
    }

    @NotNull
    public String getNotNullString(@NonNls @NotNull String key) {
        if (key == null) {
            Dictionary.j(10);
        }
        String string = this.notNull(key, this.getString(key));
        if (string == null) {
            Dictionary.j(11);
        }
        return string;
    }

    @Nullable
    public <T> T getAttribute(@NonNls @NotNull String key, @Nullable Class<T> clazz) {
        if (key == null) {
            Dictionary.j(12);
        }
        return this.getAttribute(key, clazz, null);
    }

    @Contract(value="_,_,!null -> !null")
    public <T> T getAttribute(@NonNls @NotNull String key, @Nullable Class<T> clazz, @Nullable T defValue) {
        T t10;
        if (key == null) {
            Dictionary.j(13);
        }
        return (t10 = this.checked(this.get(key), clazz)) == null ? defValue : t10;
    }

    @NotNull
    public <T> T getNotNullAttribute(@NonNls @NotNull String key, @Nullable Class<T> clazz) {
        if (key == null) {
            Dictionary.j(14);
        }
        T t10 = this.notNull(key, this.getAttribute(key, clazz));
        if (t10 == null) {
            Dictionary.j(15);
        }
        return t10;
    }

    @Contract(value="_,_,!null -> !null")
    public <T> List<T> getAttributeList(@NonNls @NotNull String key, @Nullable Class<T> clazz, @Nullable List<T> defValue) {
        List<T> list;
        if (key == null) {
            Dictionary.j(16);
        }
        if ((list = this.getAttribute(key, List.class, defValue)) != null && clazz != null) {
            for (T t10 : list) {
                this.checked(t10, clazz);
            }
        }
        return list;
    }

    @NotNull
    public <T> List<T> getObjects(@Nullable Class<T> clazz) {
        SmartList smartList = new SmartList();
        for (Object object : this.myAttributes.values()) {
            if (clazz != null && !clazz.isInstance(object)) continue;
            smartList.add(object);
        }
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            Dictionary.j(17);
        }
        return smartList2;
    }

    @Override
    public Set<@NonNls String> keySet() {
        return this.myAttributes.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.myAttributes.values();
    }

    @Override
    public Set<Map.Entry<@NonNls String, Object>> entrySet() {
        return this.myAttributes.entrySet();
    }

    @NonNls
    public String toString() {
        return Dictionary.j(this, "");
    }

    @NonNls
    private static String j(Object object, String string) {
        if (object instanceof Dictionary) {
            Map<String, Object> map = ((Dictionary)object).myAttributes;
            if (map.isEmpty()) {
                return "{ }";
            }
            return "{\n" + StringUtil.join(map.entrySet(), entry2 -> string + " " + (String)entry2.getKey() + " = " + Dictionary.j(entry2.getValue(), string + " "), (String)"\n") + "\n" + string + "}";
        }
        return object.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.myAttributes.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.myAttributes.hashCode();
    }

    @NotNull
    protected <T> T notNull(@NotNull String key, @Nullable T obj) {
        if (key == null) {
            Dictionary.j(18);
        }
        if (obj == null) {
            throw new InvalidSpecException("Object '" + key + "' not found in " + this.toString());
        }
        T t10 = obj;
        if (t10 == null) {
            Dictionary.j(19);
        }
        return t10;
    }

    public <T> T checked(@Nullable Object obj, @Nullable Class<T> clazz) {
        return Dictionary.checked(this, obj, clazz);
    }

    public static <T> T checked(@Nullable Dictionary self, @Nullable Object obj, @Nullable Class<T> clazz) {
        if (obj != null && clazz != null && !clazz.isInstance(obj)) {
            LOG.error("Cannot cast object " + obj.getClass() + " to " + clazz + "\n" + obj.toString() + "from:\n" + self);
            return null;
        }
        return (T)obj;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 11, 15, 17, 19 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapFactory";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/xcode/Dictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/xcode/Dictionary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttributesModificationTracker";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullAttribute";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjects";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 17: 
            case 19: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDictionary";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryGetString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullAttribute";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeList";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notNull";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 11, 15, 17, 19 -> new IllegalStateException(string);
        };
    }

    private static class MyNeverChangedModificationTracker
    extends SimpleModificationTracker {
        private MyNeverChangedModificationTracker() {
        }

        public long getModificationCount() {
            return 0L;
        }

        public void incModificationCount() {
        }
    }
}

