/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.util.events.impl;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import com.jetbrains.cidr.util.events.impl.ChromeTracingEventTracer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/util/events/impl/ToggleChromeTracingAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "()V", "myIsRunning", "", "myTimeStarted", "", "productCode", "", "Lorg/jetbrains/annotations/NotNull;", "j", "()Ljava/lang/String;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "j", "N", "intellij.cidr.util.execution"})
@SourceDebugExtension(value={"SMAP\nChromeTracingEventTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeTracingEventTracer.kt\ncom/jetbrains/cidr/util/events/impl/ToggleChromeTracingAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
public final class ToggleChromeTracingAction
extends DumbAwareToggleAction {
    private boolean myIsRunning = Boolean.getBoolean("cidr.enable.json.tracer");
    private long myTimeStarted = System.currentTimeMillis();

    public ToggleChromeTracingAction() {
        if (this.myIsRunning) {
            this.j();
        }
    }

    private final String j() {
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        return string;
    }

    public boolean isSelected(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        return this.myIsRunning;
    }

    public void setSelected(@NotNull AnActionEvent e2, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        this.j(state);
    }

    private final void j(boolean bl) {
        this.myIsRunning = bl;
        if (this.myIsRunning) {
            this.j();
        } else {
            this.N();
        }
    }

    private final void j() {
        this.myTimeStarted = System.currentTimeMillis();
        ChromeTracingEventTracer.Companion.getInstance().startTracing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void N() {
        long l2 = (System.currentTimeMillis() - this.myTimeStarted) / (long)1000;
        String string = new SimpleDateFormat("'" + this.j() + "-trace.'yyyy-MM-dd-HH-mm-ss'-[" + l2 + "sec]'").format(new Date());
        File file2 = FileUtil.createTempFile((File)new File(SystemProperties.getUserHome()), (String)string, (String)".json.gz", (boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
        File file3 = file2;
        Object[] objectArray = new GZIPOutputStream((OutputStream)new FileOutputStream(file3), 65536);
        Object object = Charsets.UTF_8;
        objectArray = new OutputStreamWriter((OutputStream)objectArray, (Charset)object);
        object = null;
        try {
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)objectArray;
            boolean bl = false;
            ChromeTracingEventTracer.Companion.getInstance().write(outputStreamWriter);
            outputStreamWriter = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)objectArray, (Throwable)object);
        }
        objectArray = new Object[]{file3.getPath()};
        objectArray = new Notification("System Messages", CidrUtilsExecutionBundle.message("chrome.trace.title", new Object[0]), CidrUtilsExecutionBundle.message("chrome.trace.message", objectArray), NotificationType.INFORMATION);
        object = objectArray;
        boolean bl = false;
        object.addAction((AnAction)NotificationAction.createSimpleExpiring((String)RevealFileAction.getActionName(), () -> ToggleChromeTracingAction.j(file3)));
        Notifications.Bus.notify((Notification)objectArray);
        ChromeTracingEventTracer.Companion.getInstance().stopTracing();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final void j(File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"$outFile");
        RevealFileAction.openFile((File)file2);
    }
}

