/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.cidr.CidrLogService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001aE\u0010\u0002\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u001c\u0010\b\u001a\u0018\u0012\u0004\u0012\u0002H\u0003\u0012\u000e\b\u0001\u0012\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b0\t\u00a2\u0006\u0002\u0010\f\u001a!\u0010\r\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00030\u000f\u00a2\u0006\u0002\u0010\u0010\u001a\u001a\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00030\u000f\u001a\u001a\u0010\u0014\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00030\u000f\u001a\u001a\u0010\u0015\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00030\u000f\u001a\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u001a3\u0010\u001b\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010 \u001a\u00020\u0005\u00a2\u0006\u0002\u0010!\u001a+\u0010\u001b\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00030\u001d2\b\b\u0001\u0010 \u001a\u00020\u0005\u00a2\u0006\u0002\u0010\"\u001a3\u0010#\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010 \u001a\u00020\u0005\u00a2\u0006\u0002\u0010!\u001a+\u0010#\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00030\u001d2\b\b\u0001\u0010 \u001a\u00020\u0005\u00a2\u0006\u0002\u0010\"\u001a=\u0010$\u001a\u0004\u0018\u0001H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010 \u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010&\u00a8\u0006'"}, d2={"checkCanceled", "", "computeUnderProgress", "T", "title", "", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/openapi/util/ThrowableComputable;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "getIfCompletedNormally", "future", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Object;", "isCompletedByCancel", "", "f", "isCompletedExceptionally", "isCompletedNormally", "j", "Lcom/intellij/openapi/progress/ProgressIndicator;", "hasTimeout", "writeActionWatcher", "Lcom/intellij/openapi/Disposable;", "waitCancelAndWriteActionAware", "clangFuture", "Ljava/util/concurrent/Future;", "timeoutMs", "", "waitingFor", "(Ljava/util/concurrent/Future;JLjava/lang/String;)Ljava/lang/Object;", "(Ljava/util/concurrent/Future;Ljava/lang/String;)Ljava/lang/Object;", "waitCancelAware", "j", "cancelByWA", "(Ljava/util/concurrent/Future;JLjava/lang/String;Z)Ljava/lang/Object;", "intellij.cidr.util"})
@SourceDebugExtension(value={"SMAP\nCidrConcurrentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrConcurrentUtils.kt\ncom/jetbrains/cidr/util/CidrConcurrentUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n1#2:206\n*E\n"})
public final class CidrConcurrentUtilsKt {
    @Nullable
    public static final <T> T waitCancelAware(@NotNull Future<T> clangFuture, @NonNls @NotNull String waitingFor) throws ExecutionException {
        Intrinsics.checkNotNullParameter(clangFuture, (String)"clangFuture");
        Intrinsics.checkNotNullParameter((Object)waitingFor, (String)"waitingFor");
        while (true) {
            try {
                return CidrConcurrentUtilsKt.waitCancelAware(clangFuture, Long.MAX_VALUE, waitingFor);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    @Nullable
    public static final <T> T waitCancelAware(@NotNull Future<T> clangFuture, long timeoutMs, @NonNls @NotNull String waitingFor) throws ExecutionException, TimeoutException {
        Intrinsics.checkNotNullParameter(clangFuture, (String)"clangFuture");
        Intrinsics.checkNotNullParameter((Object)waitingFor, (String)"waitingFor");
        return CidrConcurrentUtilsKt.j(clangFuture, timeoutMs, waitingFor, false);
    }

    @Nullable
    public static final <T> T waitCancelAndWriteActionAware(@NotNull Future<T> clangFuture, @NonNls @NotNull String waitingFor) throws ExecutionException {
        Intrinsics.checkNotNullParameter(clangFuture, (String)"clangFuture");
        Intrinsics.checkNotNullParameter((Object)waitingFor, (String)"waitingFor");
        while (true) {
            try {
                return CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(clangFuture, Long.MAX_VALUE, waitingFor);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    @Nullable
    public static final <T> T waitCancelAndWriteActionAware(@NotNull Future<T> clangFuture, long timeoutMs, @NonNls @NotNull String waitingFor) throws ExecutionException, TimeoutException {
        Intrinsics.checkNotNullParameter(clangFuture, (String)"clangFuture");
        Intrinsics.checkNotNullParameter((Object)waitingFor, (String)"waitingFor");
        return CidrConcurrentUtilsKt.j(clangFuture, timeoutMs, waitingFor, true);
    }

    /*
     * Exception decompiling
     */
    private static final <T> T j(Future<T> var0, long var1_1, @NonNls String var3_2, boolean var4_3) throws ExecutionException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP], 5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final <T> boolean isCompletedByCancel(@NotNull CompletableFuture<T> f2) {
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        if (f2.isCancelled()) {
            return true;
        }
        if (f2.isCompletedExceptionally()) {
            try {
                f2.get();
            }
            catch (Throwable throwable) {
                return throwable instanceof ExecutionException && throwable.getCause() instanceof ProcessCanceledException;
            }
        }
        return false;
    }

    public static final <T> boolean isCompletedExceptionally(@NotNull CompletableFuture<T> f2) {
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        return f2.isDone() && f2.isCompletedExceptionally();
    }

    public static final <T> boolean isCompletedNormally(@NotNull CompletableFuture<T> f2) {
        Intrinsics.checkNotNullParameter(f2, (String)"f");
        return f2.isDone() && !f2.isCompletedExceptionally();
    }

    @Nullable
    public static final <T> T getIfCompletedNormally(@NotNull CompletableFuture<T> future2) {
        Intrinsics.checkNotNullParameter(future2, (String)"future");
        if (CidrConcurrentUtilsKt.isCompletedNormally(future2)) {
            try {
                return future2.get();
            }
            catch (InterruptedException interruptedException) {
                CidrLogService.LOG.warn("How is it possible?!", (Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                CidrLogService.LOG.warn("How is it possible?!", (Throwable)executionException);
            }
        }
        return null;
    }

    public static final void checkCanceled() {
        ProgressManager.checkCanceled();
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            application.runReadAction(CidrConcurrentUtilsKt::j);
        }
    }

    @Nullable
    public static final <T> T computeUnderProgress(@Nls @NotNull String title, @Nullable Project project2, @NotNull ThrowableComputable<T, ? extends RuntimeException> task2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        ThreadingAssertions.assertEventDispatchThread();
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            ThrowableComputable throwableComputable = () -> CidrConcurrentUtilsKt.j(task2);
            return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(throwableComputable, title, true, project2);
        }
        return (T)task2.compute();
    }

    private static final ProgressIndicator j(boolean bl, Disposable disposable) {
        Application application = ApplicationManager.getApplication();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Job job2 = Cancellation.currentJob();
        if (progressIndicator == null && job2 == null && !bl && !application.isUnitTestMode()) {
            String string = "Not cancellable waiting?";
            CidrLogService.logOnce(Level.WARNING, string, new Exception(string));
        }
        if (disposable != null && (progressIndicator != null || job2 != null) && !application.isDispatchThread() && application.isReadAccessAllowed()) {
            application.addApplicationListener(new ApplicationListener(progressIndicator, job2){
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ Job $job;
                {
                    this.$indicator = $indicator;
                    this.$job = $job;
                }

                public void beforeWriteActionStart(@NotNull Object action2) {
                    Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                    if (this.$indicator != null) {
                        if (this.$indicator.isRunning()) {
                            this.$indicator.cancel();
                        }
                    } else if (this.$job != null && this.$job.isActive()) {
                        this.$job.cancel(new CancellationException("Canceled by waitCancelAware() because of write action"));
                    }
                }
            }, disposable);
        }
        return progressIndicator;
    }

    private static final void j() {
    }

    private static final Object N(ThrowableComputable throwableComputable) {
        Intrinsics.checkNotNullParameter((Object)throwableComputable, (String)"$task");
        return ReadAction.compute((ThrowableComputable)throwableComputable);
    }

    private static final Object j(ThrowableComputable throwableComputable) {
        Intrinsics.checkNotNullParameter((Object)throwableComputable, (String)"$task");
        return ProgressManager.getInstance().computePrioritized(() -> CidrConcurrentUtilsKt.N(throwableComputable));
    }
}

