/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionLegacy;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WSLCidrUtil {
    @NotNull
    public static List<WSLDistribution> getAvailableDistributions() {
        List<WSLDistribution> list = WSLCidrUtil.j();
        ArrayList<WSLDistributionWithRootInternal> arrayList = new ArrayList<WSLDistributionWithRootInternal>(list.size());
        for (WSLDistribution wSLDistribution : list) {
            if (wSLDistribution instanceof WSLDistributionLegacy) continue;
            arrayList.add(WSLCidrUtil.j(wSLDistribution));
        }
        List<WSLDistribution> list2 = Collections.unmodifiableList(arrayList);
        if (list2 == null) {
            WSLCidrUtil.j(0);
        }
        return list2;
    }

    @NotNull
    private static WSLDistributionWithRootInternal j(@NotNull WSLDistribution wSLDistribution) {
        if (wSLDistribution == null) {
            WSLCidrUtil.j(1);
        }
        return new WSLDistributionWithRootInternal(wSLDistribution){

            @Override
            @NotNull
            public String getWindowsPath(@NotNull String wslPath) {
                if (wslPath == null) {
                    1.N(0);
                }
                if (this.myWslRootInHost != null && FileUtil.isAncestor((String)this.myWslRootInHost, (String)wslPath, (boolean)true)) {
                    String string = wslPath;
                    if (string == null) {
                        1.N(1);
                    }
                    return string;
                }
                String string = super.getWindowsPath(wslPath);
                if (string == null) {
                    1.N(2);
                }
                return string;
            }

            private static /* synthetic */ void N(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n2) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wslPath";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getWindowsPath";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getWindowsPath";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n2) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static boolean hasAvailableDistributions() {
        return !WSLCidrUtil.j().isEmpty();
    }

    @NotNull
    private static List<WSLDistribution> j() {
        if (EDT.isCurrentThreadEdt()) {
            List list = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> WslDistributionManager.getInstance().getInstalledDistributions(), CidrUtilsExecutionBundle.message("dialog.title.fetching.wsl.distributions", new Object[0]), false, null);
            if (list == null) {
                WSLCidrUtil.j(2);
            }
            return list;
        }
        List list = WslDistributionManager.getInstance().getInstalledDistributions();
        if (list == null) {
            WSLCidrUtil.j(3);
        }
        return list;
    }

    @Nullable
    public static WSLDistribution getDistributionByExecutionPath(@NotNull String exePath) {
        if (exePath == null) {
            WSLCidrUtil.j(4);
        }
        if (exePath.isEmpty()) {
            return null;
        }
        WSLDistribution wSLDistribution2 = (WSLDistribution)ContainerUtil.find((Iterable)WSLUtil.getAvailableDistributions(), wSLDistribution -> {
            Path path = wSLDistribution.getExecutablePath();
            return path != null && exePath.equals(path.toString());
        });
        return wSLDistribution2 == null ? null : WSLCidrUtil.j(wSLDistribution2);
    }

    @Nullable
    public static WSLDistribution getDistributionByMsId(@NotNull String name) {
        if (name == null) {
            WSLCidrUtil.j(5);
        }
        if (name.isEmpty()) {
            return null;
        }
        return (WSLDistribution)ContainerUtil.find(WSLCidrUtil.getAvailableDistributions(), wSLDistribution -> name.equals(wSLDistribution.getMsId()));
    }

    public static boolean delete(@NotNull Path path) {
        if (path == null) {
            WSLCidrUtil.j(6);
        }
        return path.toFile().delete();
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 4, 5, 6 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDistributions";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "patchDistribution";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDistributionByExecutionPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDistributionByMsId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static class WSLDistributionWithRootInternal
    extends WSLDistribution {
        private static final NotNullLazyValue<Map<String, String>> DISTRIBUTION_TO_ROOTFS = NotNullLazyValue.atomicLazy(() -> {
            HashMap<String, CallSite> hashMap = new HashMap<String, CallSite>();
            String string = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss";
            List list = WindowsRegistryUtil.readRegistryBranch((String)"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss");
            WSLUtil.LOG.debug("Processing Lxss registry: " + list.size());
            for (String string2 : list) {
                String string3 = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + string2), (String)"DistributionName");
                String string4 = WindowsRegistryUtil.readRegistryValue((String)("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Lxss\\" + string2), (String)"BasePath");
                WSLUtil.LOG.debug(string3 + ": " + string4);
                if (string4 == null) continue;
                hashMap.put(string3, (CallSite)((Object)(string4 + "\\rootfs")));
            }
            return Collections.unmodifiableMap(hashMap);
        });
        @Nullable
        protected final String myWslRootInHost;

        private WSLDistributionWithRootInternal(@NotNull WSLDistribution wslDistribution) {
            Path path;
            boolean bl;
            if (wslDistribution == null) {
                WSLDistributionWithRootInternal.j(0);
            }
            super(wslDistribution);
            String string = (String)((Map)DISTRIBUTION_TO_ROOTFS.getValue()).get(wslDistribution.getMsId());
            boolean bl2 = string != null && new File(string).isDirectory();
            boolean bl3 = bl = Experiments.getInstance().isFeatureEnabled("wsl.prefer.p9.support") || !bl2;
            if (Experiments.getInstance().isFeatureEnabled("wsl.p9.support") && bl && Files.exists(path = this.getUNCRootPath(), new LinkOption[0])) {
                string = StringUtil.trimEnd((String)path.toString(), (String)"\\");
            }
            if (!FileUtil.exists((String)string)) {
                WSLUtil.LOG.warn("WSL rootfs doesn't exist: " + string);
                string = null;
            }
            this.myWslRootInHost = string;
        }

        @Nullable
        public String getWslPath(@NotNull Path windowsPath) {
            if (windowsPath == null) {
                WSLDistributionWithRootInternal.j(1);
            }
            String string = FileUtil.toCanonicalPath((String)windowsPath.toString());
            if (this.myWslRootInHost != null && FileUtil.isAncestor((String)this.myWslRootInHost, (String)string, (boolean)true)) {
                return FileUtil.toSystemIndependentName((String)string.substring(this.myWslRootInHost.length()));
            }
            return super.getWslPath(Path.of(string, new String[0]));
        }

        @NotNull
        public String getWindowsPath(@NotNull String wslPath) {
            String string;
            if (wslPath == null) {
                WSLDistributionWithRootInternal.j(2);
            }
            if ((string = WSLUtil.getWindowsPath((String)wslPath, (String)this.getMntRoot())) != null) {
                String string2 = string;
                if (string2 == null) {
                    WSLDistributionWithRootInternal.j(3);
                }
                return string2;
            }
            if (this.myWslRootInHost != null) {
                String string3 = FileUtil.toSystemDependentName((String)(this.myWslRootInHost + FileUtil.toCanonicalPath((String)wslPath)));
                if (string3 == null) {
                    WSLDistributionWithRootInternal.j(4);
                }
                return string3;
            }
            String string4 = super.getWindowsPath(wslPath);
            if (string4 == null) {
                WSLDistributionWithRootInternal.j(5);
            }
            return string4;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wslDistribution";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windowsPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wslPath";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil$WSLDistributionWithRootInternal";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/WSLCidrUtil$WSLDistributionWithRootInternal";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindowsPath";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getWslPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getWindowsPath";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

