/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.system.RemoteUnixPipe;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.toolchains.PathSeparator;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLDistribution;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrWSLHost
implements HostMachine {
    @NotNull
    protected final CidrWSLDistribution myWSL;

    public CidrWSLHost(@NotNull CidrWSLDistribution wsl) {
        if (wsl == null) {
            CidrWSLHost.N(0);
        }
        this.myWSL = wsl;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public boolean isWsl() {
        return true;
    }

    @Override
    public boolean hasRemoteFS() {
        return false;
    }

    @Override
    @NotNull
    public OSType getOSType() {
        OSType oSType = OSType.LINUX;
        if (oSType == null) {
            CidrWSLHost.N(1);
        }
        return oSType;
    }

    @Override
    @NotNull
    public String getName() {
        String string = "WSL (" + this.myWSL.getWslDistributionName() + ")";
        if (string == null) {
            CidrWSLHost.N(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHostId() {
        String string = this.myWSL.getWslDistributionName();
        if (string == null) {
            CidrWSLHost.N(3);
        }
        return string;
    }

    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        if (remotePath == null) {
            CidrWSLHost.N(4);
        }
        String string = this.myWSL.toLocalPath(null, remotePath);
        if (string == null) {
            CidrWSLHost.N(5);
        }
        return string;
    }

    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        if (localPath == null) {
            CidrWSLHost.N(6);
        }
        String string = this.myWSL.toEnvPath(localPath);
        if (string == null) {
            CidrWSLHost.N(7);
        }
        return string;
    }

    @Override
    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException {
        return new RemoteUnixPipe(this);
    }

    @Override
    @NotNull
    public CidrProcessBuilder createProcessBuilder() {
        final WSLDistribution wSLDistribution = this.myWSL.getWslDistribution();
        return new CidrProcessBuilder(){

            @Override
            @NotNull
            protected BaseProcessHandler<?> build(@NotNull GeneralCommandLine cl, @NotNull CidrProcessBuilder.Parameters params2) throws ExecutionException {
                if (cl == null) {
                    1.j(0);
                }
                if (params2 == null) {
                    1.j(1);
                }
                if (wSLDistribution == null) {
                    throw new ExecutionException(CidrUtilsExecutionBundle.message("wsl.toolchain.not.found", CidrWSLHost.this.myWSL.getWslDistributionName()));
                }
                cl = CidrWSLHost.this.j(wSLDistribution, cl, params2.isElevated());
                Object object = params2.isEmulateTerminal() ? new LocalHost.TerminalEmulatorOSProcessHandler(cl) : (params2.isColored() ? new LocalHost.ParameterizedColoredProcessHandler(cl, params2) : (params2.isCapturedOutput() ? new LocalHost.ParameterizedCapturingProcessHandler(cl, params2) : new LocalHost.ParameterizedOSProcessHandler(cl, params2)));
                CidrRunProcessUtil.setHasPty(object, params2.isPty());
                Object object2 = object;
                if (object2 == null) {
                    1.j(2);
                }
                return object2;
            }

            private static /* synthetic */ void j(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n2) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cl";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "params";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLHost$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLHost$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "build";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "build";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n2) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Override
    public void destroyProcess(@NotNull BaseProcessHandler<?> handler) {
        if (handler == null) {
            CidrWSLHost.N(8);
        }
        handler.destroyProcess();
    }

    @NotNull
    private GeneralCommandLine j(@NotNull WSLDistribution wSLDistribution, @NotNull GeneralCommandLine generalCommandLine, boolean bl) throws ExecutionException {
        if (wSLDistribution == null) {
            CidrWSLHost.N(9);
        }
        if (generalCommandLine == null) {
            CidrWSLHost.N(10);
        }
        if (generalCommandLine instanceof PtyCommandLine) {
            ((PtyCommandLine)generalCommandLine).withInitialColumns(2500);
        }
        String string = generalCommandLine.getExePath();
        generalCommandLine.setExePath(this.convertToRemote(string));
        File file2 = generalCommandLine.getWorkDirectory();
        String string2 = file2 == null ? null : this.convertToRemote(file2.getPath());
        WSLCommandLineOptions wSLCommandLineOptions = new WSLCommandLineOptions().setSudo(bl).setRemoteWorkingDirectory(string2).setExecuteCommandInLoginShell(AdvancedSettings.getBoolean((String)"wsl.toolchain.execute.login.shell")).setSleepTimeoutSec(Registry.doubleValue((String)"clion.wsl.sleep.timeout")).setPassEnvVarsUsingInterop(false);
        String string3 = generalCommandLine.getEnvironment().getOrDefault("PATH", null);
        if (string3 != null && generalCommandLine.isPassParentEnvironment()) {
            wSLCommandLineOptions.addInitCommand("export PATH=\"" + string3 + PathSeparator.UNIX + "$PATH\"");
            generalCommandLine.getEnvironment().remove("PATH");
        }
        GeneralCommandLine generalCommandLine2 = wSLDistribution.patchCommandLine(generalCommandLine, null, wSLCommandLineOptions);
        if (generalCommandLine2 == null) {
            CidrWSLHost.N(11);
        }
        return generalCommandLine2;
    }

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException {
        throw new UnsupportedOperationException("CidrWSLHost is not capable of listing processes");
    }

    public void killProcessTree(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            CidrWSLHost.N(12);
        }
        OSProcessUtil.killProcessTree((Process)handler.getProcess());
    }

    @Override
    public int sendSignal(int pid, @NotNull String signalName) {
        if (signalName == null) {
            CidrWSLHost.N(13);
        }
        return CidrToolsUtil.sendUnixSignal(this, pid, signalName);
    }

    @Override
    @NotNull
    public Path getTempDirectory() {
        Path path = Paths.get(FileUtil.getTempDirectory(), new String[0]);
        if (path == null) {
            CidrWSLHost.N(14);
        }
        return path;
    }

    @Override
    @NotNull
    public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            CidrWSLHost.N(15);
        }
        Path path = FileUtil.createTempDirectory((String)prefix, (String)suffix).toPath();
        if (path == null) {
            CidrWSLHost.N(16);
        }
        return path;
    }

    @Override
    @NotNull
    public Path getPath(String first, String ... more) {
        String[] stringArray = new String[more.length];
        for (int i2 = 0; i2 < more.length; ++i2) {
            stringArray[i2] = this.convertToLocal(more[i2]);
        }
        Path path = Paths.get(this.convertToLocal(first), stringArray);
        if (path == null) {
            CidrWSLHost.N(17);
        }
        return path;
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull Path remoteFile) {
        if (remoteFile == null) {
            CidrWSLHost.N(18);
        }
        return new File(this.convertToLocal(remoteFile.toString()));
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull File localFile) {
        if (localFile == null) {
            CidrWSLHost.N(19);
        }
        File file2 = localFile;
        if (file2 == null) {
            CidrWSLHost.N(20);
        }
        return file2;
    }

    @Override
    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> paths2) {
        if (paths2 == null) {
            CidrWSLHost.N(21);
        }
        List list = ContainerUtil.map(paths2, string -> this.convertToLocal((String)string));
        if (list == null) {
            CidrWSLHost.N(22);
        }
        return list;
    }

    @Override
    @NotNull
    public @NotNull String @NotNull [] toCanonicalPath(@NotNull List<@NonNls String> paths2, boolean resolveSymlink) {
        if (paths2 == null) {
            CidrWSLHost.N(23);
        }
        String[] stringArray = (String[])ContainerUtil.map2Array(paths2, String.class, string -> this.j((String)string, resolveSymlink));
        if (stringArray == null) {
            CidrWSLHost.N(24);
        }
        return stringArray;
    }

    @NotNull
    private String j(@NotNull String string, boolean bl) {
        String string2;
        if (string == null) {
            CidrWSLHost.N(25);
        }
        if (!(string2 = this.myWSL.toEnvPath(string)).startsWith("/mnt/") && bl) {
            String string3 = this.myWSL.resolveSymlink(string2);
            String string4 = this.myWSL.toLocalPath(null, string3);
            if (string4 == null) {
                CidrWSLHost.N(26);
            }
            return string4;
        }
        String string5 = FileUtil.toCanonicalPath((String)string, (boolean)bl);
        if (string5 == null) {
            CidrWSLHost.N(27);
        }
        return string5;
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 2, 3, 5, 7, 11, 14, 16, 17, 20, 22, 24, 26, 27 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLHost";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dist";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToLocal";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRemote";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommandLine";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndCache";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPathInternal";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToLocal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToRemote";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcess";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sendSignal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndCache";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPathInternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 7, 11, 14, 16, 17, 20, 22, 24, 26, 27 -> new IllegalStateException(string);
        };
    }
}

