/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.cidr.toolchains.wsl.WSLCidrUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CidrWSLDistribution {
    public static final Logger LOG = Logger.getInstance(CidrWSLDistribution.class);
    @NotNull
    private final @NotNull SLRUMap<@NotNull String, @NotNull String> mySymlinkCache;
    private final String myWslDistributionName;
    private final NullableLazyValue<@Nullable WSLDistribution> myWslDistribution;
    private static final int RESOLVE_SYMLINK_TIMEOUT = 5000;

    public CidrWSLDistribution(@NotNull String name) {
        if (name == null) {
            CidrWSLDistribution.j(0);
        }
        this.mySymlinkCache = new SLRUMap(10000, 10000);
        this.myWslDistributionName = name;
        this.myWslDistribution = NullableLazyValue.atomicLazyNullable(() -> CidrWSLDistribution.j(name));
    }

    @NotNull
    public String getWslDistributionName() {
        String string = this.myWslDistributionName;
        if (string == null) {
            CidrWSLDistribution.j(1);
        }
        return string;
    }

    @Nullable
    public WSLDistribution getWslDistribution() {
        return (WSLDistribution)this.myWslDistribution.getValue();
    }

    @Nullable
    public WSLDistribution getWslDistributionFast() {
        if (!this.myWslDistribution.isComputed()) {
            return null;
        }
        return (WSLDistribution)this.myWslDistribution.getValue();
    }

    public static List<String> getDistributions() {
        return ContainerUtil.map(WSLCidrUtil.getAvailableDistributions(), wSLDistribution -> wSLDistribution.getMsId());
    }

    private static boolean j(String string) {
        return OSAgnosticPathUtil.isAbsolute((String)string) && !OSAgnosticPathUtil.isAbsoluteDosPath((String)string) && !OSAgnosticPathUtil.isUncPath((String)string);
    }

    @Contract(value="_,null -> null; _,!null -> !null")
    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            return null;
        }
        Object object = absoluteOrRelativeEnvPath;
        if (!CidrWSLDistribution.j(absoluteOrRelativeEnvPath) && localBaseDir != null) {
            object = localBaseDir.getPath() + "/" + absoluteOrRelativeEnvPath;
        }
        String string = FileUtil.toCanonicalPath((String)object);
        WSLDistribution wSLDistribution = this.getWslDistributionFast();
        if (CidrWSLDistribution.j(string)) {
            if (wSLDistribution != null) {
                return wSLDistribution.getWindowsPath(string);
            }
            if (!this.myWslDistributionName.contains("/")) {
                wSLDistribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(this.myWslDistributionName);
                return wSLDistribution.getWindowsPath(string, () -> "/mnt/");
            }
        }
        return FileUtil.toSystemDependentName((String)string);
    }

    @Contract(value="null -> null; !null -> !null")
    public String toEnvPath(@Nullable String localPath) {
        if (localPath == null) {
            return null;
        }
        WSLDistribution wSLDistribution = this.getWslDistribution();
        String string = wSLDistribution != null ? wSLDistribution.getWslPath(localPath) : null;
        return FileUtil.toSystemIndependentName((String)(string != null ? string : localPath));
    }

    @NotNull
    public String resolveSymlink(@NotNull String path) {
        WSLDistribution wSLDistribution;
        if (path == null) {
            CidrWSLDistribution.j(2);
        }
        if ((wSLDistribution = this.getWslDistribution()) == null) {
            String string = path;
            if (string == null) {
                CidrWSLDistribution.j(3);
            }
            return string;
        }
        return CidrWSLDistribution.j(path, wSLDistribution, this.mySymlinkCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static String j(@NotNull String string, @NotNull WSLDistribution wSLDistribution, @NotNull @NotNull SLRUMap<@NotNull String, @NotNull String> sLRUMap) {
        SLRUMap<String, String> sLRUMap2;
        if (string == null) {
            CidrWSLDistribution.j(4);
        }
        if (wSLDistribution == null) {
            CidrWSLDistribution.j(5);
        }
        if (sLRUMap == null) {
            CidrWSLDistribution.j(6);
        }
        SLRUMap<String, String> sLRUMap3 = sLRUMap;
        synchronized (sLRUMap3) {
            sLRUMap2 = (SLRUMap<String, String>)sLRUMap.get((Object)string);
            if (sLRUMap2 != null) {
                SLRUMap<String, String> sLRUMap4 = sLRUMap2;
                // MONITOREXIT @DISABLED, blocks:[3, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                if (sLRUMap4 == null) {
                    CidrWSLDistribution.j(7);
                }
                return sLRUMap4;
            }
        }
        String string2 = wSLDistribution.resolveSymlink(string, 5000);
        sLRUMap2 = sLRUMap;
        synchronized (sLRUMap2) {
            sLRUMap.put((Object)string, (Object)string2);
        }
        String string3 = string2;
        if (string3 == null) {
            CidrWSLDistribution.j(8);
        }
        return string3;
    }

    public boolean isAbsolutePath(@NotNull String wslOrWindowsPath) {
        if (wslOrWindowsPath == null) {
            CidrWSLDistribution.j(9);
        }
        return OSAgnosticPathUtil.isAbsolute((String)wslOrWindowsPath);
    }

    @Nullable
    private static WSLDistribution j(@NotNull String string) {
        WSLDistribution wSLDistribution;
        if (string == null) {
            CidrWSLDistribution.j(10);
        }
        if ((wSLDistribution = WSLCidrUtil.getDistributionByMsId(string)) == null) {
            wSLDistribution = WSLCidrUtil.getDistributionByExecutionPath(string);
        }
        return wSLDistribution;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 3, 7, 8 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLDistribution";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslOrWindowsPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/wsl/CidrWSLDistribution";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslDistributionName";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDistribution";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7, 8 -> new IllegalStateException(string);
        };
    }
}

