/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrToolsUtil {
    public static final int DEFAULT_COMMAND_TIMEOUT = StringUtil.parseInt((String)System.getProperty("cidr.remote.command.timeout"), (int)5000);
    private static final Logger LOG = Logger.getInstance(CidrToolsUtil.class);

    public static int sendUnixSignal(@NotNull HostMachine host, int pid, @NotNull String signalName) {
        if (host == null) {
            CidrToolsUtil.j(0);
        }
        if (signalName == null) {
            CidrToolsUtil.j(1);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"kill", "-s", signalName, Integer.toString(pid)});
        try {
            return host.runProcess(generalCommandLine, DEFAULT_COMMAND_TIMEOUT).getExitCode();
        }
        catch (ExecutionException executionException) {
            LOG.warn("Cannot send signal to remote process (pid = " + pid + ", signal = " + signalName + ")", (Throwable)executionException);
            return -1;
        }
    }

    @NotNull
    public static String generateTempFileName(@NotNull HostMachine host) throws ExecutionException {
        if (host == null) {
            CidrToolsUtil.j(2);
        }
        return CidrToolsUtil.j((GeneralCommandLine generalCommandLine) -> host.runProcess(generalCommandLine, DEFAULT_COMMAND_TIMEOUT), host.getOSType());
    }

    @NotNull
    private static String j(@NotNull CommandRunner commandRunner, @NotNull OSType oSType) throws ExecutionException {
        GeneralCommandLine generalCommandLine;
        ProcessOutput processOutput;
        if (commandRunner == null) {
            CidrToolsUtil.j(3);
        }
        if (oSType == null) {
            CidrToolsUtil.j(4);
        }
        CidrToolsUtil.assertUnixOnly(oSType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("RemoteUtil: get temporary file name");
        }
        if (!(processOutput = commandRunner.run(generalCommandLine = new GeneralCommandLine(new String[]{"mktemp", "-u"}))).checkSuccess(LOG)) {
            throw new ExecutionException(CidrUtilsExecutionBundle.message("remote.exception.cannot.generate.temp.path.ext", processOutput.getExitCode()));
        }
        String string = StringUtil.nullize((String)processOutput.getStdout().trim());
        if (string == null) {
            throw new ExecutionException(CidrUtilsExecutionBundle.message("remote.exception.cannot.generate.temp.path", new Object[0]));
        }
        String string2 = string;
        if (string2 == null) {
            CidrToolsUtil.j(5);
        }
        return string2;
    }

    public static void assertUnixOnly(@NotNull OSType osType) throws ExecutionException {
        if (osType == null) {
            CidrToolsUtil.j(6);
        }
        if (osType == OSType.WIN) {
            throw new ExecutionException((Throwable)new UnsupportedOperationException(osType.name()));
        }
    }

    public static boolean checkSuccess(@NotNull GeneralCommandLine cl, @NotNull ProcessOutput output, @NotNull Logger logger) {
        if (cl == null) {
            CidrToolsUtil.j(7);
        }
        if (output == null) {
            CidrToolsUtil.j(8);
        }
        if (logger == null) {
            CidrToolsUtil.j(9);
        }
        if (output.getExitCode() == 0 && !output.isTimeout()) {
            return true;
        }
        logger.info(CidrToolsUtil.logInfo(cl, output));
        return false;
    }

    @NotNull
    public static String logInfo(@NotNull GeneralCommandLine cl, @NotNull ProcessOutput output) {
        if (cl == null) {
            CidrToolsUtil.j(10);
        }
        if (output == null) {
            CidrToolsUtil.j(11);
        }
        String string = "[" + cl.getCommandLineString() + "]: " + CidrToolsUtil.extractError(output);
        if (string == null) {
            CidrToolsUtil.j(12);
        }
        return string;
    }

    @NotNull
    public static String extractError(@NotNull ProcessOutput output) {
        if (output == null) {
            CidrToolsUtil.j(13);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (output.isTimeout()) {
            stringBuilder.append("(timed out)");
        } else {
            stringBuilder.append("(exit code ").append(output.getExitCode()).append(") ");
            if (!output.getStderr().isEmpty()) {
                stringBuilder.append(output.getStderr());
            } else {
                stringBuilder.append(output.getStdout());
            }
        }
        String string = stringBuilder.toString();
        if (string == null) {
            CidrToolsUtil.j(14);
        }
        return string;
    }

    @Nullable
    public static File getXcodeSelect() {
        return CidrToolsUtil.getXcodeSelect(new CidrToolEnvironment(), null);
    }

    @Nullable
    public static File getXcodeSelect(@NotNull CidrToolEnvironment environment, @Nullable ProgressIndicator indicator2) {
        if (environment == null) {
            CidrToolsUtil.j(15);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath("xcode-select");
        generalCommandLine.addParameter("-print-path");
        generalCommandLine.setCharset(CharsetToolkit.getDefaultSystemCharset());
        try {
            ProcessOutput processOutput = environment.getHostMachine().runProcess(generalCommandLine, indicator2, 1000);
            if (processOutput.isTimeout()) {
                throw new ExecutionException("xcode-select timed out");
            }
            String string = processOutput.getStderr().trim();
            if (!StringUtil.isEmpty((String)string)) {
                throw new ExecutionException(string);
            }
            String string2 = processOutput.getStdout().trim();
            if (StringUtil.isEmptyOrSpaces((String)string2)) {
                throw new ExecutionException("xcode-select returned an empty path");
            }
            return new File(string2);
        }
        catch (ExecutionException executionException) {
            LOG.info("Cannot determine default Xcode version: " + executionException.getMessage());
            return null;
        }
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 5, 12, 14 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 5: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/CidrToolsUtil";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/CidrToolsUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempFileName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "logInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractError";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sendUnixSignal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateTempFileName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTempFileName";
                break;
            }
            case 5: 
            case 12: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertUnixOnly";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkSuccess";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractError";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getXcodeSelect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 5, 12, 14 -> new IllegalStateException(string);
        };
    }

    public static interface CommandRunner {
        @NotNull
        public ProcessOutput run(@NotNull GeneralCommandLine var1) throws ExecutionException;
    }

    public static class Status {
        @NotNull
        public final StatusCode code;
        @NotNull
        @Nls
        public final String message;

        public Status(@NotNull StatusCode code, @NotNull @Nls String message2) {
            if (code == null) {
                Status.j(0);
            }
            if (message2 == null) {
                Status.j(1);
            }
            this.code = code;
            this.message = message2;
        }

        public static Status error(@NotNull @Nls String message2) {
            if (message2 == null) {
                Status.j(2);
            }
            return new Status(StatusCode.ERROR, message2);
        }

        public static Status of(@NotNull Pair<Boolean, @Nls String> status) {
            if (status == null) {
                Status.j(3);
            }
            return new Status((Boolean)status.first != false ? StatusCode.OK : StatusCode.ERROR, (String)status.second);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Status status = (Status)o2;
            return this.code == status.code && this.message.equals(status.message);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.code, this.message});
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/toolchains/CidrToolsUtil$Status";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "of";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class StatusCode
    extends Enum<StatusCode> {
        public static final /* enum */ StatusCode OK = new StatusCode();
        public static final /* enum */ StatusCode WARNING = new StatusCode();
        public static final /* enum */ StatusCode ERROR = new StatusCode();
        private static final /* synthetic */ StatusCode[] $VALUES;

        public static StatusCode[] values() {
            return (StatusCode[])$VALUES.clone();
        }

        public static StatusCode valueOf(String name) {
            return Enum.valueOf(StatusCode.class, name);
        }

        private static /* synthetic */ StatusCode[] j() {
            return new StatusCode[]{OK, WARNING, ERROR};
        }

        static {
            $VALUES = StatusCode.j();
        }
    }
}

