/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLHost;
import com.jetbrains.cidr.toolchains.wsl.WSLCidrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteUnixPipe
implements NamedPipe {
    private static final Logger LOG = Logger.getInstance(RemoteUnixPipe.class);
    @NotNull
    final HostMachine myHost;
    @NotNull
    final String myName;
    @Nullable
    Process myInputProcess;
    @Nullable
    Process myOutputProcess;

    public RemoteUnixPipe(@NotNull HostMachine host) throws ExecutionException {
        if (host == null) {
            RemoteUnixPipe.j(0);
        }
        this(host, CidrToolsUtil.generateTempFileName(host));
    }

    public RemoteUnixPipe(@NotNull HostMachine host, @NotNull String name) throws ExecutionException {
        if (host == null) {
            RemoteUnixPipe.j(1);
        }
        if (name == null) {
            RemoteUnixPipe.j(2);
        }
        CidrToolsUtil.assertUnixOnly(host.getOSType());
        this.myHost = host;
        this.myName = name;
        RemoteUnixPipe.N(host, name);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RemoteUnixPipe.j(3);
        }
        return string;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() throws IOException {
        this.myInputProcess = this.j(new GeneralCommandLine(new String[]{"tee", this.myName}));
        return new BufferedOutputStream(this.myInputProcess.getOutputStream()){

            @Override
            public void close() throws IOException {
                try {
                    RemoteUnixPipe.this.close();
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        this.myOutputProcess = this.j(new GeneralCommandLine(new String[]{"cat", this.myName}));
        return new BufferedInputStream(this.myOutputProcess.getInputStream()){

            @Override
            public void close() throws IOException {
                try {
                    RemoteUnixPipe.this.close();
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void close() {
        if (this.myInputProcess != null) {
            this.myInputProcess.destroy();
        }
        if (this.myOutputProcess != null) {
            this.myOutputProcess.destroy();
        }
        RemoteUnixPipe.j(this.myHost, this.myName);
    }

    private Process j(@NotNull GeneralCommandLine generalCommandLine) throws IOException {
        if (generalCommandLine == null) {
            RemoteUnixPipe.j(4);
        }
        try {
            BaseProcessHandler<?> baseProcessHandler = this.myHost.createProcessBuilder().withCapturedOutput(false).build(generalCommandLine);
            baseProcessHandler.startNotify();
            return baseProcessHandler.getProcess();
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
    }

    private static void j(@NotNull HostMachine hostMachine, @NotNull String string) {
        if (hostMachine == null) {
            RemoteUnixPipe.j(5);
        }
        if (string == null) {
            RemoteUnixPipe.j(6);
        }
        try {
            Path path = hostMachine.getPath(string, new String[0]);
            if (hostMachine instanceof CidrWSLHost) {
                if (!WSLCidrUtil.delete(path)) {
                    LOG.warn("cannot remove file: " + string);
                }
            } else {
                Files.delete(path);
            }
        }
        catch (IOException iOException) {
            LOG.warn("cannot remove file: " + string, (Throwable)iOException);
        }
    }

    private static void N(@NotNull HostMachine hostMachine, @NotNull String string) throws ExecutionException {
        if (hostMachine == null) {
            RemoteUnixPipe.j(7);
        }
        if (string == null) {
            RemoteUnixPipe.j(8);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"mkfifo", string});
        ProcessOutput processOutput = hostMachine.runProcess(generalCommandLine, null, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT);
        if (LOG.isDebugEnabled()) {
            LOG.debug(CidrToolsUtil.logInfo(generalCommandLine, processOutput));
        }
        CidrToolsUtil.checkSuccess(generalCommandLine, processOutput, LOG);
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteUnixPipe";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteUnixPipe";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rmSilently";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNamedPipe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

