/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class RemoteHostUtil {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.remote");

    public static String remoteShell() {
        return AdvancedSettings.getString((String)"clion.remote.shell");
    }

    @NotNull
    public static String resolveSymlink(@NotNull HostMachine host, @NotNull String path) {
        block6: {
            String string;
            if (host == null) {
                RemoteHostUtil.j(0);
            }
            if (path == null) {
                RemoteHostUtil.j(1);
            }
            try {
                RemoteHostUtil.j(host);
                LOG.debug("Resolve symlink: " + path);
                GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"readlink", "-f", path});
                ProcessOutput processOutput = host.runProcess(generalCommandLine, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT);
                if (!CidrToolsUtil.checkSuccess(generalCommandLine, processOutput, LOG)) break block6;
                String string2 = processOutput.getStdout().trim();
                if (processOutput.getExitCode() != 0 || !StringUtil.isNotEmpty((String)string2)) break block6;
                string = string2;
            }
            catch (ExecutionException executionException) {
                LOG.debug("Error while resolving symlink: " + path, (Throwable)executionException);
            }
            if (string == null) {
                RemoteHostUtil.j(2);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            RemoteHostUtil.j(3);
        }
        return string;
    }

    @NotNull
    public static @NotNull String @NotNull [] resolveSymlink(@NotNull HostMachine host, @NotNull Collection<String> paths2) {
        String[] stringArray;
        if (host == null) {
            RemoteHostUtil.j(4);
        }
        if (paths2 == null) {
            RemoteHostUtil.j(5);
        }
        try {
            RemoteHostUtil.j(host);
            ArrayList arrayList = new ArrayList();
            Iterables.partition(paths2, (int)Registry.intValue((String)"clion.resolve.symlink.batch.size")).forEach(list -> RemoteHostUtil.j(host, list, arrayList));
            stringArray = (String[])arrayList.toArray(String[]::new);
        }
        catch (ExecutionException executionException) {
            LOG.debug("Error while resolving paths: " + paths2, (Throwable)executionException);
            String[] stringArray2 = ArrayUtil.toStringArray(paths2);
            if (stringArray2 == null) {
                RemoteHostUtil.j(7);
            }
            return stringArray2;
        }
        if (stringArray == null) {
            RemoteHostUtil.j(6);
        }
        return stringArray;
    }

    private static void j(@NotNull HostMachine hostMachine, @NotNull Collection<String> collection, ArrayList<String> arrayList) {
        ProcessOutput processOutput;
        if (hostMachine == null) {
            RemoteHostUtil.j(8);
        }
        if (collection == null) {
            RemoteHostUtil.j(9);
        }
        LOG.debug("Resolve symlink: " + collection);
        if (collection.isEmpty()) {
            return;
        }
        ProgressManager.checkCanceled();
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{RemoteHostUtil.remoteShell(), "-c"});
        generalCommandLine.addParameter(StringUtil.join(collection, string -> "readlink -fv " + CommandLineUtil.posixQuote((String)string) + " 2>&1", (String)";"));
        try {
            processOutput = hostMachine.runProcess(generalCommandLine, CidrToolsUtil.DEFAULT_COMMAND_TIMEOUT);
        }
        catch (ExecutionException executionException) {
            arrayList.addAll(collection);
            return;
        }
        String string3 = processOutput.getStdout().trim();
        String[] stringArray = StringUtil.splitByLines((String)string3);
        if (stringArray.length == collection.size()) {
            arrayList.addAll(Streams.zip(collection.stream(), Arrays.stream(stringArray), (string, string2) -> {
                if (!OSAgnosticPathUtil.isAbsolute((String)string2)) {
                    LOG.warn("path is not resolved: " + string);
                    return string;
                }
                return string2;
            }).toList());
        } else {
            LOG.warn("readlink output has unexpected number of lines, request command '" + generalCommandLine.getCommandLineString() + "', output: " + string3);
            arrayList.addAll(collection);
        }
    }

    private static void j(@NotNull HostMachine hostMachine) throws ExecutionException {
        if (hostMachine == null) {
            RemoteHostUtil.j(10);
        }
        if (!hostMachine.isRemote() || hostMachine.getOSType() == OSType.WIN) {
            throw new ExecutionException((Throwable)new UnsupportedOperationException(hostMachine.getName()));
        }
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 3, 6, 7 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteHostUtil";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteHostUtil";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "assertRemoteUnixOnly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

