/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinRunnerMediator;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.HostUtilKt;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHost
implements HostMachine {
    public static final LocalHost INSTANCE = new LocalHost();
    private static final Logger LOG = Logger.getInstance(LocalHost.class);
    private static final int SUDO_KILL_DELAY_MILLIS = 1000;

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public boolean hasRemoteFS() {
        return false;
    }

    @Override
    @NotNull
    public OSType getOSType() {
        OSType oSType = OSType.getCurrent();
        if (oSType == null) {
            LocalHost.N(0);
        }
        return oSType;
    }

    @Override
    @NotNull
    public CidrProcessBuilder createProcessBuilder() {
        return new CidrProcessBuilder(){

            @Override
            @NotNull
            protected BaseProcessHandler<?> build(@NotNull GeneralCommandLine cl, @NotNull CidrProcessBuilder.Parameters params2) throws ExecutionException {
                if (cl == null) {
                    1.j(0);
                }
                if (params2 == null) {
                    1.j(1);
                }
                if (params2.getUseExternalConsole() && SystemInfo.isWindows) {
                    WinRunnerMediator.withExternalConsole((GeneralCommandLine)cl);
                }
                Object object = params2.isElevated() ? (Registry.is((String)"cidr.elevation.daemon.enabled", (boolean)true) ? ElevationService.getInstance().createProcessHandler(cl) : LocalHost.j(cl)) : (params2.isEmulateTerminal() ? new TerminalEmulatorOSProcessHandler(cl) : (params2.isColored() ? new ParameterizedColoredProcessHandler(cl, params2) : (params2.isCapturedOutput() ? new ParameterizedCapturingProcessHandler(cl, params2) : new ParameterizedOSProcessHandler(cl, params2))));
                CidrRunProcessUtil.setHasPty(object, params2.isPty());
                Object object2 = object;
                if (object2 == null) {
                    1.j(2);
                }
                return object2;
            }

            private static /* synthetic */ void j(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n2) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cl";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "params";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/system/LocalHost$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/system/LocalHost$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "build";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "build";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n2) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static void j(@NotNull Process process) {
        if (process == null) {
            LocalHost.N(1);
        }
        if (process.isAlive()) {
            long l2 = process.pid();
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"kill", Long.toString(l2)});
            try {
                ExecUtil.sudo((GeneralCommandLine)generalCommandLine, (String)CidrUtilsExecutionBundle.message("sudo.prompt", new Object[0]));
            }
            catch (ExecutionException | IOException throwable) {
                LOG.error("Can't kill the process " + l2, throwable);
            }
        }
    }

    @NotNull
    private static OSProcessHandler j(GeneralCommandLine generalCommandLine) throws ExecutionException {
        try {
            generalCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)generalCommandLine, (String)CidrUtilsExecutionBundle.message("sudo.prompt", new Object[0]));
        }
        catch (IOException iOException) {
            throw new ExecutionException(CidrUtilsExecutionBundle.message("sudo.error", generalCommandLine), (Throwable)iOException);
        }
        Object object = SystemInfo.isWindows ? new OSProcessHandler(generalCommandLine) : new KillableProcessHandler(generalCommandLine){
            final Alarm sudoKillAlarm = new Alarm();

            private void N() {
                this.sudoKillAlarm.addRequest(() -> LocalHost.j(this.getProcess()), 1000, ModalityState.any());
            }

            protected void doDestroyProcess() {
                this.N();
                super.doDestroyProcess();
            }

            public void killProcess() {
                this.N();
                super.killProcess();
            }

            protected void onOSProcessTerminated(int exitCode) {
                this.sudoKillAlarm.cancelAllRequests();
                super.onOSProcessTerminated(exitCode);
            }
        };
        Object object2 = object;
        if (object2 == null) {
            LocalHost.N(2);
        }
        return object2;
    }

    public void destroyProcess(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            LocalHost.N(3);
        }
        handler.destroyProcess();
    }

    public void killProcessTree(@NotNull BaseProcessHandler handler) {
        if (handler == null) {
            LocalHost.N(4);
        }
        OSProcessUtil.killProcessTree((Process)handler.getProcess());
    }

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList() {
        List<ProcessInfo> list = Arrays.asList(OSProcessUtil.getProcessList());
        if (list == null) {
            LocalHost.N(5);
        }
        return list;
    }

    @Override
    public int sendSignal(int pid, @NotNull String signalName) {
        if (signalName == null) {
            LocalHost.N(6);
        }
        if (this.getOSType() == OSType.WIN) {
            throw new UnsupportedOperationException("Not supported for Windows OS, use winbreak instead");
        }
        return UnixProcessManager.sendSignal((int)pid, (String)signalName);
    }

    @Override
    @NotNull
    public Path getPath(String first, String ... more) {
        Path path = Paths.get(first, more);
        if (path == null) {
            LocalHost.N(7);
        }
        return path;
    }

    @Override
    @NotNull
    public @NotNull String @NotNull [] toCanonicalPath(@NotNull List<@NonNls String> paths2, boolean resolveSymlink) {
        if (paths2 == null) {
            LocalHost.N(8);
        }
        String[] stringArray = new String[paths2.size()];
        for (int i2 = 0; i2 < paths2.size(); ++i2) {
            stringArray[i2] = FileUtil.toCanonicalPath((String)paths2.get(i2), (boolean)resolveSymlink);
        }
        if (stringArray == null) {
            LocalHost.N(9);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public Path getTempDirectory() {
        Path path = Paths.get(FileUtil.getTempDirectory(), new String[0]);
        if (path == null) {
            LocalHost.N(10);
        }
        return path;
    }

    @Override
    @NotNull
    public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            LocalHost.N(11);
        }
        Path path = FileUtil.createTempDirectory((String)prefix, (String)suffix).toPath();
        if (path == null) {
            LocalHost.N(12);
        }
        return path;
    }

    @Override
    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull Path file2) {
        if (file2 == null) {
            LocalHost.N(13);
        }
        File file3 = file2.toFile();
        if (file3 == null) {
            LocalHost.N(14);
        }
        return file3;
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull File file2) {
        if (file2 == null) {
            LocalHost.N(15);
        }
        File file3 = file2;
        if (file3 == null) {
            LocalHost.N(16);
        }
        return file3;
    }

    @Override
    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> paths2) {
        if (paths2 == null) {
            LocalHost.N(17);
        }
        List<String> list = paths2;
        if (list == null) {
            LocalHost.N(18);
        }
        return list;
    }

    @Override
    @NotNull
    public String getHostId() {
        return "__localhost_machine__";
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 1, 3, 4, 6, 8, 11, 13, 15, 17 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/LocalHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/LocalHost";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createElevatedProcess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndCache";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runSudoKill";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcess";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sendSignal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndCache";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 6, 8, 11, 13, 15, 17 -> new IllegalArgumentException(string);
        };
    }

    @FunctionalInterface
    static interface EnvironmentProducer {
        public Map<String, String> getEnvironment() throws IOException;
    }

    public static class TerminalEmulatorOSProcessHandler
    extends OSProcessHandler {
        public TerminalEmulatorOSProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine) {
            if (process == null) {
                TerminalEmulatorOSProcessHandler.j(0);
            }
            if (commandLine == null) {
                TerminalEmulatorOSProcessHandler.j(1);
            }
            super(process, commandLine.getCommandLineString(), commandLine.getCharset());
        }

        public TerminalEmulatorOSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                TerminalEmulatorOSProcessHandler.j(2);
            }
            super(commandLine);
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = BaseOutputReader.Options.forTerminalPtyProcess();
            if (options == null) {
                TerminalEmulatorOSProcessHandler.j(3);
            }
            return options;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/LocalHost$TerminalEmulatorOSProcessHandler";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/LocalHost$TerminalEmulatorOSProcessHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class ParameterizedOSProcessHandler
    extends OSProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        public ParameterizedOSProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (commandLine == null) {
                ParameterizedOSProcessHandler.j(0);
            }
            if (parameters == null) {
                ParameterizedOSProcessHandler.j(1);
            }
            super(commandLine);
            this.myParameters = parameters;
        }

        public ParameterizedOSProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (process == null) {
                ParameterizedOSProcessHandler.j(2);
            }
            if (commandLine == null) {
                ParameterizedOSProcessHandler.j(3);
            }
            if (parameters == null) {
                ParameterizedOSProcessHandler.j(4);
            }
            super(process, commandLine.getCommandLineString(), commandLine.getCharset());
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions(this.myParameters, super.readerOptions());
            if (options == null) {
                ParameterizedOSProcessHandler.j(5);
            }
            return options;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/LocalHost$ParameterizedOSProcessHandler";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/LocalHost$ParameterizedOSProcessHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class ParameterizedCapturingProcessHandler
    extends CapturingProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        public ParameterizedCapturingProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (commandLine == null) {
                ParameterizedCapturingProcessHandler.j(0);
            }
            if (parameters == null) {
                ParameterizedCapturingProcessHandler.j(1);
            }
            super(commandLine);
            this.myParameters = parameters;
        }

        public ParameterizedCapturingProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (process == null) {
                ParameterizedCapturingProcessHandler.j(2);
            }
            if (commandLine == null) {
                ParameterizedCapturingProcessHandler.j(3);
            }
            if (parameters == null) {
                ParameterizedCapturingProcessHandler.j(4);
            }
            super(process, commandLine.getCharset(), commandLine.getCommandLineString());
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions(this.myParameters, super.readerOptions());
            if (options == null) {
                ParameterizedCapturingProcessHandler.j(5);
            }
            return options;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/LocalHost$ParameterizedCapturingProcessHandler";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/LocalHost$ParameterizedCapturingProcessHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class ParameterizedColoredProcessHandler
    extends ColoredProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        public ParameterizedColoredProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (commandLine == null) {
                ParameterizedColoredProcessHandler.j(0);
            }
            if (parameters == null) {
                ParameterizedColoredProcessHandler.j(1);
            }
            super(commandLine);
            this.myParameters = parameters;
        }

        public ParameterizedColoredProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws ExecutionException {
            if (process == null) {
                ParameterizedColoredProcessHandler.j(2);
            }
            if (commandLine == null) {
                ParameterizedColoredProcessHandler.j(3);
            }
            if (parameters == null) {
                ParameterizedColoredProcessHandler.j(4);
            }
            super(process, commandLine.getCommandLineString(), commandLine.getCharset());
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            BaseOutputReader.Options options = HostUtilKt.readerOptions(this.myParameters, super.readerOptions());
            if (options == null) {
                ParameterizedColoredProcessHandler.j(5);
            }
            return options;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/system/LocalHost$ParameterizedColoredProcessHandler";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/system/LocalHost$ParameterizedColoredProcessHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readerOptions";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

