/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HostMachine {
    public boolean isRemote();

    default public boolean isWsl() {
        return false;
    }

    public boolean hasRemoteFS();

    @NotNull
    public OSType getOSType();

    @NotNull
    default public ProcessOutput runProcess(@NotNull GeneralCommandLine cl, int timeout) throws ExecutionException {
        if (cl == null) {
            HostMachine.j(0);
        }
        ProcessOutput processOutput = this.runProcess(cl, null, timeout);
        if (processOutput == null) {
            HostMachine.j(1);
        }
        return processOutput;
    }

    @NotNull
    default public ProcessOutput runProcess(@NotNull GeneralCommandLine cl, @Nullable ProgressIndicator indicator2, int timeout) throws ExecutionException {
        if (cl == null) {
            HostMachine.j(2);
        }
        BaseProcessHandler<?> baseProcessHandler = this.createProcessBuilder().withCapturedOutput(true).withShortLived(true).withProgressIndicator(indicator2).build(cl);
        ProcessOutput processOutput = CidrRunProcessUtil.runProcess(baseProcessHandler, indicator2, timeout);
        if (processOutput == null) {
            HostMachine.j(3);
        }
        return processOutput;
    }

    @NotNull
    default public BaseProcessHandler<?> createProcess(@NotNull GeneralCommandLine cl, boolean colored, boolean usePty) throws ExecutionException {
        if (cl == null) {
            HostMachine.j(4);
        }
        BaseProcessHandler<?> baseProcessHandler = this.createProcess(cl, colored, usePty, true, false, false);
        if (baseProcessHandler == null) {
            HostMachine.j(5);
        }
        return baseProcessHandler;
    }

    @NotNull
    default public BaseProcessHandler<?> createProcess(@NotNull GeneralCommandLine cl, boolean colored, boolean usePty, boolean captureProcessOutput, boolean splitLines) throws ExecutionException {
        if (cl == null) {
            HostMachine.j(6);
        }
        BaseProcessHandler<?> baseProcessHandler = this.createProcess(cl, colored, usePty, captureProcessOutput, splitLines, false);
        if (baseProcessHandler == null) {
            HostMachine.j(7);
        }
        return baseProcessHandler;
    }

    @Deprecated
    @NotNull
    default public BaseProcessHandler<?> createProcess(@NotNull GeneralCommandLine cl, boolean colored, boolean usePty, boolean captureProcessOutput, boolean splitLines, boolean isElevated) throws ExecutionException {
        if (cl == null) {
            HostMachine.j(8);
        }
        BaseProcessHandler<?> baseProcessHandler = this.createProcessBuilder().withColoredOutput(colored).withPty(usePty).withCapturedOutput(captureProcessOutput).withSplitToLines(splitLines).withElevated(isElevated).build(cl);
        if (baseProcessHandler == null) {
            HostMachine.j(9);
        }
        return baseProcessHandler;
    }

    @NotNull
    public CidrProcessBuilder createProcessBuilder();

    public void destroyProcess(@NotNull BaseProcessHandler<?> var1);

    public void killProcessTree(@NotNull BaseProcessHandler<?> var1);

    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException;

    default public int sendSignal(int pid, @NotNull String signalName, @NotNull Process mainProcess) {
        if (signalName == null) {
            HostMachine.j(10);
        }
        if (mainProcess == null) {
            HostMachine.j(11);
        }
        return this.sendSignal(pid, signalName);
    }

    public int sendSignal(int var1, @NotNull String var2);

    @NotNull
    public Path getPath(@NotNull @NonNls String var1, String ... var2);

    @NotNull
    public @NotNull String @NotNull [] toCanonicalPath(@NotNull List<@NonNls String> var1, boolean var2);

    @Deprecated
    @NotNull
    default public String toCanonicalPath(@NotNull String path, boolean resolveSymlink) {
        String[] stringArray;
        if (path == null) {
            HostMachine.j(12);
        }
        if ((stringArray = this.toCanonicalPath(Collections.singletonList(path), resolveSymlink)).length != 1) {
            Logger.getInstance(HostMachine.class).error("cannot get canonical path: " + path);
            String string = path;
            if (string == null) {
                HostMachine.j(13);
            }
            return string;
        }
        String string = stringArray[0];
        if (string == null) {
            HostMachine.j(14);
        }
        return string;
    }

    @NotNull
    public Path getTempDirectory();

    @NotNull
    public Path createTempDirectory(@NotNull @NonNls String var1, @Nullable @NonNls String var2) throws IOException;

    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException;

    @NotNull
    public File resolvePath(@NotNull Path var1) throws IOException;

    @NotNull
    public File resolvePath(@NotNull File var1) throws IOException;

    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> var1);

    @NotNull
    @NonNls
    public String getHostId();

    default public void invalidateCache() {
    }

    @NotNull
    @NonNls
    default public String getName() {
        String string = (this.isRemote() ? "Remote " : "Local ") + this.getOSType();
        if (string == null) {
            HostMachine.j(15);
        }
        return string;
    }

    @NotNull
    default public List<Path> findFilesWithExtension(@NotNull Path rootPath, Boolean recursive, final String ... extensions) throws IOException, ExecutionException {
        if (rootPath == null) {
            HostMachine.j(16);
        }
        if (!Files.exists(rootPath, new LinkOption[0])) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                HostMachine.j(17);
            }
            return list;
        }
        if (recursive.booleanValue()) {
            final ArrayList<Path> arrayList = new ArrayList<Path>();
            Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(@Nullable Path file2, @Nullable BasicFileAttributes attrs) {
                    if (file2 != null && Files.isRegularFile(file2, new LinkOption[0]) && ContainerUtil.exists((Object[])extensions, string -> file2.toString().endsWith((String)string))) {
                        arrayList.add(file2);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            ArrayList<Path> arrayList2 = arrayList;
            if (arrayList2 == null) {
                HostMachine.j(18);
            }
            return arrayList2;
        }
        Stream<Path> stream = Files.list(rootPath);
        List<Path> list = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && ContainerUtil.exists((Object[])extensions, string -> path.toString().endsWith((String)string))).collect(Collectors.toList());
        List<Path> list2 = list;
        if (list2 == null) {
            HostMachine.j(19);
        }
        return list2;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @RequiresBackgroundThread
    default public void waitForFilesSync() {
        ThreadingAssertions.assertBackgroundThread();
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 3, 5, 7, 9, 13, 14, 15, 17, 18, 19 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/HostMachine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainProcess";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/HostMachine";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithExtension";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sendSignal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithExtension";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7, 9, 13, 14, 15, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

