/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.HostUtilKt;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrEnvironmentUtil {
    public static final int PATH_CACHE_SIZE = 10000;
    private static final Logger LOG = Logger.getInstance(CidrEnvironmentUtil.class);
    public static final String envCommand = "env";
    private static final String envNullFlag = "--null";
    private static final String sourcePosixCommand = ".";
    private static final String redirectOutput = "1> /dev/null ";
    private static final String fallbackShellAdvancedSetting = "cidr.util.fallback.shell";

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull String file2, @NotNull HostMachine host, @NotNull Map<String, String> parentEnvironment) throws IOException, ExecutionException {
        if (file2 == null) {
            CidrEnvironmentUtil.j(0);
        }
        if (host == null) {
            CidrEnvironmentUtil.j(1);
        }
        if (parentEnvironment == null) {
            CidrEnvironmentUtil.j(2);
        }
        return CidrEnvironmentUtil.readLinuxEnvironmentFromFile(file2, host, null, null, parentEnvironment);
    }

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull String file2, @NotNull HostMachine host, @Nullable String interpreterPath, @Nullable String envPath, @NotNull Map<String, String> parentEnvironment) throws IOException, ExecutionException {
        if (file2 == null) {
            CidrEnvironmentUtil.j(3);
        }
        if (host == null) {
            CidrEnvironmentUtil.j(4);
        }
        if (parentEnvironment == null) {
            CidrEnvironmentUtil.j(5);
        }
        String string = envPath == null ? envCommand : envPath;
        boolean bl = CidrEnvironmentUtil.j(host, string);
        if (interpreterPath == null && (interpreterPath = CidrEnvironmentUtil.j(host, string, bl)) == null) {
            LOG.warn("SHELL is not found in environment, falling back to advanced setting cidr.util.fallback.shell");
            interpreterPath = AdvancedSettings.getString((String)fallbackShellAdvancedSetting);
        }
        StringBuilder stringBuilder = new StringBuilder(envCommand);
        if (bl) {
            stringBuilder.append(" ").append(envNullFlag);
        }
        String string2 = ". " + CommandLineUtil.posixQuote((String)file2) + " 1> /dev/null && " + stringBuilder;
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{interpreterPath, "-l", "-c", stringBuilder.toString()});
        generalCommandLine.withEnvironment(parentEnvironment);
        GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(new String[]{interpreterPath, "-l", "-c", string2});
        generalCommandLine2.withEnvironment(parentEnvironment);
        Map<String, String> map = CidrEnvironmentUtil.j(generalCommandLine, host, bl);
        Map<String, String> map2 = CidrEnvironmentUtil.j(generalCommandLine2, host, bl);
        return CidrEnvironmentUtil.subtractEnvironments(map2, map);
    }

    @Nullable
    private static String j(@NotNull HostMachine hostMachine, String string, boolean bl) throws ExecutionException, IOException {
        if (hostMachine == null) {
            CidrEnvironmentUtil.j(6);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(string);
        if (bl) {
            generalCommandLine.addParameter(envNullFlag);
        }
        Map<String, String> map = CidrEnvironmentUtil.j(generalCommandLine, hostMachine, bl);
        return map.getOrDefault("SHELL", null);
    }

    private static boolean j(@NotNull HostMachine hostMachine, @NotNull String string) {
        if (hostMachine == null) {
            CidrEnvironmentUtil.j(7);
        }
        if (string == null) {
            CidrEnvironmentUtil.j(8);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{string, envNullFlag});
        CidrLogService.LOG.debug("Going to execute command {}", new Object[]{generalCommandLine});
        try {
            ProcessOutput processOutput = hostMachine.runProcess(generalCommandLine, HostUtilKt.getReadEnvironmentFileTimeoutMs());
            return processOutput.checkSuccess(CidrLogService.LOG);
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }

    @NotNull
    private static Map<String, String> j(@NotNull GeneralCommandLine generalCommandLine, @NotNull HostMachine hostMachine, final boolean bl) throws ExecutionException, IOException {
        if (generalCommandLine == null) {
            CidrEnvironmentUtil.j(9);
        }
        if (hostMachine == null) {
            CidrEnvironmentUtil.j(10);
        }
        CidrLogService.LOG.debug("Going to execute command {}", new Object[]{generalCommandLine});
        final ProcessOutput processOutput = hostMachine.runProcess(generalCommandLine.withEnvironment("LC_ALL", "C.UTF-8"), CidrRunProcessUtil.getProgressIndicator(), HostUtilKt.getReadEnvironmentFileTimeoutMs());
        if (!processOutput.checkSuccess(CidrLogService.LOG)) {
            throw new IOException(processOutput.getStderr());
        }
        return new HashMap<String, String>(){
            {
                Arrays.stream(processOutput.getStdout().split(bl ? "\u0000" : "\n")).forEach((? super T string) -> {
                    int n2 = string.indexOf("=");
                    if (n2 > 0) {
                        this.put(string.substring(0, n2), string.substring(n2 + 1));
                    }
                });
            }
        };
    }

    @NotNull
    public static Map<String, String> subtractEnvironments(@NotNull Map<String, String> sourcedEnv, @NotNull Map<String, String> originalEnv) {
        if (sourcedEnv == null) {
            CidrEnvironmentUtil.j(11);
        }
        if (originalEnv == null) {
            CidrEnvironmentUtil.j(12);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(sourcedEnv);
        originalEnv.forEach((string, string2) -> {
            if (hashMap.containsKey(string) && Objects.equals(string2, hashMap.get(string))) {
                hashMap.remove(string);
            }
        });
        HashMap<String, String> hashMap2 = hashMap;
        if (hashMap2 == null) {
            CidrEnvironmentUtil.j(13);
        }
        return hashMap2;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnvironment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellSourceCmd";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcedEnv";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalEnv";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/CidrEnvironmentUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/CidrEnvironmentUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "subtractEnvironments";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readLinuxEnvironmentFromFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getShellPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "testEnvForNullFlag";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runCommandAndParseEnv";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "subtractEnvironments";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

