/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.util.ApplicationKt;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0006\u0010\u0010\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tJ\"\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\t2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0015J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/lang/util/TeamCityLogApi;", "", "()V", "isUnderTC", "", "()Z", "block", "T", "caption", "", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "error", "", "s", "j", "getTempDirectory", "message", "name", "singleArgument", "arguments", "", "publishArtifact", "path", "Companion", "intellij.cidr.util"})
public final class TeamCityLogApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isUnderTC = System.getenv("TEAMCITY_VERSION") != null;

    public final boolean isUnderTC() {
        return this.isUnderTC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T block(@NotNull String caption, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)caption, (String)"caption");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.message("blockOpened", MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)caption)));
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            this.message("blockClosed", MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)caption)));
        }
    }

    public final void publishArtifact(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.message("publishArtifacts", path);
    }

    @NotNull
    public final String getTempDirectory() {
        String string = System.getProperty("teamcity.build.tempDir");
        if (string == null) {
            String string2 = System.getProperty("java.io.tmpdir");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        }
        return string;
    }

    public final void error(@NotNull String s10) {
        Intrinsics.checkNotNullParameter((Object)s10, (String)"s");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"text", (Object)s10), TuplesKt.to((Object)"status", (Object)"ERROR")};
        this.message("message", MapsKt.mapOf((Pair[])pairArray));
    }

    public final void message(@NotNull String name, @NotNull String singleArgument) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)singleArgument, (String)"singleArgument");
        System.out.println((Object)("##teamcity[" + name + " '" + this.j(singleArgument) + "']"));
    }

    public final void message(@NotNull String name, @NotNull Map<String, String> arguments) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append("##teamcity[");
        stringBuilder2.append(name);
        for (Map.Entry<String, String> entry2 : arguments.entrySet()) {
            stringBuilder2.append(' ');
            stringBuilder2.append(entry2.getKey());
            stringBuilder2.append('=');
            stringBuilder2.append('\'');
            stringBuilder2.append(this.j(entry2.getValue()));
            stringBuilder2.append('\'');
        }
        stringBuilder2.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        System.out.println((Object)string2);
    }

    private final String j(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            char c3 = c2;
            char c4 = c3 == '\n' ? (char)'n' : (c3 == '\r' ? (char)'r' : ((((c3 == '\'' ? true : c3 == '|') ? true : c3 == '[') ? true : c3 == ']') ? c2 : (char)'\u0000'));
            if (c4 != '\u0000') {
                stringBuilder.append('|').append(c4);
                continue;
            }
            if (c2 < ' ' || c2 >= '\u007f') {
                String string2 = "0x%04x";
                Object[] objectArray = new Object[]{(short)c2};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                stringBuilder.append(string3);
                continue;
            }
            stringBuilder.append(c2);
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/lang/util/TeamCityLogApi$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/lang/util/TeamCityLogApi;", "intellij.cidr.util"})
    @SourceDebugExtension(value={"SMAP\nTeamCityLogApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamCityLogApi.kt\ncom/jetbrains/cidr/lang/util/TeamCityLogApi$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,83:1\n31#2,2:84\n*S KotlinDebug\n*F\n+ 1 TeamCityLogApi.kt\ncom/jetbrains/cidr/lang/util/TeamCityLogApi$Companion\n*L\n10#1:84,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TeamCityLogApi getInstance() {
            ComponentManager componentManager = (ComponentManager)ApplicationKt.getApplication();
            boolean bl = false;
            Class<TeamCityLogApi> clazz = TeamCityLogApi.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (TeamCityLogApi)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

