/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import java.io.File;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrToolEnvironment {
    public static final String UNIX_FILE_SEPARATORS = "/";
    public static final String WINDOWS_UNIX_FILE_SEPARATORS = "/\\";
    protected final boolean isWindows;

    public CidrToolEnvironment() {
        this(SystemInfo.isWindows);
    }

    public CidrToolEnvironment(boolean isWindows) {
        this.isWindows = isWindows;
    }

    public void prepare(@NotNull GeneralCommandLine cl, @NotNull PrepareFor prepareFor) throws ExecutionException {
        if (cl == null) {
            CidrToolEnvironment.j(0);
        }
        if (prepareFor == null) {
            CidrToolEnvironment.j(1);
        }
    }

    @Contract(value="null -> null")
    public final String toLocalPath(@Nullable String absoluteEnvPath) {
        return this.toLocalPath(null, absoluteEnvPath);
    }

    @Contract(value="_, null -> null")
    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            return null;
        }
        if (localBaseDir != null && !this.isEnvAbsolute(absoluteOrRelativeEnvPath)) {
            String string = StringsKt.trimEnd((String)localBaseDir.getPath(), c2 -> this.getSupportedFileSeparators().contains(c2.charValue()));
            absoluteOrRelativeEnvPath = FileUtil.toCanonicalPath((String)(string + UNIX_FILE_SEPARATORS + absoluteOrRelativeEnvPath));
        }
        return absoluteOrRelativeEnvPath;
    }

    public boolean isEnvAbsolute(@NotNull String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            CidrToolEnvironment.j(2);
        }
        return this.isWindows ? FileUtil.isWindowsAbsolutePath((String)absoluteOrRelativeEnvPath) : FileUtil.isUnixAbsolutePath((String)absoluteOrRelativeEnvPath);
    }

    @Contract(value="null -> null")
    public String toEnvPath(@Nullable String localPath) {
        return localPath;
    }

    @NotNull
    public CidrFileSeparators getSupportedFileSeparators() {
        CidrFileSeparators cidrFileSeparators = this.isWindows ? CidrFileSeparators.WINDOWS_UNIX : CidrFileSeparators.UNIX;
        if (cidrFileSeparators == null) {
            CidrToolEnvironment.j(3);
        }
        return cidrFileSeparators;
    }

    public HostMachine getHostMachine() {
        return LocalHost.INSTANCE;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteOrRelativeEnvPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/toolchains/CidrToolEnvironment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/toolchains/CidrToolEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnvAbsolute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static final class PrepareFor
    extends Enum<PrepareFor> {
        public static final /* enum */ PrepareFor BUILD = new PrepareFor();
        public static final /* enum */ PrepareFor RUN = new PrepareFor();
        private static final /* synthetic */ PrepareFor[] $VALUES;

        public static PrepareFor[] values() {
            return (PrepareFor[])$VALUES.clone();
        }

        public static PrepareFor valueOf(String name) {
            return Enum.valueOf(PrepareFor.class, name);
        }

        private static /* synthetic */ PrepareFor[] j() {
            return new PrepareFor[]{BUILD, RUN};
        }

        static {
            $VALUES = PrepareFor.j();
        }
    }
}

