/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.simulatorSupport;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorConfiguration;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorDeviceType;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorRuntime;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorsRegistry;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Xcode6SimulatorConfiguration
extends SimulatorConfiguration {
    @NotNull
    private final String myUDID;
    @NotNull
    private final String myName;
    @NotNull
    private final SimulatorDeviceType myDeviceType;
    @NotNull
    private final SimulatorRuntime myRuntime;
    @NotNull
    private final File mySimulatorDir;
    @NotNull
    private static final Set<String> ourMissingDeviceTypes = ConcurrentCollectionFactory.createConcurrentSet();
    @NotNull
    private static final Set<String> ourMissingRuntimes = ConcurrentCollectionFactory.createConcurrentSet();
    @NotNull
    private static final String ourOSVersion = Xcode6SimulatorConfiguration.j();
    public static final Comparator<Xcode6SimulatorConfiguration> COMPARATOR = (xcode6SimulatorConfiguration, xcode6SimulatorConfiguration2) -> {
        int n2 = xcode6SimulatorConfiguration.getLaunchDeviceFamily() - xcode6SimulatorConfiguration2.getLaunchDeviceFamily();
        if (n2 != 0) {
            return n2;
        }
        n2 = -StringUtil.compareVersionNumbers((String)xcode6SimulatorConfiguration.getRuntime().getVersion(), (String)xcode6SimulatorConfiguration2.getRuntime().getVersion());
        if (n2 != 0) {
            return n2;
        }
        n2 = xcode6SimulatorConfiguration.getLaunchArchitecture().getType().compareTo(xcode6SimulatorConfiguration2.getLaunchArchitecture().getType());
        if (n2 != 0) {
            return n2;
        }
        n2 = xcode6SimulatorConfiguration.getName().compareToIgnoreCase(xcode6SimulatorConfiguration2.getName());
        if (n2 != 0) {
            return n2;
        }
        return 0;
    };

    @NotNull
    private static String j() {
        Version version = Version.parseVersion((String)SystemInfo.OS_VERSION);
        if (version == null || version.major >= 11) {
            String string = SystemInfo.OS_VERSION;
            if (string == null) {
                Xcode6SimulatorConfiguration.N(0);
            }
            return string;
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"sw_vers", "-productVersion"});
        generalCommandLine.getEnvironment().put("SYSTEM_VERSION_COMPAT", "0");
        String string = ExecUtil.execAndReadLine((GeneralCommandLine)generalCommandLine);
        String string2 = string == null ? SystemInfo.OS_VERSION : string;
        if (string2 == null) {
            Xcode6SimulatorConfiguration.N(1);
        }
        return string2;
    }

    @Nullable
    public static Xcode6SimulatorConfiguration read(@NotNull File dir, @NotNull SimulatorsRegistry.State state) throws InvalidSpecException, IOException {
        File file2;
        if (dir == null) {
            Xcode6SimulatorConfiguration.N(2);
        }
        if (state == null) {
            Xcode6SimulatorConfiguration.N(3);
        }
        if (!(file2 = new File(dir, "device.plist")).exists() || !file2.isFile()) {
            return null;
        }
        Plist plist = PlistDriver.readAnyFormat(file2);
        String string = plist.getNotNullString("UDID");
        String string2 = plist.getNotNullString("name");
        String string3 = plist.getNotNullString("deviceType");
        String string4 = plist.getNotNullString("runtime");
        SimulatorDeviceType simulatorDeviceType = state.findDeviceType(string3);
        SimulatorRuntime simulatorRuntime = state.findRuntime(string4);
        if (simulatorDeviceType == null || simulatorRuntime == null) {
            if (simulatorDeviceType == null && ourMissingDeviceTypes.add(string3)) {
                XCLog.LOG.info("Simulator deviceType not found: " + string3);
            }
            if (simulatorRuntime == null && ourMissingRuntimes.add(string4)) {
                XCLog.LOG.info("Simulator runtime not found: " + string4);
            }
            return null;
        }
        ourMissingDeviceTypes.remove(string3);
        ourMissingRuntimes.remove(string4);
        return new Xcode6SimulatorConfiguration(string, string2, simulatorDeviceType, simulatorRuntime, dir);
    }

    public Xcode6SimulatorConfiguration(@NotNull String udid, @NotNull String name, @NotNull SimulatorDeviceType deviceType, @NotNull SimulatorRuntime runtime, @NotNull File simulatorDir) {
        if (udid == null) {
            Xcode6SimulatorConfiguration.N(4);
        }
        if (name == null) {
            Xcode6SimulatorConfiguration.N(5);
        }
        if (deviceType == null) {
            Xcode6SimulatorConfiguration.N(6);
        }
        if (runtime == null) {
            Xcode6SimulatorConfiguration.N(7);
        }
        if (simulatorDir == null) {
            Xcode6SimulatorConfiguration.N(8);
        }
        this.myUDID = udid;
        this.myName = name;
        this.myDeviceType = deviceType;
        this.myRuntime = runtime;
        this.mySimulatorDir = simulatorDir;
    }

    @Override
    @NotNull
    public String getUDID() {
        String string = this.myUDID;
        if (string == null) {
            Xcode6SimulatorConfiguration.N(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Xcode6SimulatorConfiguration.N(10);
        }
        return string;
    }

    @Override
    @Nullable
    public String getMinRuntimeVersion() {
        return this.myDeviceType.getMinRuntimeVersion();
    }

    @Override
    @Nullable
    public String getMaxRuntimeVersion() {
        return this.myDeviceType.getMaxRuntimeVersion();
    }

    @Override
    @NotNull
    public String getVersion() {
        String string = this.myRuntime.getVersion();
        if (string == null) {
            Xcode6SimulatorConfiguration.N(11);
        }
        return string;
    }

    @Override
    @Nullable
    public String getBuildVersion() {
        return this.myRuntime.getBuildVersion();
    }

    @Override
    public int getScale() {
        return this.myDeviceType.getScale();
    }

    @Override
    public int getHeight() {
        return this.myDeviceType.getHeight();
    }

    @Override
    public Set<Integer> getSupportedDeviceFamilies() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>(this.myDeviceType.getSupportedDeviceFamilies());
        treeSet.retainAll(this.myRuntime.getSupportedDeviceFamilies());
        return Collections.unmodifiableSet(treeSet);
    }

    @Override
    public List<ArchitectureValue> getSupportedArchitectures() {
        return this.myDeviceType.getSupportedArchitectures();
    }

    @Override
    @Nullable
    public ArchitectureValue getRunArchitectureIfCompatible(@NotNull Collection<Integer> applicationDeviceFamilies, @NotNull Collection<ArchitectureValue> applicationArchitectures) {
        if (applicationDeviceFamilies == null) {
            Xcode6SimulatorConfiguration.N(12);
        }
        if (applicationArchitectures == null) {
            Xcode6SimulatorConfiguration.N(13);
        }
        if (!Xcode6SimulatorConfiguration.isVersionBetween(ourOSVersion, this.myRuntime.getMinHostVersion(), this.myRuntime.getMaxHostVersion())) {
            return null;
        }
        return super.getRunArchitectureIfCompatible(applicationDeviceFamilies, applicationArchitectures);
    }

    @NotNull
    public SimulatorDeviceType getDeviceType() {
        SimulatorDeviceType simulatorDeviceType = this.myDeviceType;
        if (simulatorDeviceType == null) {
            Xcode6SimulatorConfiguration.N(14);
        }
        return simulatorDeviceType;
    }

    @Override
    @NotNull
    public SimulatorRuntime getRuntime() {
        SimulatorRuntime simulatorRuntime = this.myRuntime;
        if (simulatorRuntime == null) {
            Xcode6SimulatorConfiguration.N(15);
        }
        return simulatorRuntime;
    }

    @Override
    @NotNull
    public File getSimulatorDir() {
        File file2 = this.mySimulatorDir;
        if (file2 == null) {
            Xcode6SimulatorConfiguration.N(16);
        }
        return file2;
    }

    @NonNls
    public String toString() {
        return "SimulatorConfiguration{myUDID='" + this.myUDID + "', myName='" + this.myName + "', myDeviceType=" + this.myDeviceType + ", myRuntime=" + this.myRuntime + ", mySimulatorDir=" + this.mySimulatorDir + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Xcode6SimulatorConfiguration xcode6SimulatorConfiguration = (Xcode6SimulatorConfiguration)o2;
        if (!this.myDeviceType.equals(xcode6SimulatorConfiguration.myDeviceType)) {
            return false;
        }
        if (!this.myName.equals(xcode6SimulatorConfiguration.myName)) {
            return false;
        }
        if (!this.myRuntime.equals(xcode6SimulatorConfiguration.myRuntime)) {
            return false;
        }
        if (!this.myUDID.equals(xcode6SimulatorConfiguration.myUDID)) {
            return false;
        }
        return FileUtil.filesEqual((File)this.mySimulatorDir, (File)xcode6SimulatorConfiguration.mySimulatorDir);
    }

    public int hashCode() {
        int n2 = this.myUDID.hashCode();
        n2 = 31 * n2 + this.myName.hashCode();
        n2 = 31 * n2 + this.myDeviceType.hashCode();
        n2 = 31 * n2 + this.myRuntime.hashCode();
        n2 = 31 * n2 + FileUtil.fileHashCode((File)this.mySimulatorDir);
        return n2;
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 12, 13 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/simulatorSupport/Xcode6SimulatorConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "udid";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simulatorDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationDeviceFamilies";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationArchitectures";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "determineOSVersion";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/Xcode6SimulatorConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUDID";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntime";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimulatorDir";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRunArchitectureIfCompatible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

