/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.simulatorSupport;

import com.intellij.execution.ExecutionTargetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.NSErrorException;
import com.jetbrains.cidr.OCCorePathManager;
import com.jetbrains.cidr.OCPathManager;
import com.jetbrains.cidr.execution.JBDevicePreferredPlatformBuildForSdkBuild;
import com.jetbrains.cidr.execution.PreferredPlatformBuildForSdkBuild;
import com.jetbrains.cidr.execution.PreferredPlatformBuildForSdkBuildFactory;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceException;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorConfiguration;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorDeviceType;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorRuntime;
import com.jetbrains.cidr.execution.simulatorSupport.Xcode6SimulatorConfiguration;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.Xcode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Service(value={Service.Level.APP})
public final class SimulatorsRegistry
implements Disposable {
    private static final File CORE_SIMULATOR_VOLUMES_DIR = new File("/Library/Developer/CoreSimulator/Volumes");
    private static final PreferredPlatformBuildForSdkBuildFactory DEFAULT_BUILD_PREFERENCES_FACTORY = JBDevicePreferredPlatformBuildForSdkBuild.Factory;
    private static PreferredPlatformBuildForSdkBuildFactory BUILD_PREFERENCES_FACTORY_OVERRIDE = null;
    @NotNull
    private volatile State myState = new State();
    private final Alarm myUpdateAlarm;

    @NotNull
    public static SimulatorsRegistry getInstance() {
        SimulatorsRegistry simulatorsRegistry = (SimulatorsRegistry)ApplicationManager.getApplication().getService(SimulatorsRegistry.class);
        if (simulatorsRegistry == null) {
            SimulatorsRegistry.j(0);
        }
        return simulatorsRegistry;
    }

    public static List<File> getDefaultProfilesDirs() {
        File[] fileArray;
        File[] fileArray2;
        ArrayList<File> arrayList = new ArrayList<File>();
        File file3 = SimulatorsRegistry.N();
        if (file3.exists() && (fileArray2 = file3.listFiles((file2, string) -> string.endsWith(".platform"))) != null) {
            arrayList.addAll(Arrays.asList(fileArray2));
        }
        if ((fileArray2 = SimulatorsRegistry.j()).exists() && (fileArray = fileArray2.listFiles()) != null) {
            arrayList.addAll(Arrays.asList(fileArray));
        }
        return ContainerUtil.prepend((List)ContainerUtil.map(arrayList, file2 -> new File((File)file2, "Library/Developer/CoreSimulator/Profiles")), (Object[])new File[]{OCPathManager.getLibrarySubFile("Developer/CoreSimulator/Profiles")});
    }

    public static File getDefaultConfigsDir() {
        return OCCorePathManager.getUserLibrarySubFile("Developer/CoreSimulator/Devices");
    }

    private static File N() {
        return Xcode.getInstance().getSubFile("Platforms");
    }

    private static File j() {
        return CORE_SIMULATOR_VOLUMES_DIR;
    }

    public static List<Path> getWatchingDirs() {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(SimulatorsRegistry.getDefaultConfigsDir());
        arrayList.add(SimulatorsRegistry.N());
        arrayList.add(SimulatorsRegistry.j());
        List<File> list = SimulatorsRegistry.getDefaultProfilesDirs();
        arrayList.addAll(ContainerUtil.map(list, file2 -> new File((File)file2, "DeviceTypes")));
        arrayList.addAll(ContainerUtil.map(list, file2 -> new File((File)file2, "Runtimes")));
        return ContainerUtil.map(arrayList, File::toPath);
    }

    public SimulatorsRegistry() {
        if (!Xcode.getInstance().isInstalled()) {
            this.myUpdateAlarm = null;
            return;
        }
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.refresh();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.j(0);
                }
                SimulatorsRegistry.this.N();
            }

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.j(1);
                }
                SimulatorsRegistry.this.myUpdateAlarm.cancelAllRequests();
            }

            private static /* synthetic */ void j(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "ideFrame";
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorsRegistry$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applicationActivated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applicationDeactivated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void N() {
        if (this.myUpdateAlarm == null || !this.myUpdateAlarm.isEmpty()) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> {
            this.refresh();
            WriteAction.runAndWait(() -> {
                for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                    ExecutionTargetManager.update((Project)project2);
                }
            });
        }, 300);
    }

    @NotNull
    public List<SimulatorDeviceType> getDeviceTypes() {
        List<SimulatorDeviceType> list = this.myState.deviceTypes;
        if (list == null) {
            SimulatorsRegistry.j(1);
        }
        return list;
    }

    @Nullable
    public SimulatorDeviceType findDeviceTypes(@Nullable String id) {
        return this.myState.findDeviceType(id);
    }

    @NotNull
    public List<SimulatorRuntime> getRuntimes() {
        List<SimulatorRuntime> list = this.myState.runtimes;
        if (list == null) {
            SimulatorsRegistry.j(2);
        }
        return list;
    }

    @Nullable
    public SimulatorRuntime findRuntime(@Nullable String id) {
        return this.myState.findRuntime(id);
    }

    @NotNull
    public List<SimulatorConfiguration> getConfigurations() {
        List<SimulatorConfiguration> list = this.myState.configurations;
        if (list == null) {
            SimulatorsRegistry.j(3);
        }
        return list;
    }

    public void refresh() {
        this.refresh(SimulatorsRegistry.getDefaultProfilesDirs(), SimulatorsRegistry.getDefaultConfigsDir());
    }

    public void refresh(@NotNull List<File> profilesDirs, @NotNull File configurationsDir) {
        if (profilesDirs == null) {
            SimulatorsRegistry.j(4);
        }
        if (configurationsDir == null) {
            SimulatorsRegistry.j(5);
        }
        this.myState = SimulatorsRegistry.j(profilesDirs, configurationsDir);
    }

    @NotNull
    private static synchronized State j(@NotNull List<File> list, @NotNull File file2) {
        State state;
        if (list == null) {
            SimulatorsRegistry.j(6);
        }
        if (file2 == null) {
            SimulatorsRegistry.j(7);
        }
        State state2 = new State();
        state2.deviceTypes = SimulatorsRegistry.j(list, "DeviceTypes", ".simdevicetype", "device types", new Reader<SimulatorDeviceType>(){

            @Override
            public SimulatorDeviceType read(@NotNull File file2) throws InvalidSpecException, SimulatorRuntime.IncompatibleException, IOException {
                if (file2 == null) {
                    2.j(0);
                }
                return SimulatorDeviceType.read(file2);
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/execution/simulatorSupport/SimulatorsRegistry$2", "read"));
            }
        });
        try {
            final PreferredPlatformBuildForSdkBuild preferredPlatformBuildForSdkBuild = SimulatorsRegistry.j().create();
            List<SimulatorRuntime> list2 = SimulatorsRegistry.j(list, "Runtimes", ".simruntime", "runtimes", new Reader<SimulatorRuntime>(){

                @Override
                public SimulatorRuntime read(@NotNull File file2) throws InvalidSpecException, SimulatorRuntime.IncompatibleException, IOException {
                    if (file2 == null) {
                        3.j(0);
                    }
                    return SimulatorRuntime.read(file2, preferredPlatformBuildForSdkBuild);
                }

                private static /* synthetic */ void j(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/cidr/execution/simulatorSupport/SimulatorsRegistry$3", "read"));
                }
            });
            state2.runtimes = preferredPlatformBuildForSdkBuild.filterRuntimesWithAvailablePlatforms(list2);
            SimulatorsRegistry.j(file2, state2);
            state = state2;
        }
        catch (NSErrorException | AMDeviceException executionException) {
            XCLog.LOG.warn("Error reading simulator preferences from Xcode: " + executionException.getMessage());
            State state3 = state2;
            if (state3 == null) {
                SimulatorsRegistry.j(9);
            }
            return state3;
        }
        if (state == null) {
            SimulatorsRegistry.j(8);
        }
        return state;
    }

    private static void j(@NotNull File file2, @NotNull State state) {
        File[] fileArray;
        if (file2 == null) {
            SimulatorsRegistry.j(10);
        }
        if (state == null) {
            SimulatorsRegistry.j(11);
        }
        if ((fileArray = file2.listFiles()) == null) {
            XCLog.LOG.warn("Simulator configurations not found at " + file2);
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (File file3 : fileArray) {
            if (!file3.isDirectory()) continue;
            try {
                ContainerUtil.addIfNotNull(arrayList, (Object)Xcode6SimulatorConfiguration.read(file3, state));
            }
            catch (InvalidSpecException | IOException exception) {
                XCLog.LOG.warn((Throwable)exception);
            }
        }
        state.configurations = ContainerUtil.sorted(arrayList, Xcode6SimulatorConfiguration.COMPARATOR);
    }

    private static <T> List<T> j(@NotNull List<File> list, @NotNull @NonNls String string, @NotNull @NonNls String string2, @NotNull @NonNls String string3, @NotNull Reader<T> reader) {
        if (list == null) {
            SimulatorsRegistry.j(12);
        }
        if (string == null) {
            SimulatorsRegistry.j(13);
        }
        if (string2 == null) {
            SimulatorsRegistry.j(14);
        }
        if (string3 == null) {
            SimulatorsRegistry.j(15);
        }
        if (reader == null) {
            SimulatorsRegistry.j(16);
        }
        ArrayList arrayList = new ArrayList();
        for (File object : list) {
            Object object2 = new File(object, string).listFiles();
            if (object2 == null) continue;
            ContainerUtil.addAll(arrayList, (Object[])object2);
        }
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (Object object2 : arrayList) {
            if (!((File)object2).isDirectory() || !StringUtil.endsWithIgnoreCase((String)((File)object2).getName(), (String)string2)) continue;
            try {
                arrayList2.add(reader.read((File)object2));
            }
            catch (SimulatorRuntime.IncompatibleException exception) {
                XCLog.LOG.warn((Throwable)exception);
            }
            catch (InvalidSpecException | IOException exception) {
                XCLog.LOG.error((Throwable)exception);
            }
        }
        if (arrayList2.isEmpty()) {
            XCLog.LOG.warn("No compatible simulators " + string3 + " found at " + list);
        }
        return Collections.unmodifiableList(arrayList2);
    }

    public void dispose() {
    }

    @TestOnly
    public static synchronized void setBuildPreferencesFactoryInTests(@Nullable PreferredPlatformBuildForSdkBuildFactory factory) {
        BUILD_PREFERENCES_FACTORY_OVERRIDE = factory;
    }

    @NotNull
    private static synchronized PreferredPlatformBuildForSdkBuildFactory j() {
        PreferredPlatformBuildForSdkBuildFactory preferredPlatformBuildForSdkBuildFactory = BUILD_PREFERENCES_FACTORY_OVERRIDE;
        PreferredPlatformBuildForSdkBuildFactory preferredPlatformBuildForSdkBuildFactory2 = preferredPlatformBuildForSdkBuildFactory != null ? preferredPlatformBuildForSdkBuildFactory : DEFAULT_BUILD_PREFERENCES_FACTORY;
        if (preferredPlatformBuildForSdkBuildFactory2 == null) {
            SimulatorsRegistry.j(17);
        }
        return preferredPlatformBuildForSdkBuildFactory2;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 4, 5, 6, 7, 10, 11, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorsRegistry";
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilesDirs";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationsDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorsRegistry";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildPreferencesFactory";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readConfigurations";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 10, 11, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }

    static class State {
        private List<SimulatorDeviceType> deviceTypes = Collections.emptyList();
        private List<SimulatorRuntime> runtimes = Collections.emptyList();
        private List<SimulatorConfiguration> configurations = Collections.emptyList();

        State() {
        }

        @Nullable
        protected SimulatorDeviceType findDeviceType(@Nullable String id) {
            for (SimulatorDeviceType simulatorDeviceType : this.deviceTypes) {
                if (!simulatorDeviceType.getID().equals(id)) continue;
                return simulatorDeviceType;
            }
            return null;
        }

        @Nullable
        protected SimulatorRuntime findRuntime(@Nullable String id) {
            for (SimulatorRuntime simulatorRuntime : this.runtimes) {
                if (!simulatorRuntime.getID().equals(id)) continue;
                return simulatorRuntime;
            }
            return null;
        }
    }

    private static interface Reader<T> {
        public T read(@NotNull File var1) throws InvalidSpecException, SimulatorRuntime.IncompatibleException, IOException;
    }
}

