/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.simulatorSupport;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.PreferredPlatformBuildForSdkBuild;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorConfiguration;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import com.jetbrains.cidr.xcode.frameworks.AppleSdk;
import com.jetbrains.cidr.xcode.frameworks.AppleSdkManager;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimulatorRuntime {
    @NotNull
    private final String myID;
    @NotNull
    private final String myVersion;
    @Nullable
    private final String myMinHostVersion;
    @Nullable
    private final String myMaxHostVersion;
    @Nullable
    private final String myBuildVersion;
    @NotNull
    private final File myRoot;
    @NotNull
    private final List<Integer> mySupportedDeviceFamilies;

    @NotNull
    public static SimulatorRuntime read(@NotNull File dir, @NotNull PreferredPlatformBuildForSdkBuild buildPreferences) throws InvalidSpecException, IncompatibleException, IOException {
        if (dir == null) {
            SimulatorRuntime.j(0);
        }
        if (buildPreferences == null) {
            SimulatorRuntime.j(1);
        }
        File file2 = new File(dir, "Contents");
        Plist plist = PlistDriver.readAnyFormat(new File(file2, "Info.plist"));
        @NonNls String string = plist.getNotNullString("CFBundleIdentifier");
        Plist plist2 = PlistDriver.readAnyFormat(new File(file2, "Resources/profile.plist"));
        @NonNls String string2 = plist2.getNotNullString("defaultVersionString");
        @NonNls String string3 = plist.getNotNullString("CFBundleName");
        if (string2.equals("11.3") && plist.getNotNullString("DTXcodeBuild").equals("9P107g") && (string3.equals("iOS 11.4") || string3.equals("tvOS 11.4"))) {
            string2 = "11.4";
        }
        String string4 = plist2.getString("minHostVersion");
        String string5 = plist2.getString("maxHostVersion");
        List<Number> list = plist2.getAttributeList("supportedProductFamilyIDs", Number.class, Collections.emptyList());
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        for (Number object2 : list) {
            arrayList.add(object2.intValue());
        }
        File file3 = new File(file2, "Resources/RuntimeRoot/System/Library/CoreServices/SystemVersion.plist");
        Plist plist3 = file3.exists() ? PlistDriver.readAnyFormatSafe(file3) : null;
        String string6 = null;
        if (plist3 != null) {
            string6 = plist3.getString("ProductBuildVersion");
        }
        SimulatorRuntime.j(dir, string2, string6, buildPreferences, arrayList);
        return new SimulatorRuntime(string, string2, string4, string5, string6, arrayList, file2);
    }

    private static void j(@NotNull File file2, @NotNull String string, @Nullable String string2, @NotNull PreferredPlatformBuildForSdkBuild preferredPlatformBuildForSdkBuild, @NotNull List<Integer> list) {
        if (file2 == null) {
            SimulatorRuntime.j(2);
        }
        if (string == null) {
            SimulatorRuntime.j(3);
        }
        if (preferredPlatformBuildForSdkBuild == null) {
            SimulatorRuntime.j(4);
        }
        if (list == null) {
            SimulatorRuntime.j(5);
        }
        for (Integer n2 : list) {
            List<AppleSdk> list2;
            boolean bl;
            ApplePlatform.Type type = SimulatorConfiguration.getPlatformTypeForFamily(n2);
            if (type == null || (bl = ContainerUtil.exists(list2 = AppleSdkManager.getInstance().findSdksForPlatform(type), appleSdk -> preferredPlatformBuildForSdkBuild.isSupported((AppleSdk)appleSdk, string, string2)))) continue;
            throw new IncompatibleException(file2, type, preferredPlatformBuildForSdkBuild);
        }
    }

    public SimulatorRuntime(@NotNull String id, @NotNull String version, @Nullable String minHostVersion, @Nullable String maxHostVersion, @Nullable String buildVersion, @NotNull List<Integer> supportedDeviceFamilies, @NotNull File root) {
        if (id == null) {
            SimulatorRuntime.j(6);
        }
        if (version == null) {
            SimulatorRuntime.j(7);
        }
        if (supportedDeviceFamilies == null) {
            SimulatorRuntime.j(8);
        }
        if (root == null) {
            SimulatorRuntime.j(9);
        }
        this.myID = id;
        this.myVersion = version;
        this.myMinHostVersion = minHostVersion;
        this.myMaxHostVersion = maxHostVersion;
        this.myBuildVersion = buildVersion;
        this.mySupportedDeviceFamilies = Collections.unmodifiableList(supportedDeviceFamilies);
        this.myRoot = root;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            SimulatorRuntime.j(10);
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            SimulatorRuntime.j(11);
        }
        return string;
    }

    @Nullable
    public String getMinHostVersion() {
        return this.myMinHostVersion;
    }

    @Nullable
    public String getMaxHostVersion() {
        return this.myMaxHostVersion;
    }

    @Nullable
    public String getBuildVersion() {
        return this.myBuildVersion;
    }

    @NotNull
    public List<Integer> getSupportedDeviceFamilies() {
        List<Integer> list = this.mySupportedDeviceFamilies;
        if (list == null) {
            SimulatorRuntime.j(12);
        }
        return list;
    }

    @NotNull
    public File getRootSubFile(@Nullable String relativePath) {
        return relativePath == null ? this.myRoot : new File(this.myRoot, relativePath);
    }

    @NotNull
    public String getRootSubFilePath(@NonNls @Nullable String relativePath) {
        String string = this.getRootSubFile(relativePath).getPath();
        if (string == null) {
            SimulatorRuntime.j(13);
        }
        return string;
    }

    @NonNls
    public String toString() {
        return "SimulatorRuntime{myID='" + this.myID + "', myVersion='" + this.myVersion + "', myMinHostVersion='" + this.myMinHostVersion + "', myMaxHostVersion='" + this.myMaxHostVersion + "', myBuildVersion='" + this.myBuildVersion + "', mySupportedDeviceFamilies=" + this.mySupportedDeviceFamilies + ", myRoot=" + this.myRoot + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SimulatorRuntime simulatorRuntime = (SimulatorRuntime)o2;
        if (!this.myID.equals(simulatorRuntime.myID)) {
            return false;
        }
        if (!this.myVersion.equals(simulatorRuntime.myVersion)) {
            return false;
        }
        if (!Objects.equals(this.myBuildVersion, simulatorRuntime.myBuildVersion)) {
            return false;
        }
        if (!Objects.equals(this.myMaxHostVersion, simulatorRuntime.myMaxHostVersion)) {
            return false;
        }
        if (!Objects.equals(this.myMinHostVersion, simulatorRuntime.myMinHostVersion)) {
            return false;
        }
        if (!this.mySupportedDeviceFamilies.equals(simulatorRuntime.mySupportedDeviceFamilies)) {
            return false;
        }
        return FileUtil.filesEqual((File)this.myRoot, (File)simulatorRuntime.myRoot);
    }

    public int hashCode() {
        int n2 = this.myID.hashCode();
        n2 = 31 * n2 + this.myVersion.hashCode();
        n2 = 31 * n2 + Objects.hashCode(this.myMinHostVersion);
        n2 = 31 * n2 + Objects.hashCode(this.myMaxHostVersion);
        n2 = 31 * n2 + Objects.hashCode(this.myBuildVersion);
        n2 = 31 * n2 + this.mySupportedDeviceFamilies.hashCode();
        n2 = 31 * n2 + FileUtil.fileHashCode((File)this.myRoot);
        return n2;
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 10, 11, 12, 13 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildPreferences";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intDevices";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedDeviceFamilies";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorRuntime";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorRuntime";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedDeviceFamilies";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootSubFilePath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkBuildVersionCompatibilityWithAllPlatforms";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    public static class IncompatibleException
    extends RuntimeException {
        public IncompatibleException(@NotNull File dir, @NotNull ApplePlatform.Type platformType, @NotNull PreferredPlatformBuildForSdkBuild buildPreferences) {
            if (dir == null) {
                IncompatibleException.j(0);
            }
            if (platformType == null) {
                IncompatibleException.j(1);
            }
            if (buildPreferences == null) {
                IncompatibleException.j(2);
            }
            super("Incompatible Apple Simulator runtime at %s for %s according to current build preferences:\n%s".formatted(new Object[]{dir, platformType, buildPreferences}));
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "platformType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildPreferences";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorRuntime$IncompatibleException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

