/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.simulatorSupport;

import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorConfiguration;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorRuntime;
import com.jetbrains.cidr.xcode.Dictionary;
import com.jetbrains.cidr.xcode.InvalidSpecException;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.cidr.xcode.plist.PlistDriver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimulatorDeviceType {
    @NotNull
    private final String myID;
    @NotNull
    private final String myPresentableName;
    @Nullable
    private final String myModelIdentifier;
    @Nullable
    private final String myMinRuntimeVersion;
    @Nullable
    private final String myMaxRuntimeVersion;
    @Nullable
    private final VersionRange myCreateByDefaultForRuntimeVersions;
    private final int myScale;
    private final int myHeight;
    @NotNull
    private final List<Integer> mySupportedDeviceFamilies;
    @NotNull
    private final List<ArchitectureValue> mySupportedArchitectures;
    private static final String SIM_DEVICE_TYPE_EXTENSION = ".simdevicetype";

    @NotNull
    public static SimulatorDeviceType read(@NotNull File dir) throws InvalidSpecException, IOException {
        if (dir == null) {
            SimulatorDeviceType.j(0);
        }
        String string = SimulatorDeviceType.j(dir.getName());
        Plist plist = PlistDriver.readAnyFormat(new File(dir, "Contents/Info.plist"));
        String string2 = plist.getNotNullString("CFBundleIdentifier");
        Plist plist2 = PlistDriver.readAnyFormat(new File(dir, "Contents/Resources/profile.plist"));
        String string3 = plist2.getString("modelIdentifier");
        String string4 = plist2.getString("minRuntimeVersion");
        String string5 = plist2.getString("maxRuntimeVersion");
        VersionRange versionRange = null;
        Dictionary dictionary = plist2.getDictionary("createByDefaultForRuntimeVersions", null);
        if (dictionary != null) {
            String string6 = dictionary.getNotNullString("versionMin");
            String string7 = dictionary.getNotNullString("versionMax");
            versionRange = new VersionRange(string6, string7);
        }
        int n2 = SimulatorDeviceType.j(plist2.get("mainScreenScale"));
        int n3 = SimulatorDeviceType.j(plist2.get("mainScreenHeight"));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Number object : plist2.getAttributeList("supportedProductFamilyIDs", Number.class, Collections.emptyList())) {
            arrayList.add(object.intValue());
        }
        ArrayList arrayList2 = new ArrayList();
        for (String string6 : plist2.getAttributeList("supportedArchs", String.class, Collections.emptyList())) {
            arrayList2.add(new ArchitectureValue(string6));
        }
        return new SimulatorDeviceType(string2, string, string3, string4, string5, versionRange, n2, n3, arrayList, arrayList2);
    }

    public SimulatorDeviceType(@NotNull String id, @NotNull String presentableName, @Nullable String modelIdentifier, @Nullable String minRuntimeVersion, @Nullable String maxRuntimeVersion, @Nullable VersionRange createByDefaultForRuntimeVersions, int scale, int height, @NotNull List<Integer> deviceFamilies, @NotNull List<ArchitectureValue> architectures) {
        if (id == null) {
            SimulatorDeviceType.j(1);
        }
        if (presentableName == null) {
            SimulatorDeviceType.j(2);
        }
        if (deviceFamilies == null) {
            SimulatorDeviceType.j(3);
        }
        if (architectures == null) {
            SimulatorDeviceType.j(4);
        }
        this.myID = id;
        this.myPresentableName = presentableName;
        this.myModelIdentifier = modelIdentifier;
        this.myMinRuntimeVersion = minRuntimeVersion;
        this.myMaxRuntimeVersion = maxRuntimeVersion;
        this.myCreateByDefaultForRuntimeVersions = createByDefaultForRuntimeVersions;
        this.myScale = scale;
        this.myHeight = height;
        this.mySupportedDeviceFamilies = Collections.unmodifiableList(deviceFamilies);
        this.mySupportedArchitectures = Collections.unmodifiableList(architectures);
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            SimulatorDeviceType.j(5);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            SimulatorDeviceType.j(6);
        }
        return string;
    }

    @Nullable
    public String getModelIdentifier() {
        return this.myModelIdentifier;
    }

    @Nullable
    public String getMinRuntimeVersion() {
        return this.myMinRuntimeVersion;
    }

    @Nullable
    public String getMaxRuntimeVersion() {
        return this.myMaxRuntimeVersion;
    }

    public boolean createByDefaultFor(SimulatorRuntime runtime) {
        if (this.myCreateByDefaultForRuntimeVersions == null) {
            return false;
        }
        return runtime.getSupportedDeviceFamilies().containsAll(this.mySupportedDeviceFamilies) && SimulatorConfiguration.isVersionBetween(runtime.getVersion(), this.getMinRuntimeVersion(), this.getMaxRuntimeVersion()) && this.myCreateByDefaultForRuntimeVersions.include(runtime.getVersion());
    }

    public int getScale() {
        return this.myScale;
    }

    public int getHeight() {
        return this.myHeight;
    }

    @NotNull
    public List<Integer> getSupportedDeviceFamilies() {
        List<Integer> list = this.mySupportedDeviceFamilies;
        if (list == null) {
            SimulatorDeviceType.j(7);
        }
        return list;
    }

    @NotNull
    public List<ArchitectureValue> getSupportedArchitectures() {
        List<ArchitectureValue> list = this.mySupportedArchitectures;
        if (list == null) {
            SimulatorDeviceType.j(8);
        }
        return list;
    }

    private static int j(Object object) {
        Number number = object instanceof String ? (Number)Double.parseDouble((String)object) : (Number)((Number)object);
        return number.intValue();
    }

    @NonNls
    public String toString() {
        return "SimulatorDeviceType{myID='" + this.myID + "', myPresentableName='" + this.myPresentableName + "', myModelIdentifier='" + this.myModelIdentifier + "', myMinRuntimeVersion='" + this.myMinRuntimeVersion + "', myMaxRuntimeVersion='" + this.myMaxRuntimeVersion + "', myScale=" + this.myScale + ", myHeight=" + this.myHeight + ", mySupportedDeviceFamilies=" + this.mySupportedDeviceFamilies + ", mySupportedArchitectures=" + this.mySupportedArchitectures + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SimulatorDeviceType simulatorDeviceType = (SimulatorDeviceType)o2;
        if (this.myHeight != simulatorDeviceType.myHeight) {
            return false;
        }
        if (this.myScale != simulatorDeviceType.myScale) {
            return false;
        }
        if (!this.myID.equals(simulatorDeviceType.myID)) {
            return false;
        }
        if (this.myModelIdentifier != null ? !this.myModelIdentifier.equals(simulatorDeviceType.myModelIdentifier) : simulatorDeviceType.myModelIdentifier != null) {
            return false;
        }
        if (this.myMaxRuntimeVersion != null ? !this.myMaxRuntimeVersion.equals(simulatorDeviceType.myMaxRuntimeVersion) : simulatorDeviceType.myMaxRuntimeVersion != null) {
            return false;
        }
        if (this.myMinRuntimeVersion != null ? !this.myMinRuntimeVersion.equals(simulatorDeviceType.myMinRuntimeVersion) : simulatorDeviceType.myMinRuntimeVersion != null) {
            return false;
        }
        if (!this.mySupportedArchitectures.equals(simulatorDeviceType.mySupportedArchitectures)) {
            return false;
        }
        return this.mySupportedDeviceFamilies.equals(simulatorDeviceType.mySupportedDeviceFamilies);
    }

    public int hashCode() {
        int n2 = this.myID.hashCode();
        n2 = 31 * n2 + (this.myModelIdentifier != null ? this.myModelIdentifier.hashCode() : 0);
        n2 = 31 * n2 + (this.myMinRuntimeVersion != null ? this.myMinRuntimeVersion.hashCode() : 0);
        n2 = 31 * n2 + (this.myMaxRuntimeVersion != null ? this.myMaxRuntimeVersion.hashCode() : 0);
        n2 = 31 * n2 + this.myScale;
        n2 = 31 * n2 + this.myHeight;
        n2 = 31 * n2 + this.mySupportedDeviceFamilies.hashCode();
        n2 = 31 * n2 + this.mySupportedArchitectures.hashCode();
        return n2;
    }

    private static String j(@NotNull String string) {
        if (string == null) {
            SimulatorDeviceType.j(9);
        }
        if (!string.endsWith(SIM_DEVICE_TYPE_EXTENSION)) {
            return string;
        }
        return string.substring(0, string.length() - SIM_DEVICE_TYPE_EXTENSION.length());
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFamilies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "architectures";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorDeviceType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorDeviceType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedDeviceFamilies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedArchitectures";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeSimDeviceTypeExtension";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static class VersionRange {
        private final String versionMin;
        private final String versionMax;

        private VersionRange(String versionMin, String versionMax) {
            this.versionMin = versionMin;
            this.versionMax = versionMax;
        }

        boolean include(String version) {
            return SimulatorConfiguration.isVersionBetween(version, this.versionMin, this.versionMax);
        }
    }
}

