/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.simulatorSupport;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.apple.sdk.ArchitectureValue;
import com.jetbrains.cidr.execution.simulatorSupport.SimulatorRuntime;
import com.jetbrains.cidr.xcode.XCLog;
import com.jetbrains.cidr.xcode.frameworks.ApplePlatform;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimulatorConfiguration {
    public static final int IPHONE_FAMILY = 1;
    public static final int IPAD_FAMILY = 2;
    public static final int TV_FAMILY = 3;
    public static final int WATCH_FAMILY = 4;
    public static final int VISION_FAMILY = 7;
    private static final Map<Integer, ApplePlatform.Type> FAMILY_TO_PLATFORM_TYPE_MAPPING = new LinkedHashMap<Integer, ApplePlatform.Type>(){
        {
            this.put(1, ApplePlatform.Type.IOS_SIMULATOR);
            this.put(2, ApplePlatform.Type.IOS_SIMULATOR);
            this.put(3, ApplePlatform.Type.TVOS_SIMULATOR);
            this.put(4, ApplePlatform.Type.WATCH_SIMULATOR);
            this.put(7, ApplePlatform.Type.VISION_SIMULATOR);
        }
    };

    @NotNull
    public abstract String getName();

    @Nullable
    public abstract String getMinRuntimeVersion();

    @Nullable
    public abstract String getMaxRuntimeVersion();

    @NotNull
    public abstract String getVersion();

    @Nullable
    public abstract String getBuildVersion();

    public abstract int getScale();

    public abstract int getHeight();

    @NotNull
    public abstract String getUDID();

    public int getLaunchDeviceFamily() {
        return Collections.max(this.getSupportedDeviceFamilies());
    }

    public abstract Set<Integer> getSupportedDeviceFamilies();

    @NotNull
    public abstract SimulatorRuntime getRuntime();

    @NotNull
    public abstract File getSimulatorDir();

    @NotNull
    public ArchitectureValue getLaunchArchitecture() {
        List<ArchitectureValue> list = this.getSupportedArchitectures();
        ArrayList<ArchitectureValue> arrayList = new ArrayList<ArchitectureValue>(list);
        arrayList.removeAll((Collection<?>)ArchitectureValue.KNOWN_HOST_ARCHS);
        if (!arrayList.isEmpty()) {
            XCLog.LOG.warn("Unknown simulator architectures: " + StringUtil.join(arrayList, (String)", ") + "\n\t for " + this);
            ArchitectureValue architectureValue = (ArchitectureValue)arrayList.get(0);
            if (architectureValue == null) {
                SimulatorConfiguration.j(0);
            }
            return architectureValue;
        }
        if (list.contains(ArchitectureValue.HOST_ARCH)) {
            ArchitectureValue architectureValue = ArchitectureValue.HOST_ARCH;
            if (architectureValue == null) {
                SimulatorConfiguration.j(1);
            }
            return architectureValue;
        }
        ArchitectureValue architectureValue = this.getSupportedArchitectures().get(0);
        if (architectureValue == null) {
            SimulatorConfiguration.j(2);
        }
        return architectureValue;
    }

    public abstract List<ArchitectureValue> getSupportedArchitectures();

    @Nullable
    public ArchitectureValue getRunArchitectureIfCompatible(@NotNull Collection<Integer> applicationDeviceFamilies, @NotNull Collection<ArchitectureValue> applicationArchitectures) {
        if (applicationDeviceFamilies == null) {
            SimulatorConfiguration.j(3);
        }
        if (applicationArchitectures == null) {
            SimulatorConfiguration.j(4);
        }
        if (!SimulatorConfiguration.isVersionBetween(this.getVersion(), this.getMinRuntimeVersion(), this.getMaxRuntimeVersion())) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getSupportedDeviceFamilies());
        arrayList.retainAll(applicationDeviceFamilies);
        if (arrayList.isEmpty()) {
            return null;
        }
        ArrayList<ArchitectureValue> arrayList2 = new ArrayList<ArchitectureValue>(this.getSupportedArchitectures());
        arrayList2.retainAll(applicationArchitectures);
        return (ArchitectureValue)ContainerUtil.getFirstItem(arrayList2);
    }

    public static boolean isVersionBetween(String versionToCheck, String minVersion, String maxVersion) {
        return !(minVersion != null && StringUtil.compareVersionNumbers((String)versionToCheck, (String)minVersion) < 0 || maxVersion != null && StringUtil.compareVersionNumbers((String)versionToCheck, (String)maxVersion) > 0);
    }

    @Nullable
    public static ApplePlatform.Type getPlatformTypeForFamily(int family) {
        return FAMILY_TO_PLATFORM_TYPE_MAPPING.get(family);
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationDeviceFamilies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationArchitectures";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchArchitecture";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/simulatorSupport/SimulatorConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRunArchitectureIfCompatible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

