/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.deviceSupport;

import com.google.common.collect.ImmutableSet;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CocoaCommonBundle;
import com.jetbrains.cidr.OCPathManager;
import com.jetbrains.cidr.execution.JBDeviceFramework;
import com.jetbrains.cidr.execution.deviceSupport.AMDevice;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceException;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceListener;
import com.jetbrains.cidr.execution.deviceSupport.OCDeviceLog;
import com.jetbrains.cidr.xcode.Xcode;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.PrintFormat;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class AMDeviceManager {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Device Support");
    public static final Topic<AMDeviceListener> DEVICE_LISTENER_TOPIC = Topic.create((String)"Apple Mobile Devices observation", AMDeviceListener.class);
    private final Callback DEVICE_ATTACHED = new Callback(){

        public void callback(ID self, Pointer selector, ID deviceInfo, boolean visible) {
            AMDevice aMDevice = new AMDevice(deviceInfo, visible);
            AMDeviceManager.this.myConnectedDevices.add(aMDevice);
            AMDeviceManager.j().deviceAttached(aMDevice);
            Notification notification = AMDeviceManager.this.myLastMountErrorNotification;
            if (notification != null) {
                notification.expire();
                AMDeviceManager.this.myLastMountErrorNotification = null;
            }
        }
    };
    private final Callback DEVICE_DETACHED = new Callback(){

        public void callback(ID self, Pointer selector, ID deviceInfo) {
            AMDevice aMDevice = new AMDevice(deviceInfo, false);
            AMDeviceManager.this.myConnectedDevices.remove(aMDevice);
            AMDeviceManager.j().deviceDetached(aMDevice);
        }
    };
    private final Callback DEVICE_VISIBILITY_UPDATED = new Callback(){

        public void callback(ID self, Pointer selector, ID deviceInfo, boolean visible) {
            AMDevice aMDevice = new AMDevice(deviceInfo, visible);
            AMDeviceManager.this.myConnectedDevices.remove(aMDevice);
            AMDeviceManager.this.myConnectedDevices.add(aMDevice);
            AMDeviceManager.j().deviceVisibilityUpdated(aMDevice);
        }
    };
    private final Callback DEVICE_PASSCODE_STATUS_UPDATED = new Callback(){

        public void callback(ID self, Pointer selector, ID deviceInfo, boolean passcodeLocked) {
            AMDevice aMDevice = new AMDevice(deviceInfo, false);
            AMDeviceManager.j().devicePasscodeStatusChanged(aMDevice, passcodeLocked);
        }
    };
    private final Callback IMAGE_MOUNT_FAILED = new Callback(){

        public void callback(ID self, Pointer selector, ID error, ID device, boolean wireless) {
            AMDeviceManager.this.j(error, new AMDevice(device, false), wireless);
        }
    };
    private static final Callback JB_DEVICE_LOG = new Callback(){

        public void callback(ID self, Pointer selector, ID message2) {
            OCDeviceLog.LOG.debug(Foundation.toStringViaUTF8((ID)message2));
        }
    };
    private static final Callback PING = new Callback(){

        public void callback(ID self, Pointer selector) {
        }
    };
    private final Set<AMDevice> myConnectedDevices = ConcurrentCollectionFactory.createConcurrentSet();
    private volatile Notification myLastMountErrorNotification;

    public AMDeviceManager() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> JBDeviceFramework.getInstance());
    }

    private static AMDeviceListener j() {
        return (AMDeviceListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DEVICE_LISTENER_TOPIC);
    }

    @Nullable
    public static File findSymbolsDirectoryOrShowError(@NotNull AMDevice device) {
        if (device == null) {
            AMDeviceManager.j(0);
        }
        List<File> list = AMDeviceManager.j(device.getDeviceType());
        String string = device.getCpuArchitecture();
        String string2 = device.getProductType();
        String string3 = device.getProductVersion();
        String string4 = device.getBuildVersion();
        for (File file2 : list) {
            File file3 = AMDeviceManager.j(file2, string2, string3, string4, string);
            if (file3 == null) continue;
            return file3;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            String string = StringUtil.notNullize((String)device.getOSVersion(), (String)"unknown");
            String string2 = new HtmlBuilder().append(CocoaCommonBundle.message("failed.to.lookup.device.support.symbols.description.0", string)).br().append(CocoaCommonBundle.message("failed.to.lookup.device.support.symbols.description.1", new Object[0])).br().append(CocoaCommonBundle.message("failed.to.lookup.device.support.symbols.description.2", new Object[0])).toString();
            NOTIFICATION_GROUP.createNotification(CocoaCommonBundle.message("failed.to.lookup.device.support.symbols", new Object[0]), string2, NotificationType.WARNING).notify(null);
        });
        return null;
    }

    @NotNull
    private static List<File> j(@NotNull AMDevice.Type type) {
        if (type == null) {
            AMDeviceManager.j(1);
        }
        Pair<String, String> pair2 = AMDeviceManager.getUserAndSystemDeviceSupportDirectoryNames(type);
        List<File> list = Arrays.asList(new File(OCPathManager.getUserLibraryDir(), (String)pair2.first), new File(Xcode.getInstance().getBaseFile(), (String)pair2.second));
        if (list == null) {
            AMDeviceManager.j(2);
        }
        return list;
    }

    @Nullable
    private static File j(@NotNull File file2, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        if (file2 == null) {
            AMDeviceManager.j(3);
        }
        File file3 = null;
        if (string2 != null && string3 != null) {
            if (string != null) {
                if (string4 != null) {
                    file3 = AMDeviceManager.j(file2, "%s %s (%s) %s", string, string2, string3, string4);
                }
                if (file3 == null) {
                    file3 = AMDeviceManager.j(file2, "%s %s (%s)", new Object[]{string, string2, string3});
                }
            }
            if (file3 == null && string4 != null) {
                file3 = AMDeviceManager.j(file2, "%s (%s) %s", new Object[]{string2, string3, string4});
            }
            if (file3 == null) {
                file3 = AMDeviceManager.j(file2, "%s (%s)", string2, string3);
            }
        }
        return file3;
    }

    @Nullable
    private static File j(@NotNull File file2, @NotNull @NonNls @PrintFormat String string, Object ... objectArray) {
        if (file2 == null) {
            AMDeviceManager.j(4);
        }
        if (string == null) {
            AMDeviceManager.j(5);
        }
        if (objectArray == null) {
            AMDeviceManager.j(6);
        }
        String string2 = String.format(Locale.US, string, objectArray);
        File file3 = new File(FileUtil.join((String[])new String[]{file2.getAbsolutePath(), string2, "Symbols"}));
        File file4 = file3.getAbsoluteFile();
        if (file3.exists()) {
            OCDeviceLog.LOG.debug("Found device support symbols in ", new Object[]{file4});
            return file3;
        }
        OCDeviceLog.LOG.debug("Failed to lookup device support symbols in ", new Object[]{file4});
        return null;
    }

    public static @NotNull Pair<@NonNls String, @NonNls String> getUserAndSystemDeviceSupportDirectoryNames(@NotNull AMDevice.Type type) {
        if (type == null) {
            AMDeviceManager.j(7);
        }
        if (type.isTv()) {
            Pair pair2 = Pair.create((Object)"/Developer/Xcode/tvOS DeviceSupport/", (Object)"/Platforms/AppleTVOS.platform/DeviceSupport/");
            if (pair2 == null) {
                AMDeviceManager.j(8);
            }
            return pair2;
        }
        if (type.isWatch()) {
            Pair pair3 = Pair.create((Object)"/Developer/Xcode/watchOS DeviceSupport/", (Object)"/Platforms/WatchOS.platform/DeviceSupport/");
            if (pair3 == null) {
                AMDeviceManager.j(9);
            }
            return pair3;
        }
        Pair pair4 = Pair.create((Object)"/Developer/Xcode/iOS DeviceSupport/", (Object)"/Platforms/iPhoneOS.platform/DeviceSupport/");
        if (pair4 == null) {
            AMDeviceManager.j(10);
        }
        return pair4;
    }

    @NotNull
    public ID createServiceDelegate() {
        ID iD = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)"JBDeviceManagerObserver");
        Foundation.addMethod((ID)iD, (Pointer)Foundation.createSelector((String)"deviceAttached:isVisible:"), (Callback)this.DEVICE_ATTACHED, (String)"v@:@B");
        Foundation.addMethod((ID)iD, (Pointer)Foundation.createSelector((String)"deviceDetached:"), (Callback)this.DEVICE_DETACHED, (String)"v@:@");
        Foundation.addMethod((ID)iD, (Pointer)Foundation.createSelector((String)"device:passcodeStatusUpdated:"), (Callback)this.DEVICE_PASSCODE_STATUS_UPDATED, (String)"v@:@B");
        Foundation.addMethod((ID)iD, (Pointer)Foundation.createSelector((String)"deviceVisibilityUpdated:isVisible:"), (Callback)this.DEVICE_VISIBILITY_UPDATED, (String)"v@:@B");
        Foundation.addMethod((ID)iD, (Pointer)Foundation.createSelector((String)"mountFailedWithError:forDevice:isWireless:"), (Callback)this.IMAGE_MOUNT_FAILED, (String)"v@:@@B");
        Foundation.addMethod((ID)iD, (Pointer)Foundation.createSelector((String)"jbDeviceLog:"), (Callback)JB_DEVICE_LOG, (String)"v@:@");
        Foundation.addMethod((ID)iD, (Pointer)Foundation.createSelector((String)"ping"), (Callback)PING, (String)"v@:");
        Foundation.addProtocol((ID)iD, (ID)Foundation.getProtocol((String)"JBDeviceClientProtocol"));
        Foundation.registerObjcClassPair((ID)iD);
        ID iD2 = Foundation.invoke((ID)Foundation.invoke((ID)iD, (String)"alloc", (Object[])new Object[0]), (String)"init", (Object[])new Object[0]);
        if (iD2 == null) {
            AMDeviceManager.j(11);
        }
        return iD2;
    }

    @NotNull
    public static AMDeviceManager getInstance() {
        AMDeviceManager aMDeviceManager = (AMDeviceManager)ApplicationManager.getApplication().getService(AMDeviceManager.class);
        if (aMDeviceManager == null) {
            AMDeviceManager.j(12);
        }
        return aMDeviceManager;
    }

    @Nullable
    public AMDevice getDevice(String deviceID) {
        for (AMDevice aMDevice : this.getDevices()) {
            if (!aMDevice.getDeviceIdentifier().equals(deviceID)) continue;
            return aMDevice;
        }
        return null;
    }

    public List<AMDevice> getDevices() {
        return this.getMatchingDevices(null, null);
    }

    public List<AMDevice> getMatchingDevices(@Nullable AMDevice.Type type, @Nullable String minVersion) {
        List list = ContainerUtil.sorted((Collection)ContainerUtil.filter(this.myConnectedDevices, aMDevice -> {
            AMDevice.Type type2 = aMDevice.getDeviceType();
            return aMDevice.isVisible() && (type == null || type == AMDevice.Type.IOS_ANY && type2.isIOS() || type == type2) && (minVersion == null || AMDeviceManager.isProductVersionNewer(minVersion, aMDevice));
        }), (aMDevice, aMDevice2) -> StringUtil.naturalCompare((String)aMDevice.getName(), (String)aMDevice2.getName()));
        return list;
    }

    public static boolean isProductVersionNewer(String minVersion, AMDevice device) {
        if (minVersion == null) {
            return true;
        }
        String string = device.getOSVersion();
        List list = StringUtil.findMatches((String)string, (Pattern)Pattern.compile("(.+) *(\\(.+\\))*"));
        if (!list.isEmpty()) {
            String string2 = (String)list.get(0);
            return StringUtil.compareVersionNumbers((String)minVersion, (String)string2) <= 0;
        }
        return false;
    }

    @Nullable
    public String selectSuitableArchitecture(@NotNull AMDevice device, @NotNull List<String> applicationArchitectures) {
        if (device == null) {
            AMDeviceManager.j(13);
        }
        if (applicationArchitectures == null) {
            AMDeviceManager.j(14);
        }
        return AMDeviceManager.selectSuitableArchitecture(this.getDeviceArchitecture(device), applicationArchitectures);
    }

    @Nullable
    public static String selectSuitableArchitecture(@NotNull String deviceArchitecture, @NotNull List<String> applicationArchitectures) {
        int n2;
        if (deviceArchitecture == null) {
            AMDeviceManager.j(15);
        }
        if (applicationArchitectures == null) {
            AMDeviceManager.j(16);
        }
        if (applicationArchitectures.contains(deviceArchitecture)) {
            return deviceArchitecture;
        }
        Object object = AMDeviceDatabase.ALLOWED_ARCHS_DESCENDING_BY_DEVICE_ARCH.get(deviceArchitecture);
        if (object == null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                OCDeviceLog.LOG.error("Unknown device architecture " + deviceArchitecture + ". We may select wrong run/build compatible architecture.");
            }
            object = AMDeviceDatabase.ARCHS_DESCENDING.asList();
        }
        if ((n2 = object.indexOf(deviceArchitecture)) != -1) {
            object = object.subList(n2, object.size());
        }
        return AMDeviceManager.j((Collection<String>)object, applicationArchitectures);
    }

    @Nullable
    public static String selectSuitableFallbackArchitecture(@NotNull List<String> applicationArchitectures) {
        if (applicationArchitectures == null) {
            AMDeviceManager.j(17);
        }
        return AMDeviceManager.j(AMDeviceDatabase.ARCHS_DESCENDING, applicationArchitectures);
    }

    @Nullable
    private static String j(@NotNull Collection<String> collection, @NotNull List<String> list) {
        if (collection == null) {
            AMDeviceManager.j(18);
        }
        if (list == null) {
            AMDeviceManager.j(19);
        }
        for (String string : collection) {
            if (!list.contains(string)) continue;
            return string;
        }
        return null;
    }

    @NotNull
    public static Set<String> getAllDeviceArchitectures() {
        ImmutableSet<String> immutableSet = AMDeviceDatabase.ARCHS_DESCENDING;
        if (immutableSet == null) {
            AMDeviceManager.j(20);
        }
        return immutableSet;
    }

    @NotNull
    public String getDeviceArchitecture(@NotNull AMDevice device) {
        String string;
        if (device == null) {
            AMDeviceManager.j(21);
        }
        OCDeviceLog.LOG.assertTrue((string = device.getCpuArchitecture()) != null);
        String string2 = string;
        if (string2 == null) {
            AMDeviceManager.j(22);
        }
        return string2;
    }

    private void j(ID iD, AMDevice aMDevice, boolean bl) {
        int n2 = Foundation.invoke((ID)iD, (String)"code", (Object[])new Object[0]).intValue();
        OCDeviceLog.LOG.warn(AMDeviceException.getLocalizedDescription(iD));
        try {
            String string;
            String string2 = !bl && (n2 == 10003 || n2 == -402652958 || n2 == -402653183 && aMDevice.isPasscodeLocked()) ? new HtmlBuilder().append(CocoaCommonBundle.message("device.locked.message.0", new Object[0])).br().br().append(CocoaCommonBundle.message("device.locked.message.1", new Object[0])).toString() : (n2 == 8 ? new HtmlBuilder().append(CocoaCommonBundle.message("developer.mode.disabled.0", new Object[0])).br().br().append(CocoaCommonBundle.message("developer.mode.disabled.1", new Object[0])).toString() : null);
            if (string2 != null && (string = aMDevice.getName()) != null) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    this.myLastMountErrorNotification = NOTIFICATION_GROUP.createNotification(string, string2, NotificationType.WARNING);
                    this.myLastMountErrorNotification.notify(null);
                });
            }
        }
        catch (AMDeviceException aMDeviceException) {
            OCDeviceLog.LOG.warn((Throwable)((Object)aMDeviceException));
        }
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 8, 9, 10, 11, 12, 20, 22 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceType";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/deviceSupport/AMDeviceManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNameFormat";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationArchitectures";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceArchitecture";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedArchitectures";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/deviceSupport/AMDeviceManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPossibleDeviceSupportDirectories";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAndSystemDeviceSupportDirectoryNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createServiceDelegate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDeviceArchitectures";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceArchitecture";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSymbolsDirectoryOrShowError";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectPossibleDeviceSupportDirectories";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExistingSymbolsDirectory";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findSymbolsDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUserAndSystemDeviceSupportDirectoryNames";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "selectSuitableArchitecture";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "selectSuitableFallbackArchitecture";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceArchitecture";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9, 10, 11, 12, 20, 22 -> new IllegalStateException(string);
        };
    }

    private static class AMDeviceDatabase {
        @NonNls
        private static final String arm = "arm";
        @NonNls
        private static final String arm64v8 = "arm64v8";
        @NonNls
        private static final String armv8 = "armv8";
        @NonNls
        private static final String armv5e = "armv5e";
        @NonNls
        private static final String armv5 = "armv5";
        @NonNls
        private static final String armv7f = "armv7f";
        @NonNls
        private static final String armv7k = "armv7k";
        @NonNls
        private static final String armv6 = "armv6";
        @NonNls
        private static final String armv7 = "armv7";
        @NonNls
        private static final String armv7s = "armv7s";
        @NonNls
        private static final String arm64 = "arm64";
        @NonNls
        private static final String arm64_32 = "arm64_32";
        @NonNls
        private static final String arm64e = "arm64e";
        @NonNls
        private static final ImmutableSet<String> ARCHS_DESCENDING = ImmutableSet.of((Object)"arm64e", (Object)"arm64", (Object)"arm64_32", (Object)"armv7s", (Object)"armv7", (Object)"armv6", (Object[])new String[0]);
        private static final Map<@NonNls String, List<@NonNls String>> ALLOWED_ARCHS_DESCENDING_BY_DEVICE_ARCH = Map.ofEntries(Map.entry("arm", List.of("arm")), Map.entry("arm64", List.of("arm64v8", "arm64", "armv8")), Map.entry("arm64_32", List.of("arm64_32")), Map.entry("arm64e", List.of("arm64e", "arm64v8", "arm64", "armv8")), Map.entry("arm64v8", List.of("arm64v8", "arm64", "armv8")), Map.entry("armv5", List.of("armv5e", "armv5", "arm")), Map.entry("armv5e", List.of("armv5e", "armv5", "arm")), Map.entry("armv6", List.of("armv6", "armv5e", "armv5", "arm")), Map.entry("armv7", List.of("armv7", "armv6", "armv5e", "armv5", "arm")), Map.entry("armv7f", List.of("armv7f", "armv7", "armv6", "armv5e", "armv5", "arm")), Map.entry("armv7k", List.of("armv7k", "armv7", "armv6", "armv5e", "armv5", "arm")), Map.entry("armv7s", List.of("armv7s", "armv7", "armv6", "armv5e", "armv5", "arm")), Map.entry("armv8", List.of("arm64v8", "arm64", "armv8")));

        private AMDeviceDatabase() {
        }
    }
}

