/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.deviceSupport;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CocoaCommonBundle;
import com.jetbrains.cidr.FoundationUtil;
import com.jetbrains.cidr.execution.JBDeviceFramework;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceBusyException;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceException;
import com.jetbrains.cidr.execution.deviceSupport.AMDeviceProgressListener;
import com.jetbrains.cidr.execution.deviceSupport.OCDeviceLog;
import com.jetbrains.cidr.xcode.BoolMapper;
import com.jetbrains.cidr.xcode.LongMapper;
import com.jetbrains.cidr.xcode.ObjMapper2;
import com.jetbrains.cidr.xcode.ObjMapper3;
import com.jetbrains.cidr.xcode.XPCServiceConnectionKt;
import com.sun.jna.Callback;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AMDevice {
    private volatile ID myJbDeviceInfo;
    private final boolean myVisible;
    private static final Set<String> UNKNOWN_DEVICE_TYPES = ConcurrentCollectionFactory.createConcurrentSet();

    @NotNull
    private static ID j(@NotNull Callback callback2) {
        if (callback2 == null) {
            AMDevice.j(0);
        }
        ID iD = Foundation.invoke((ID)Foundation.invoke((ID)Foundation.invoke((ID)Foundation.getObjcClass((String)"AppCodeInstallationDelegate"), (String)"alloc", (Object[])new Object[0]), (String)"initWithStatusUpdatedCallback:", (Object[])new Object[]{callback2}), (String)"autorelease", (Object[])new Object[0]);
        if (iD == null) {
            AMDevice.j(1);
        }
        return iD;
    }

    @NotNull
    private static Callback j(final @NotNull AMDeviceProgressListener aMDeviceProgressListener) {
        if (aMDeviceProgressListener == null) {
            AMDevice.j(2);
        }
        return new Callback(){

            public void callback(ID status, int percentComplete) {
                aMDeviceProgressListener.endStage(true, (double)percentComplete / 100.0);
                @NlsSafe String string = Foundation.toStringViaUTF8((ID)status);
                aMDeviceProgressListener.beginStage(string);
            }
        };
    }

    public Type getDeviceType() {
        String string = this.getType();
        Type type = Type.getType(string);
        if (type != null) {
            return type;
        }
        if (UNKNOWN_DEVICE_TYPES.add(string)) {
            OCDeviceLog.LOG.warn("Unknown device type '" + string + "'. Treating as 'iPhone'");
        }
        return Type.IPHONE;
    }

    public AMDevice(ID jbDeviceInfo, boolean visible) {
        this.myJbDeviceInfo = Foundation.invoke((ID)jbDeviceInfo, (String)"retain", (Object[])new Object[0]);
        this.myVisible = visible;
    }

    @Nullable
    @NlsSafe
    public String getOSVersion() {
        return this.j("osVersion");
    }

    public String getProductType() {
        return this.j("productType");
    }

    @NlsSafe
    public String getName() {
        return this.j("name");
    }

    public String getType() {
        String string = this.j("type");
        if (!this.isCoreDevice()) {
            string = Type.AMDEVICE_TYPE_MAP.getOrDefault(string, string);
        }
        return string;
    }

    public String getModelNumber() {
        return this.j("modelNumber");
    }

    public String getSerialNumber() {
        return this.j("serialNumber");
    }

    public ID getSerialNumberNSString() {
        return Foundation.invoke((ID)this.myJbDeviceInfo, (String)"serialNumber", (Object[])new Object[0]);
    }

    public String getDeviceIdentifier() {
        return this.j("deviceIdentifier");
    }

    @Nullable
    public String getCpuArchitecture() {
        return this.j("cpuArchitecture");
    }

    @Nullable
    public String getBuildVersion() {
        return this.j("buildVersion");
    }

    @Nullable
    public String getProductVersion() {
        return this.j("productVersion");
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public boolean hasUsbConnection() {
        return Foundation.invoke((ID)this.myJbDeviceInfo, (String)"hasUsbConnection", (Object[])new Object[0]).byteValue() != 0;
    }

    public boolean isCoreDevice() {
        return Foundation.invoke((ID)this.myJbDeviceInfo, (String)"isCoreDevice", (Object[])new Object[0]).byteValue() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String j(@NotNull @NonNls String string) {
        if (string == null) {
            AMDevice.j(3);
        }
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        try {
            String string2 = Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)this.myJbDeviceInfo, (String)string, (Object[])new Object[0]));
            return string2;
        }
        catch (RuntimeException runtimeException) {
            OCDeviceLog.LOG.warn((Throwable)runtimeException);
        }
        finally {
            nSAutoreleasePool.drain();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppInstallationResult installAppBundle(@NotNull @NonNls String path, AMDeviceProgressListener listener2) throws AMDeviceException {
        if (path == null) {
            AMDevice.j(4);
        }
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        try {
            record TemporaryResult(@Nullable String appPath, @Nullable String appDataContainer, @Nullable AMDeviceException exception) {
            }
            Callback callback2 = AMDevice.j(listener2);
            ID iD4 = AMDevice.j(callback2);
            ObjMapper3 objMapper3 = XPCServiceConnectionKt.ObjMapper3((iD, iD2, iD3) -> new TemporaryResult(Foundation.toStringViaUTF8((ID)iD), Foundation.toStringViaUTF8((ID)iD2), AMDevice.N(iD, iD3)));
            TemporaryResult temporaryResult = (TemporaryResult)JBDeviceFramework.getValue(objMapper3, 0, "installAppBundle:onDevice:delegate:reply:", Foundation.nsString((String)path), this.getSerialNumberNSString(), iD4);
            if (temporaryResult.exception != null) {
                throw temporaryResult.exception;
            }
            AppInstallationResult appInstallationResult = new AppInstallationResult(Objects.requireNonNull(temporaryResult.appPath), Objects.requireNonNull(temporaryResult.appDataContainer));
            return appInstallationResult;
        }
        finally {
            nSAutoreleasePool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transferDirectoryToApplicationSandbox(@NotNull @NonNls String path, @NotNull @NonNls String pathOnDevice, @NotNull @NonNls String bundleId) throws AMDeviceException {
        if (path == null) {
            AMDevice.j(5);
        }
        if (pathOnDevice == null) {
            AMDevice.j(6);
        }
        if (bundleId == null) {
            AMDevice.j(7);
        }
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        try {
            ObjMapper2 objMapper2 = XPCServiceConnectionKt.ObjMapper2((iD, iD2) -> Pair.create((Object)Foundation.toStringViaUTF8((ID)iD), (Object)((Object)(JBDeviceFramework.isNilOrNo(iD2) ? null : new AMDeviceException((ID)iD2)))));
            Pair pair2 = (Pair)JBDeviceFramework.getValue(objMapper2, 0, "transferOnDevice:path:pathOnDevice:toSandboxOfApplicationWithIdentifier:reply:", this.getSerialNumberNSString(), Foundation.nsString((String)path), Foundation.nsString((String)pathOnDevice), Foundation.nsString((String)bundleId));
            if (pair2.second != null) {
                throw (AMDeviceException)((Object)pair2.second);
            }
            String string = (String)pair2.first;
            return string;
        }
        finally {
            nSAutoreleasePool.drain();
        }
    }

    @NotNull
    private static ObjMapper2<AMDeviceException> j() {
        ObjMapper2<AMDeviceException> objMapper2 = XPCServiceConnectionKt.ObjMapper2((iD, iD2) -> AMDevice.N(iD, iD2));
        if (objMapper2 == null) {
            AMDevice.j(8);
        }
        return objMapper2;
    }

    @Nullable
    private static AMDeviceException N(ID iD, ID iD2) {
        if (!JBDeviceFramework.isNilOrNo(iD2)) {
            return new AMDeviceException(iD2);
        }
        if (JBDeviceFramework.isNilOrNo(iD)) {
            return new AMDeviceException(CocoaCommonBundle.message("dialog.message.unknown.error", new Object[0]));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(@NotNull String pathOnDevice, @NotNull String pathOnMac, boolean removeOnDevice, @NotNull String bundleId) throws AMDeviceException {
        if (pathOnDevice == null) {
            AMDevice.j(9);
        }
        if (pathOnMac == null) {
            AMDevice.j(10);
        }
        if (bundleId == null) {
            AMDevice.j(11);
        }
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        try {
            ObjMapper2<AMDeviceException> objMapper2 = AMDevice.j();
            AMDeviceException aMDeviceException = JBDeviceFramework.getValue(objMapper2, 0, "downloadFromDevice:file:toPath:fromContainerWithIdentifier:removeOnDevice:reply:", this.getSerialNumberNSString(), Foundation.nsString((String)pathOnDevice), Foundation.nsString((String)pathOnMac), Foundation.nsString((String)bundleId), removeOnDevice);
            if (aMDeviceException != null) {
                throw aMDeviceException;
            }
        }
        finally {
            nSAutoreleasePool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ProcessInfo> getRunningProcesses() throws AMDeviceException {
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        ObjMapper2 objMapper2 = XPCServiceConnectionKt.ObjMapper2((iD2, iD3) -> {
            List list = FoundationUtil.mapNotNullNSArray(iD2, iD -> {
                Foundation.NSDictionary nSDictionary = new Foundation.NSDictionary(iD);
                int n2 = Foundation.invoke((ID)nSDictionary.get("pid"), (String)"intValue", (Object[])new Object[0]).intValue();
                String string = Foundation.toStringViaUTF8((ID)nSDictionary.get("name"));
                String string2 = StringUtil.notNullize((String)Foundation.toStringViaUTF8((ID)nSDictionary.get("realAppName")));
                if (n2 == 0 || string == null) {
                    return null;
                }
                return new ProcessInfo(n2, string2, string, "", string2);
            });
            return Pair.create(list, (Object)((Object)(JBDeviceFramework.isNilOrNo(iD3) ? null : new AMDeviceException((ID)iD3))));
        });
        Pair pair2 = (Pair)JBDeviceFramework.getValue(objMapper2, 10, "runningProcessesOnDevice:reply:", this.getSerialNumberNSString());
        if (pair2.second != null) {
            throw (AMDeviceException)((Object)pair2.second);
        }
        List list = (List)pair2.first;
        List list2 = list;
        if (list2 == null) {
            AMDevice.j(12);
        }
        return list2;
        finally {
            nSAutoreleasePool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Pair<Integer, String> startDebugserver() throws AMDeviceException {
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        ObjMapper3 objMapper3 = XPCServiceConnectionKt.ObjMapper3((iD, iD2, iD3) -> Trinity.create((Object)Foundation.invoke((ID)iD, (String)"intValue", (Object[])new Object[0]).intValue(), (Object)Foundation.toStringViaUTF8((ID)iD2), (Object)((Object)AMDevice.N(iD, iD3))));
        Trinity trinity = (Trinity)JBDeviceFramework.getValue(objMapper3, 35, "startDebugServerOnDevice:reply:", this.getSerialNumberNSString());
        if (trinity.third != null) {
            throw (AMDeviceException)((Object)trinity.third);
        }
        Pair pair2 = Pair.create((Object)((Integer)trinity.first), (Object)((String)trinity.second));
        Pair pair3 = pair2;
        if (pair3 == null) {
            AMDevice.j(13);
        }
        return pair3;
        finally {
            nSAutoreleasePool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateLocation(double latitude, double longitude) {
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        try {
            JBDeviceFramework.invoke("locationSimulationOnDevice:setLatitude:longitude:", this.getSerialNumberNSString(), latitude, longitude);
        }
        finally {
            nSAutoreleasePool.drain();
        }
    }

    public void stopLocationSimulation() {
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        try {
            JBDeviceFramework.invoke("stopLocationSimulationOnDevice:", this.getSerialNumberNSString());
        }
        finally {
            nSAutoreleasePool.drain();
        }
    }

    public void stopDebugserver(int debugServerID) {
        JBDeviceFramework.invoke("stopDebugServerOnDevice:debugServerId:", this.getSerialNumberNSString(), debugServerID);
    }

    public boolean isConnected() {
        try {
            return this.j("isDeviceConnected:reply:", 1);
        }
        catch (AMDeviceException aMDeviceException) {
            OCDeviceLog.LOG.warn((Throwable)((Object)aMDeviceException));
            return false;
        }
    }

    public boolean isLocked() {
        try {
            return this.j("isDeviceLocked:reply:", 1);
        }
        catch (AMDeviceException aMDeviceException) {
            OCDeviceLog.LOG.warn((Throwable)((Object)aMDeviceException));
            return true;
        }
    }

    public boolean isPasscodeLocked() throws AMDeviceException {
        return this.j("isPasscodeLocked:reply:", 1);
    }

    public void lock() throws AMDeviceException {
        this.lock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(boolean ignoreExistingLock) throws AMDeviceException {
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        try {
            boolean bl = JBDeviceFramework.getValue(BoolMapper.INSTANCE, 1, "lockDevice:ignoreExisting:reply:", this.getSerialNumberNSString(), ignoreExistingLock);
            if (!bl) {
                throw new AMDeviceBusyException(this);
            }
        }
        finally {
            nSAutoreleasePool.drain();
        }
    }

    public void unlock() {
        JBDeviceFramework.invoke("unlockDevice:", this.getSerialNumberNSString());
    }

    @NonNls
    public String toString() {
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        String string = Foundation.toStringViaUTF8((ID)Foundation.invoke((ID)this.myJbDeviceInfo, (String)"description", (Object[])new Object[0]));
        nSAutoreleasePool.drain();
        return string != null ? string : "UNKNOWN " + this.myJbDeviceInfo;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AMDevice aMDevice = (AMDevice)o2;
        return this.getDeviceIdentifier().equals(aMDevice.getDeviceIdentifier());
    }

    public int hashCode() {
        return this.getDeviceIdentifier().hashCode();
    }

    protected void finalize() {
        Foundation.invoke((ID)this.myJbDeviceInfo, (String)"release", (Object[])new Object[0]);
        this.myJbDeviceInfo = null;
    }

    public long createPowerAssertion(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            AMDevice.j(14);
        }
        return this.j("createPowerAssertion:reply:", progressIndicator);
    }

    public void releasePowerAssertion(long assertion) {
        if (assertion != 0L && assertion != -1L) {
            JBDeviceFramework.invoke("releasePowerAssertion:", assertion);
        }
    }

    public boolean connect() throws AMDeviceException {
        return this.j("connect:reply:", 0);
    }

    public void disconnect() {
        JBDeviceFramework.invoke("disconnect:", this.getSerialNumberNSString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean j(@NotNull @NonNls String string, int n2) throws AMDeviceException {
        if (string == null) {
            AMDevice.j(15);
        }
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        try {
            boolean bl = JBDeviceFramework.getValue(BoolMapper.INSTANCE, n2, string, this.getSerialNumberNSString());
            return bl;
        }
        finally {
            nSAutoreleasePool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long j(@NotNull @NonNls String string, @NotNull ProgressIndicator progressIndicator) {
        if (string == null) {
            AMDevice.j(16);
        }
        if (progressIndicator == null) {
            AMDevice.j(17);
        }
        Foundation.NSAutoreleasePool nSAutoreleasePool = new Foundation.NSAutoreleasePool();
        try {
            long l2 = JBDeviceFramework.getValueWithProgress(progressIndicator, LongMapper.INSTANCE, string, this.getSerialNumberNSString());
            return l2;
        }
        finally {
            nSAutoreleasePool.drain();
        }
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 8, 12, 13 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusCallback";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/deviceSupport/AMDevice";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceInfoPropertyName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathOnDevice";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathOnMac";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/deviceSupport/AMDevice";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppInstallationDelegate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapper";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningProcesses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugserver";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAppInstallationDelegate";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStatusUpdateCallback";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installAppBundle";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "transferDirectoryToApplicationSandbox";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPowerAssertion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLongCancellable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 12, 13 -> new IllegalStateException(string);
        };
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type IPHONE = new Type("iPhone");
        public static final /* enum */ Type IPAD = new Type("iPad");
        public static final /* enum */ Type IOS_ANY = new Type(null);
        public static final /* enum */ Type TV = new Type("appleTV");
        public static final /* enum */ Type WATCH = new Type("appleWatch");
        public static final /* enum */ Type VISION = new Type("realityDevice");
        private static final Map<String, String> AMDEVICE_TYPE_MAP;
        @Nullable
        private final String nativeType;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String type) {
            this.nativeType = type;
        }

        public boolean isIOS() {
            return this == IPHONE || this == IPAD || this == IOS_ANY;
        }

        public boolean isTv() {
            return this == TV;
        }

        public boolean isWatch() {
            return this == WATCH;
        }

        @Nullable
        @NonNls
        public String getNativeType() {
            return this.nativeType;
        }

        @Nullable
        public static Type getType(@NotNull String nativeType) {
            if (nativeType == null) {
                Type.j(0);
            }
            return (Type)((Object)ContainerUtil.find((Object[])Type.values(), type -> nativeType.equals(type.getNativeType())));
        }

        private static /* synthetic */ Type[] j() {
            return new Type[]{IPHONE, IPAD, IOS_ANY, TV, WATCH, VISION};
        }

        static {
            $VALUES = Type.j();
            AMDEVICE_TYPE_MAP = Map.of("AppleTV", "appleTV", "Watch", "appleWatch");
        }

        private static /* synthetic */ void j(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeType", "com/jetbrains/cidr/execution/deviceSupport/AMDevice$Type", "getType"));
        }
    }

    public record AppInstallationResult(@NotNull String appPath, @NotNull String appDataContainer) {
        @NotNull
        private final String appPath;
        @NotNull
        private final String appDataContainer;

        public AppInstallationResult(@NotNull String appPath, @NotNull String appDataContainer) {
            if (appPath == null) {
                AppInstallationResult.j(0);
            }
            if (appDataContainer == null) {
                AppInstallationResult.j(1);
            }
        }

        @NotNull
        public String appPath() {
            String string = this.appPath;
            if (string == null) {
                AppInstallationResult.j(2);
            }
            return string;
        }

        @NotNull
        public String appDataContainer() {
            String string = this.appDataContainer;
            if (string == null) {
                AppInstallationResult.j(3);
            }
            return string;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "appPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "appDataContainer";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/deviceSupport/AMDevice$AppInstallationResult";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/deviceSupport/AMDevice$AppInstallationResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appDataContainer";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

