/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.system.HostMachine;
import com.pty4j.unix.Pty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessOutputReaders {
    private final AtomicReference<MyOutputReader[]> myReaders;
    private final String myPresentableName;
    private final Charset myCharset;
    private final boolean myEmulateTerminal;

    public ProcessOutputReaders(@NotNull HostMachine host, @NotNull String presentableName, @NotNull Charset charset, boolean usePtyOnUnix) throws ExecutionException {
        if (host == null) {
            ProcessOutputReaders.j(0);
        }
        if (presentableName == null) {
            ProcessOutputReaders.j(1);
        }
        if (charset == null) {
            ProcessOutputReaders.j(2);
        }
        this(host, presentableName, charset, usePtyOnUnix, false);
    }

    public ProcessOutputReaders(@NotNull HostMachine host, @NotNull String presentableName, @NotNull Charset charset, boolean usePtyOnUnix, boolean emulateTerminal) throws ExecutionException {
        if (host == null) {
            ProcessOutputReaders.j(3);
        }
        if (presentableName == null) {
            ProcessOutputReaders.j(4);
        }
        if (charset == null) {
            ProcessOutputReaders.j(5);
        }
        this.myReaders = new AtomicReference<MyOutputReader[]>(new MyOutputReader[2]);
        this.myPresentableName = presentableName;
        this.myCharset = charset;
        this.myEmulateTerminal = emulateTerminal;
        OS oS = host.getOSType().toOS();
        try {
            MyOutputReader[] myOutputReaderArray = this.getReaders();
            if (oS == OS.Windows) {
                myOutputReaderArray[0] = new MyWinPipeOutputReader(ProcessOutputTypes.STDOUT);
                if (!emulateTerminal) {
                    myOutputReaderArray[1] = new MyWinPipeOutputReader(ProcessOutputTypes.STDERR);
                }
            } else if (usePtyOnUnix && host.isRemote()) {
                myOutputReaderArray[0] = new MyRemoteUnixPipeOutputReader(host, ProcessOutputTypes.STDOUT);
                myOutputReaderArray[1] = new MyRemoteUnixPipeOutputReader(host, ProcessOutputTypes.STDERR);
            } else if (usePtyOnUnix) {
                myOutputReaderArray[0] = new MyUnixPtyOutputReader(this, ProcessOutputTypes.STDOUT);
                myOutputReaderArray[1] = new MyUnixPtyOutputReader(this, ProcessOutputTypes.STDERR);
            } else {
                myOutputReaderArray[0] = new MyFileOutputReader(this, ProcessOutputTypes.STDOUT);
                myOutputReaderArray[1] = new MyFileOutputReader(this, ProcessOutputTypes.STDERR);
            }
            myOutputReaderArray[0].start();
            if (myOutputReaderArray[1] != null) {
                myOutputReaderArray[1].start();
            }
        }
        catch (IOException iOException) {
            throw new ExecutionException("Cannot create output file", (Throwable)iOException);
        }
    }

    public String getOutFileAbsolutePath() throws ExecutionException {
        return this.getReader(0).getFileAbsolutePath();
    }

    public String getErrFileAbsolutePath() throws ExecutionException {
        return this.getReader(1).getFileAbsolutePath();
    }

    protected MyOutputReader[] getReaders() {
        return this.myReaders.get();
    }

    protected MyOutputReader getReader(int num) throws ExecutionException {
        MyOutputReader[] myOutputReaderArray = this.getReaders();
        if (ArrayUtil.isEmpty((Object[])myOutputReaderArray)) {
            throw new ExecutionException("Reader is closed");
        }
        return myOutputReaderArray[num];
    }

    protected boolean doWaitFor(MyOutputReader[] readers) {
        for (MyOutputReader myOutputReader : readers) {
            try {
                if (myOutputReader == null) continue;
                myOutputReader.waitFor();
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                return false;
            }
        }
        return true;
    }

    protected boolean doWaitFor(MyOutputReader[] readers, long timeout, TimeUnit unit) {
        for (MyOutputReader myOutputReader : readers) {
            try {
                if (myOutputReader == null) continue;
                myOutputReader.waitFor(timeout, unit);
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                return false;
            }
            catch (TimeoutException timeoutException) {
                return false;
            }
        }
        return true;
    }

    public boolean waitFor() {
        return this.doWaitFor(this.getReaders());
    }

    public boolean waitFor(long timeout, TimeUnit unit) {
        return this.doWaitFor(this.getReaders(), timeout, unit);
    }

    public void close() {
        MyOutputReader[] myOutputReaderArray;
        for (MyOutputReader myOutputReader : myOutputReaderArray = this.myReaders.getAndSet(new MyOutputReader[0])) {
            if (myOutputReader == null) continue;
            myOutputReader.stop();
        }
        this.doWaitFor(myOutputReaderArray);
    }

    protected abstract void onTextAvailable(@NotNull String var1, @NotNull Key<?> var2);

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "host";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "presentableName";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "charset";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class MyOutputReader
    extends BaseOutputReader {
        @NotNull
        private final Key<?> myType;
        @NotNull
        private final String myFileAbsolutePath;

        protected MyOutputReader(@NotNull Key<?> type, @NotNull String fileAbsolutePath, InputStream stream, BaseDataReader.SleepingPolicy policy) {
            if (type == null) {
                MyOutputReader.j(0);
            }
            if (fileAbsolutePath == null) {
                MyOutputReader.j(1);
            }
            if (stream == null) {
                MyOutputReader.j(2);
            }
            super(stream, ProcessOutputReaders.this.myCharset, (BaseOutputReader.Options)new ReaderOptions(policy));
            this.myType = type;
            this.myFileAbsolutePath = fileAbsolutePath;
        }

        public void start() {
            this.start(ProcessOutputReaders.this.myPresentableName);
        }

        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                MyOutputReader.j(3);
            }
            if (!ProcessOutputReaders.this.myEmulateTerminal) {
                text = StringUtil.trimEnd((String)text, (String)"\r");
                text = StringUtil.convertLineSeparators((String)text);
            }
            ProcessOutputReaders.this.onTextAvailable(text, this.myType);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                MyOutputReader.j(4);
            }
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(runnable);
            if (future2 == null) {
                MyOutputReader.j(5);
            }
            return future2;
        }

        public void stop() {
            super.stop();
            if (this.mySleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING) {
                try {
                    this.waitFor(this.mySleepingPolicy.getTimeToSleep(false), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException exception) {
                    try {
                        this.close();
                    }
                    catch (IOException iOException) {
                        CidrLogService.LOG.error((Throwable)iOException);
                    }
                }
            }
        }

        @NotNull
        public String getFileAbsolutePath() {
            String string = this.myFileAbsolutePath;
            if (string == null) {
                MyOutputReader.j(6);
            }
            return string;
        }

        private static /* synthetic */ void j(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAbsolutePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyOutputReader";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyOutputReader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileAbsolutePath";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    protected class MyWinPipeOutputReader
    extends MyPipeOutputReader<WinPipe> {
        protected MyWinPipeOutputReader(Key type) throws IOException {
            if (type == null) {
                MyWinPipeOutputReader.w(0);
            }
            super(ProcessOutputReaders.this, (NamedPipe)WinPipe.createInboundPipe(type.toString()), type);
        }

        protected void doRun() {
            try {
                if (!((WinPipe)this.myPipe).waitForConnection()) {
                    CidrLogService.LOG.error(String.format("Stream reading can't be initiated: couldn't connect to pipe %s. ", ((WinPipe)this.myPipe).getName()));
                    return;
                }
            }
            catch (IOException iOException) {
                CidrLogService.LOG.debug((Throwable)iOException);
                try {
                    this.close();
                }
                catch (IOException iOException2) {
                    CidrLogService.LOG.error("Can't close stream", (Throwable)iOException2);
                }
                return;
            }
            super.doRun();
        }

        private static /* synthetic */ void w(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/cidr/execution/ProcessOutputReaders$MyWinPipeOutputReader", "<init>"));
        }
    }

    protected class MyRemoteUnixPipeOutputReader
    extends MyPipeOutputReader<NamedPipe> {
        protected MyRemoteUnixPipeOutputReader(@NotNull HostMachine pipe, Key type) throws IOException, ExecutionException {
            if (pipe == null) {
                MyRemoteUnixPipeOutputReader.w(0);
            }
            if (type == null) {
                MyRemoteUnixPipeOutputReader.w(1);
            }
            super(ProcessOutputReaders.this, pipe.openNamedPipe(), type);
        }

        private static /* synthetic */ void w(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pipe";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyRemoteUnixPipeOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyUnixPtyOutputReader
    extends MyOutputReader {
        final /* synthetic */ ProcessOutputReaders this$0;

        protected MyUnixPtyOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyUnixPtyOutputReader.N(0);
            }
            this(this$0, new Pty(), type);
        }

        protected MyUnixPtyOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull Pty pty, Key type) {
            if (pty == null) {
                MyUnixPtyOutputReader.N(1);
            }
            if (type == null) {
                MyUnixPtyOutputReader.N(2);
            }
            this.this$0 = this$0;
            super(type, pty.getSlaveName(), (InputStream)pty.getInputStream(), BaseDataReader.SleepingPolicy.BLOCKING);
        }

        private static /* synthetic */ void N(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pty";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyUnixPtyOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyFileOutputReader
    extends MyOutputReader {
        @NotNull
        private final File myFileToDelete;
        final /* synthetic */ ProcessOutputReaders this$0;

        protected MyFileOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyFileOutputReader.N(0);
            }
            this(this$0, FileUtil.createTempFile((String)this$0.getClass().getSimpleName(), (String)type.toString(), (boolean)true), type);
        }

        protected MyFileOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull File file2, Key type) throws IOException {
            if (file2 == null) {
                MyFileOutputReader.N(1);
            }
            if (type == null) {
                MyFileOutputReader.N(2);
            }
            this.this$0 = this$0;
            super(type, file2.getAbsolutePath(), new FileInputStream(file2), BaseDataReader.SleepingPolicy.NON_BLOCKING);
            this.myFileToDelete = file2;
        }

        protected void close() throws IOException {
            try {
                super.close();
            }
            finally {
                FileUtil.delete((File)this.myFileToDelete);
            }
        }

        private static /* synthetic */ void N(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyFileOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ReaderOptions
    extends BaseOutputReader.Options {
        private final BaseDataReader.SleepingPolicy myPolicy;

        public ReaderOptions(BaseDataReader.SleepingPolicy policy) {
            this.myPolicy = policy;
        }

        public BaseDataReader.SleepingPolicy policy() {
            return this.myPolicy;
        }

        public boolean splitToLines() {
            return false;
        }
    }

    protected static class MyPipeOutputReader<T extends NamedPipe>
    extends MyOutputReader {
        @NotNull
        protected final T myPipe;
        final /* synthetic */ ProcessOutputReaders this$0;

        protected MyPipeOutputReader(@NotNull T pipe, Key type) throws IOException {
            if (pipe == null) {
                MyPipeOutputReader.N(0);
            }
            if (type == null) {
                MyPipeOutputReader.N(1);
            }
            this.this$0 = this$0;
            super(type, pipe.getName(), pipe.getInputStream(), BaseDataReader.SleepingPolicy.BLOCKING);
            this.myPipe = pipe;
        }

        protected void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.myPipe.close();
            }
        }

        private static /* synthetic */ void N(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pipe";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyPipeOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

