/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrRunProcessUtil {
    public static final int READ_VERSION_TIMEOUT = 10000;

    @NotNull
    public static ProcessOutput runProcess(@NotNull BaseProcessHandler<?> handler, @Nullable ProgressIndicator indicator2, int timeout) {
        if (handler == null) {
            CidrRunProcessUtil.j(0);
        }
        return CidrRunProcessUtil.runProcess(handler, indicator2, timeout);
    }

    @NotNull
    public static ProcessOutput runProcess(@NotNull ProcessHandler handler, @Nullable ProgressIndicator indicator2, int timeout) {
        if (handler == null) {
            CidrRunProcessUtil.j(1);
        }
        ProcessOutput processOutput = CidrRunProcessUtil.j(new CapturingProcessRunner(handler), indicator2, timeout);
        if (processOutput == null) {
            CidrRunProcessUtil.j(2);
        }
        return processOutput;
    }

    private static ProcessOutput j(@NotNull CapturingProcessRunner capturingProcessRunner, @Nullable ProgressIndicator progressIndicator, int n2) {
        if (capturingProcessRunner == null) {
            CidrRunProcessUtil.j(3);
        }
        return progressIndicator == null ? capturingProcessRunner.runProcess(n2) : capturingProcessRunner.runProcess(progressIndicator, n2);
    }

    @Nullable
    public static ProgressIndicator getProgressIndicator() {
        return ProgressIndicatorProvider.getGlobalProgressIndicator();
    }

    @NotNull
    public static ProcessOutput runWithProgress(CapturingProcessHandler handler) {
        return CidrRunProcessUtil.runWithProgress(handler, 0);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull BaseProcessHandler<?> handler, int timeout) {
        if (handler == null) {
            CidrRunProcessUtil.j(4);
        }
        return CidrRunProcessUtil.runWithProgress(handler, timeout);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull ProcessHandler handler, int timeout) {
        ProgressIndicator progressIndicator;
        ProcessOutput processOutput;
        if (handler == null) {
            CidrRunProcessUtil.j(5);
        }
        if ((processOutput = CidrRunProcessUtil.runProcess(handler, progressIndicator = CidrRunProcessUtil.getProgressIndicator(), timeout)).isCancelled()) {
            throw new ProcessCanceledException();
        }
        ProcessOutput processOutput2 = processOutput;
        if (processOutput2 == null) {
            CidrRunProcessUtil.j(6);
        }
        return processOutput2;
    }

    @Nullable
    public static String readOneLineWithProgress(@NotNull GeneralCommandLine commandLine, int timeout) {
        if (commandLine == null) {
            CidrRunProcessUtil.j(7);
        }
        try {
            ProcessOutput processOutput = CidrRunProcessUtil.runWithProgress(new CapturingProcessHandler(commandLine), timeout);
            return (String)ContainerUtil.getFirstItem((List)StringsKt.lines((CharSequence)processOutput.getStdout()));
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    public static void setHasPty(@NotNull OSProcessHandler processHandler, boolean usePty) {
        if (processHandler == null) {
            CidrRunProcessUtil.j(8);
        }
        if (usePty) {
            processHandler.setHasPty(true);
            processHandler.setShouldDestroyProcessRecursively(false);
        }
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrRunProcessUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunProcessUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithProgress";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runWithProgress";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readOneLineWithProgress";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setHasPty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

