/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrExecUtil {
    private static final int ERROR_MESSAGE_WRAP_LENGTH = 80;

    @NotNull
    public static Map<String, String> appendBuildPathVars(@NotNull Map<String, String> env, @Nullable String buildPath) {
        if (env == null) {
            CidrExecUtil.j(0);
        }
        CidrExecUtil.appendSearchPath(env, "DYLD_LIBRARY_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "DYLD_FRAMEWORK_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "__XPC_DYLD_LIBRARY_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "__XPC_DYLD_FRAMEWORK_PATH", buildPath);
        Map<String, String> map = env;
        if (map == null) {
            CidrExecUtil.j(1);
        }
        return map;
    }

    public static void setIfAbsent(@NotNull Map<String, String> env, @NotNull String paramName, @Nullable String value2) {
        if (env == null) {
            CidrExecUtil.j(2);
        }
        if (paramName == null) {
            CidrExecUtil.j(3);
        }
        if (value2 != null && !env.containsKey(paramName)) {
            env.put(paramName, value2);
        }
    }

    public static void appendSearchPath(@NotNull Map<String, String> env, @NotNull @NonNls String paramName, @Nullable String appendPath) {
        if (env == null) {
            CidrExecUtil.j(4);
        }
        if (paramName == null) {
            CidrExecUtil.j(5);
        }
        if (appendPath == null) {
            return;
        }
        Object object = env.get(paramName);
        object = object != null ? (String)object + File.pathSeparator + appendPath : appendPath;
        env.put(paramName, (String)object);
    }

    @Contract(pure=true)
    public static String wrapErrorOutput(@NotNull String str) {
        if (str == null) {
            CidrExecUtil.j(6);
        }
        return CidrExecUtil.wrapErrorOutput(str, 80);
    }

    @Contract(pure=true)
    public static String wrapErrorOutput(@NotNull String str, int wrapLen) {
        if (str == null) {
            CidrExecUtil.j(7);
        }
        String[] stringArray = StringUtil.splitByLinesKeepSeparators((String)str);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i2], " \n\r");
            if (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                stringBuilder.append(string);
                int n2 = string.length();
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    int n3 = string.length();
                    if (n2 + n3 > wrapLen) {
                        stringBuilder.append('\n');
                        n2 = n3;
                    } else {
                        stringBuilder.append(' ');
                        n2 += n3 + 1;
                    }
                    stringBuilder.append(string);
                }
            }
            if (i2 >= stringArray.length - 1) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrExecUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrExecUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "appendBuildPathVars";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendBuildPathVars";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setIfAbsent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendSearchPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrapErrorOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

