/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CocoaCommonBundle;
import com.jetbrains.cidr.xcode.Xcode;
import com.jetbrains.cidr.xcode.XcodeDiscoverer;
import com.jetbrains.cidr.xcode.XcodeInstallation;
import com.jetbrains.cidr.xcode.XcodeSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class XcodeConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private boolean isInitializationReset = true;
    private ComboboxWithBrowseButton myCombo;
    private JBLabel myInfoLabel;
    private JBCheckBox myDownloadCachesCheckBox;

    @NotNull
    public String getId() {
        return "XcodeSettings";
    }

    @Nls
    public String getDisplayName() {
        return CocoaCommonBundle.message("xcode", new Object[0]);
    }

    public String getHelpTopic() {
        return "Settings_Xcode";
    }

    public JComponent createComponent() {
        Object object;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBag gridBag = new GridBag().setDefaultPaddingX(0, 8).setDefaultPaddingY(0, 8).setDefaultAnchor(0, 13).setDefaultAnchor(1, 17).setDefaultWeightX(1, 1.0).setDefaultFill(2);
        this.myDownloadCachesCheckBox = new JBCheckBox(CocoaCommonBundle.message("settings.xcode.download.caches.automatically.title", new Object[0]));
        JPanel jPanel2 = UI.PanelFactory.panel((JComponent)this.myDownloadCachesCheckBox).withComment(CocoaCommonBundle.message("settings.xcode.download.caches.automatically.hint", new Object[0])).createPanel();
        jPanel.add((Component)jPanel2, gridBag.nextLine().coverLine().insets(-1, -1, 8, -1));
        this.myInfoLabel = new JBLabel(UIUtil.ComponentStyle.SMALL);
        this.myCombo = new ComboboxWithBrowseButton();
        this.myCombo.addBrowseFolderListener(CocoaCommonBundle.message("select.xcode.application", new Object[0]), null, null, new FileChooserDescriptor(true, true, false, false, false, false){

            public boolean isFileSelectable(@Nullable VirtualFile file2) {
                return file2 != null && file2.isDirectory() && FileUtil.namesEqual((String)"app", (String)file2.getExtension());
            }
        }, (TextComponentAccessor)new TextComponentAccessor<JComboBox>(){

            public String getText(JComboBox component) {
                XcodeInstallation xcodeInstallation = XcodeConfigurable.this.j();
                return xcodeInstallation != null ? xcodeInstallation.getApplicationFilePath() : null;
            }

            public void setText(JComboBox component, @NotNull String text) {
                if (text == null) {
                    2.j(0);
                }
                XcodeConfigurable.this.j(XcodeDiscoverer.getInstance().getXcodeAppBaseFile(new File(text)).getPath());
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/XcodeConfigurable$2", "setText"));
            }
        });
        this.myCombo.getComboBox().setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    3.j(0);
                }
                if (!(value2 instanceof XcodeInstallation)) {
                    return;
                }
                XcodeInstallation xcodeInstallation = (XcodeInstallation)value2;
                boolean bl = xcodeInstallation.isInstalled();
                boolean bl2 = xcodeInstallation.isSupportedVersion() == null;
                SimpleTextAttributes simpleTextAttributes = bl && bl2 ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES;
                this.append(xcodeInstallation.getDisplayVersion(), simpleTextAttributes);
                if (!bl) {
                    this.append(" ");
                    this.append(CocoaCommonBundle.message("settings.xcode.version.not.found", new Object[0]), simpleTextAttributes);
                } else if (!bl2) {
                    this.append(" ");
                    this.append(CocoaCommonBundle.message("settings.xcode.version.not.supported", new Object[0]), simpleTextAttributes);
                }
                this.append(" ");
                this.append(xcodeInstallation.getBasePath(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }

            private static /* synthetic */ void j(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/cidr/XcodeConfigurable$3", "customizeCellRenderer"));
            }
        });
        jPanel.add((Component)new JLabel(CocoaCommonBundle.message("settings.selected.xcode", new Object[0])), gridBag.nextLine().next());
        jPanel.add((Component)this.myCombo, gridBag.next());
        String string = Xcode.getInstance().getToolchainDisplayName();
        if (!StringUtil.isEmptyOrSpaces((String)string)) {
            object = new JBLabel(UIUtil.ComponentStyle.SMALL);
            object.setText(CocoaCommonBundle.message("settings.selected.toolchain", string));
            jPanel.add((Component)object, gridBag.nextLine().coverLine());
        }
        jPanel.add((Component)this.myInfoLabel, gridBag.nextLine().coverLine().insets(16, -1, -1, -1));
        this.myCombo.getComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                XcodeConfigurable.this.N();
            }
        });
        object = new JPanel(new BorderLayout());
        ((Container)object).add((Component)jPanel, "North");
        return object;
    }

    public boolean isModified() {
        return this.j() || this.myDownloadCachesCheckBox != null && PropertiesComponent.getInstance().isTrueValue("com.jetbrains.cidr.ZipCacheDownloader.shouldDownload") != this.myDownloadCachesCheckBox.isSelected();
    }

    private boolean j() {
        XcodeInstallation xcodeInstallation = this.j();
        return xcodeInstallation != null && !Xcode.getInstance().getInstallation().equals(xcodeInstallation);
    }

    private void N() {
        HtmlBuilder htmlBuilder;
        XcodeInstallation xcodeInstallation;
        HtmlBuilder htmlBuilder2 = new HtmlBuilder();
        if (this.j()) {
            htmlBuilder2.append(CocoaCommonBundle.message("settings.xcode.restart.required", new Object[0]));
        }
        if ((xcodeInstallation = this.j()) != null && (htmlBuilder = xcodeInstallation.isSupportedVersion()) != null) {
            if (!htmlBuilder2.isEmpty()) {
                htmlBuilder2.br().br();
            }
            htmlBuilder2.append(htmlBuilder);
        }
        if (htmlBuilder2.isEmpty()) {
            this.myInfoLabel.setVisible(false);
        } else {
            this.myInfoLabel.setText(htmlBuilder2.wrapWithHtmlBody().toString());
            this.myInfoLabel.setIcon(AllIcons.General.BalloonWarning);
            this.myInfoLabel.setVerticalTextPosition(1);
            this.myInfoLabel.setVisible(true);
        }
    }

    public void apply() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (this.myDownloadCachesCheckBox.isSelected()) {
            propertiesComponent.setValue("com.jetbrains.cidr.ZipCacheDownloader.shouldDownload", true);
        } else {
            propertiesComponent.unsetValue("com.jetbrains.cidr.ZipCacheDownloader.shouldDownload");
        }
        String string = this.j();
        if (string == null) {
            return;
        }
        XcodeSettings.getInstance().setSelectedXcodeBasePath(string);
        if (this.j()) {
            this.j();
        }
    }

    private void j() {
        int n2 = Messages.showYesNoDialog((String)CocoaCommonBundle.message("settings.xcode.restart.required", new Object[0]), (String)"", (String)CocoaCommonBundle.message("xcode.configurable.restart", new Object[0]), (String)CocoaCommonBundle.message("xcode.configurable.later", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (n2 == 0) {
            ApplicationEx applicationEx = ApplicationManagerEx.getApplicationEx();
            applicationEx.invokeLater(() -> applicationEx.restart(true), ModalityState.nonModal());
            Container container2 = this.myInfoLabel.getRootPane().getParent();
            if (container2 instanceof DialogWrapperDialog) {
                ((DialogWrapperDialog)container2).getDialogWrapper().close(0);
            }
        }
    }

    @Nullable
    private String j() {
        XcodeInstallation xcodeInstallation = this.j();
        return xcodeInstallation == null ? null : xcodeInstallation.getBasePath();
    }

    @Nullable
    private XcodeInstallation j() {
        if (this.myCombo == null) {
            return null;
        }
        Object object = this.myCombo.getComboBox().getSelectedItem();
        if (!(object instanceof XcodeInstallation)) {
            return null;
        }
        return (XcodeInstallation)object;
    }

    public void reset() {
        XcodeSettings xcodeSettings = XcodeSettings.getInstance();
        String string = this.isInitializationReset ? xcodeSettings.getSelectedXcodeBasePath() : Xcode.getInstance().getInstallation().getBasePath();
        this.isInitializationReset = false;
        this.j(string);
        this.myDownloadCachesCheckBox.setSelected(PropertiesComponent.getInstance().isTrueValue("com.jetbrains.cidr.ZipCacheDownloader.shouldDownload"));
    }

    private void j(@Nullable String string) {
        String string2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = XcodeSettings.getInstance().getDetectedXcodePaths().iterator();
        while (object.hasNext()) {
            string2 = object.next();
            arrayList.add(new XcodeInstallation(new File(string2)));
        }
        arrayList.sort(XcodeSettings.XCODE_COMPARATOR);
        Object object2 = object = string == null ? null : new XcodeInstallation(new File(string));
        if (object != null && !arrayList.contains(object)) {
            arrayList.add(0, object);
        }
        string2 = new CollectionComboBoxModel(arrayList, object);
        this.myCombo.getComboBox().setModel(string2);
        this.N();
    }
}

