/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\r\u001a\u00020\bH\u0014J\b\u0010\u000e\u001a\u00020\bH\u0014J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH$J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0014J\u0014\u0010\u0014\u001a\u00020\b*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/VirtualFileChangeListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "coalesceChangesWithSameName", "", "(Z)V", "stack", "", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "begin", "done", "onFileChange", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "triggerFileChanged", "j", "Companion", "intellij.cidr.util"})
public abstract class VirtualFileChangeListener
implements BulkFileListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean coalesceChangesWithSameName;
    private int stack;
    @NotNull
    private static final Logger LOG;

    public VirtualFileChangeListener(boolean coalesceChangesWithSameName) {
        this.coalesceChangesWithSameName = coalesceChangesWithSameName;
    }

    protected void begin() {
    }

    protected void triggerFileChanged(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.onFileChange(file2, event);
    }

    protected abstract void onFileChange(@NotNull VirtualFile var1, @NotNull VFileEvent var2);

    protected void done() {
    }

    private final void j(VirtualFile virtualFile2, VFileEvent vFileEvent) {
        if (!virtualFile2.isValid()) {
            LOG.warn((Throwable)((Object)new AssertionError((Object)("File " + virtualFile2 + " is not valid directly before/after file change"))));
        } else {
            this.triggerFileChanged(virtualFile2, vFileEvent);
        }
    }

    public final void before(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        int n2 = this.stack;
        this.stack = n2 + 1;
        if (n2 == 0) {
            this.begin();
        }
        for (VFileEvent vFileEvent : events) {
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileMoveEvent) {
                VirtualFile virtualFile2 = ((VFileMoveEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                this.j(virtualFile2, vFileEvent);
                continue;
            }
            if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                if (!com.jetbrains.cidr.VirtualFileChangeListener$Companion.isImportantPropertyChange$default(Companion, (VFilePropertyChangeEvent)vFileEvent, false, 2, null)) continue;
                VirtualFile virtualFile3 = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getFile(...)");
                this.j(virtualFile3, vFileEvent);
                continue;
            }
            if (!(vFileEvent2 instanceof VFileDeleteEvent)) continue;
            VirtualFile virtualFile4 = ((VFileDeleteEvent)vFileEvent).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"getFile(...)");
            this.j(virtualFile4, vFileEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        try {
            for (VFileEvent vFileEvent : events) {
                VFileEvent vFileEvent2 = vFileEvent;
                if (vFileEvent2 instanceof VFileMoveEvent) {
                    if (this.coalesceChangesWithSameName) continue;
                    VirtualFile virtualFile2 = ((VFileMoveEvent)vFileEvent).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                    this.j(virtualFile2, vFileEvent);
                    continue;
                }
                if (vFileEvent2 instanceof VFileCreateEvent) {
                    VirtualFile virtualFile3 = ((VFileCreateEvent)vFileEvent).getFile();
                    if (virtualFile3 != null) {
                        this.j(virtualFile3, vFileEvent);
                    }
                    continue;
                }
                if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                    if (!VirtualFileChangeListener.Companion.j((VFilePropertyChangeEvent)vFileEvent, this.coalesceChangesWithSameName)) continue;
                    VirtualFile virtualFile4 = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"getFile(...)");
                    this.j(virtualFile4, vFileEvent);
                    continue;
                }
                if (vFileEvent2 instanceof VFileContentChangeEvent) {
                    VirtualFile virtualFile5 = ((VFileContentChangeEvent)vFileEvent).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile5, (String)"getFile(...)");
                    this.j(virtualFile5, vFileEvent);
                    continue;
                }
                if (!(vFileEvent2 instanceof VFileCopyEvent)) continue;
                VirtualFile virtualFile6 = ((VFileCopyEvent)vFileEvent).getNewParent().findChild(((VFileCopyEvent)vFileEvent).getNewChildName());
                if (virtualFile6 == null) continue;
                this.j(virtualFile6, vFileEvent);
            }
        }
        finally {
            this.stack += -1;
            if (this.stack == 0) {
                this.done();
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(VirtualFileChangeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/VirtualFileChangeListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "j", "", "propertyChangeEvent", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "ignoreSameName", "intellij.cidr.util"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean j(VFilePropertyChangeEvent vFilePropertyChangeEvent, boolean bl) {
            return switch (vFilePropertyChangeEvent.getPropertyName()) {
                case "name" -> {
                    if (!Intrinsics.areEqual((Object)vFilePropertyChangeEvent.getOldValue(), (Object)vFilePropertyChangeEvent.getNewValue())) {
                        yield true;
                    }
                    yield false;
                }
                case "symlink" -> {
                    if (!bl) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        static /* synthetic */ boolean isImportantPropertyChange$default(Companion companion, VFilePropertyChangeEvent vFilePropertyChangeEvent, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            return companion.j(vFilePropertyChangeEvent, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

