/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.Version;
import com.intellij.util.VersionUtil;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ToolVersion
implements Serializable {
    public static final String UNKNOWN_VERSION = "unknown";
    private static final Version NULL_VERSION = new Version(0, 0, 0);
    @NotNull
    public final String versionString;
    @NotNull
    public final Version versionNumber;

    public ToolVersion(int major, int minor, int bugfix) {
        this(Version.toCompactString((int)major, (int)minor, (int)bugfix), major, minor, bugfix);
    }

    public ToolVersion(@NotNull String versionString, int major, int minor, int bugfix) {
        if (versionString == null) {
            ToolVersion.j(0);
        }
        this(versionString, new Version(major, minor, bugfix));
    }

    public ToolVersion(@NotNull String versionString, @NotNull Version versionNumber) {
        if (versionString == null) {
            ToolVersion.j(1);
        }
        if (versionNumber == null) {
            ToolVersion.j(2);
        }
        this.versionNumber = versionNumber;
        this.versionString = versionString;
    }

    public ToolVersion(@NotNull Version version) {
        if (version == null) {
            ToolVersion.j(3);
        }
        this(version.toCompactString(), version);
    }

    @NotNull
    public static ToolVersion createUnknown(@NotNull String versionString) {
        if (versionString == null) {
            ToolVersion.j(4);
        }
        return new ToolVersion(versionString, NULL_VERSION);
    }

    @NotNull
    public static ToolVersion parse(@NotNull String versionString, Pattern ... patterns) {
        Version version;
        if (versionString == null) {
            ToolVersion.j(5);
        }
        if (patterns == null) {
            ToolVersion.j(6);
        }
        return new ToolVersion(versionString, (version = VersionUtil.parseVersion((String)versionString, (Pattern[])patterns)) != null ? version : NULL_VERSION);
    }

    public String toString() {
        return this.versionString;
    }

    @NotNull
    public String toCompactString() {
        String string = this.isUnknown() ? UNKNOWN_VERSION : this.versionNumber.toCompactString();
        if (string == null) {
            ToolVersion.j(7);
        }
        return string;
    }

    public boolean isUnknown() {
        return this.versionNumber == NULL_VERSION;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ToolVersion toolVersion = (ToolVersion)o2;
        return this.isUnknown() == toolVersion.isUnknown() && Objects.equals(this.versionString, toolVersion.versionString) && Objects.equals(this.versionNumber, toolVersion.versionNumber);
    }

    public int hashCode() {
        return Objects.hash(this.isUnknown(), this.versionString, this.versionNumber);
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionNumber";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/ToolVersion";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/ToolVersion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toCompactString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUnknown";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

