/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.google.common.collect.Maps;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.PathTreeBase;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathTree<Self extends PathTree<Self, T>, T>
extends PathTreeBase<Self>
implements Cloneable {
    @Nullable
    protected Set<T> myItems;

    public PathTree() {
        this(true);
    }

    public PathTree(boolean resolveSymlinksIfNecessary) {
        super(resolveSymlinksIfNecessary);
    }

    @NotNull
    protected Set<T> createItemsSet(@Nullable Set<T> existing) {
        return existing != null ? new HashSet<T>(existing) : new HashSet();
    }

    public void addItem(@NotNull String path, @NotNull T item) {
        if (path == null) {
            PathTree.N(0);
        }
        if (item == null) {
            PathTree.N(1);
        }
        PathTree pathTree = (PathTree)this.getNotNullSubTree(path);
        pathTree.getItemsForWrite().add(item);
    }

    public void addItems(@NotNull String path, T ... items2) {
        if (path == null) {
            PathTree.N(2);
        }
        if (items2 == null) {
            PathTree.N(3);
        }
        PathTree pathTree = (PathTree)this.getNotNullSubTree(path);
        ContainerUtil.addAll(pathTree.getItemsForWrite(), (Object[])items2);
    }

    public int removeItem(@NotNull String path, @NotNull T ref) {
        Set<T> set;
        PathTree pathTree;
        if (path == null) {
            PathTree.N(4);
        }
        if (ref == null) {
            PathTree.N(5);
        }
        if ((pathTree = (PathTree)this.getSubTree(path, PathTreeBase.SearchStrategy.NULL_IF_NOT_FOUND)) != null && (set = pathTree.myItems) != null) {
            set.remove(ref);
            return set.size();
        }
        return 0;
    }

    @NotNull
    public Set<T> getItems() {
        Set set = this.myItems == null ? Collections.emptySet() : this.myItems;
        if (set == null) {
            PathTree.N(6);
        }
        return set;
    }

    @NotNull
    protected Set<T> getItemsForWrite() {
        Set<T> set = this.myItems == null ? (this.myItems = this.createItemsSet(null)) : this.myItems;
        if (set == null) {
            PathTree.N(7);
        }
        return set;
    }

    @NotNull
    public Self cloneWithoutSubtree(String path) {
        PathTree pathTree = this.clone((Self)((PathTree)this.self()));
        if (this.myChildren == null) {
            PathTree pathTree2 = pathTree;
            if (pathTree2 == null) {
                PathTree.N(8);
            }
            return (Self)pathTree2;
        }
        List list = FileUtil.splitPath((String)path);
        if (list.isEmpty()) {
            PathTree pathTree3 = pathTree;
            if (pathTree3 == null) {
                PathTree.N(9);
            }
            return (Self)pathTree3;
        }
        String string = StringUtil.join(list.subList(0, list.size() - 1), (String)File.separator);
        String string2 = (String)ContainerUtil.getLastItem((List)list);
        PathTree pathTree4 = (PathTree)pathTree.getSubTree(string, PathTreeBase.SearchStrategy.NULL_IF_NOT_FOUND);
        if (pathTree4 == null || pathTree4.myChildren == null) {
            PathTree pathTree5 = pathTree;
            if (pathTree5 == null) {
                PathTree.N(10);
            }
            return (Self)pathTree5;
        }
        pathTree4.myChildren.remove(string2);
        PathTree pathTree6 = pathTree;
        if (pathTree6 == null) {
            PathTree.N(11);
        }
        return (Self)pathTree6;
    }

    @Override
    Self clone(@Nullable Self parent) {
        PathTree pathTree = (PathTree)super.clone(parent);
        Set<T> set = this.myItems;
        pathTree.myItems = set == null ? null : this.createItemsSet(set);
        return (Self)pathTree;
    }

    @Override
    protected void mergeInto(@NotNull Self mergedTree, @NotNull MultiMap<String, Self> childrenPerKey) {
        if (mergedTree == null) {
            PathTree.N(12);
        }
        if (childrenPerKey == null) {
            PathTree.N(13);
        }
        super.mergeInto(mergedTree, childrenPerKey);
        Set<T> set = this.myItems;
        if (set != null) {
            ((PathTree)mergedTree).getItemsForWrite().addAll(set);
        }
    }

    @Override
    public String toString() {
        if (this.guaranteedToBeEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(1024).append('{');
        this.accept(new PathTreeBase.ToStringVisitor(stringBuilder));
        return stringBuilder.append('}').toString();
    }

    @Override
    protected boolean isLeaf() {
        return !ContainerUtil.isEmpty(this.myItems);
    }

    @Override
    protected void nodeToString(@NotNull StringBuilder sb2, @Nullable String path) {
        if (sb2 == null) {
            PathTree.N(14);
        }
        super.nodeToString(sb2, path);
        sb2.append('=').append(this.myItems);
    }

    @Override
    @NotNull
    protected Object nodeDebugRenderer(@Nullable String path) {
        Map.Entry entry2 = Maps.immutableEntry((Object)super.nodeDebugRenderer(path), this.myItems);
        if (entry2 == null) {
            PathTree.N(15);
        }
        return entry2;
    }

    private static /* synthetic */ void N(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 15 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/PathTree";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedTree";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenPerKey";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/PathTree";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsForWrite";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithoutSubtree";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeDebugRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addItem";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addItems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeItem";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mergeInto";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "nodeToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 15 -> new IllegalStateException(string);
        };
    }
}

