/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.jna.JnaLoader;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.jetbrains.cidr.CidrNativeLibraryPaths;
import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjCHelper {
    private static final AtomicLong nextCallbackId = new AtomicLong();
    private static final ObjCHelperLibrary lib = JnaLoader.isSupportsDirectMapping() ? new ObjCHelperDirect() : (ObjCHelperLibrary)Native.load((String)CidrNativeLibraryPaths.libObjCHelper.getPath(), ObjCHelperLibrary.class);

    public static Pointer cancel_callback(long id) {
        return lib.cancel_callback(id);
    }

    public static Pointer create_block(long id, MyCallback cb) {
        return lib.create_block(id, cb);
    }

    public static Pointer create_block_returning_pointer(long id, MyPointerReturningCallback cb) {
        return lib.create_block_returning_pointer(id, cb);
    }

    public static Pointer create_block_returning_bool(long id, MyBoolReturningCallback cb) {
        return lib.create_block_returning_bool(id, cb);
    }

    public static Pointer create_block_bool(long id, MyBoolCallback cb) {
        return lib.create_block_bool(id, cb);
    }

    public static Pointer create_block_long(long id, MyLongCallback cb) {
        return lib.create_block_long(id, cb);
    }

    public static Pointer create_id_block(long id, MyIDCallback cb) {
        return lib.create_id_block(id, cb);
    }

    public static Pointer create_id_block2(long id, MyIDCallback2 cb) {
        return lib.create_id_block2(id, cb);
    }

    public static Pointer create_id_block3(long id, MyIDCallback3 cb) {
        return lib.create_id_block3(id, cb);
    }

    public static Pointer create_block2(long id, MyCallback2 cb) {
        return lib.create_block2(id, cb);
    }

    @Nullable
    public static ID pointerToID(@Nullable Pointer ptr) {
        if (ptr == null) {
            return null;
        }
        return new ID(new PointerByReference(ptr).getPointer().getLong(0L));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T performWithCallback(long id, Callback callback2, @NotNull Function<Pointer, T> function) {
        void action2;
        if (function == null) {
            ObjCHelper.j(0);
        }
        Pointer pointer2 = null;
        if (callback2 instanceof MyCallback) {
            pointer2 = ObjCHelper.create_block(id, (MyCallback)callback2);
        } else if (callback2 instanceof MyPointerReturningCallback) {
            pointer2 = ObjCHelper.create_block_returning_pointer(id, (MyPointerReturningCallback)callback2);
        } else if (callback2 instanceof MyBoolReturningCallback) {
            pointer2 = ObjCHelper.create_block_returning_bool(id, (MyBoolReturningCallback)callback2);
        } else if (callback2 instanceof MyIDCallback) {
            pointer2 = ObjCHelper.create_id_block(id, (MyIDCallback)callback2);
        } else if (callback2 instanceof MyIDCallback2) {
            pointer2 = ObjCHelper.create_id_block2(id, (MyIDCallback2)callback2);
        } else if (callback2 instanceof MyIDCallback3) {
            pointer2 = ObjCHelper.create_id_block3(id, (MyIDCallback3)callback2);
        } else if (callback2 instanceof MyCallback2) {
            pointer2 = ObjCHelper.create_block2(id, (MyCallback2)callback2);
        } else if (callback2 instanceof MyBoolCallback) {
            pointer2 = ObjCHelper.create_block_bool(id, (MyBoolCallback)callback2);
        } else if (callback2 instanceof MyLongCallback) {
            pointer2 = ObjCHelper.create_block_long(id, (MyLongCallback)callback2);
        }
        Object r2 = action2.apply(pointer2);
        Foundation.invoke((ID)ObjCHelper.pointerToID(pointer2), (String)"release", (Object[])new Object[0]);
        return (T)r2;
    }

    public static long getNextCallbackID() {
        return nextCallbackId.getAndIncrement();
    }

    private static /* synthetic */ void j(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/jetbrains/cidr/ObjCHelper", "performWithCallback"));
    }

    private static interface ObjCHelperLibrary
    extends Library {
        public Pointer cancel_callback(long var1);

        public Pointer create_block(long var1, MyCallback var3);

        public Pointer create_block_returning_pointer(long var1, MyPointerReturningCallback var3);

        public Pointer create_block_returning_bool(long var1, MyBoolReturningCallback var3);

        public Pointer create_block_bool(long var1, MyBoolCallback var3);

        public Pointer create_block_long(long var1, MyLongCallback var3);

        public Pointer create_id_block(long var1, MyIDCallback var3);

        public Pointer create_id_block2(long var1, MyIDCallback2 var3);

        public Pointer create_id_block3(long var1, MyIDCallback3 var3);

        public Pointer create_block2(long var1, MyCallback2 var3);
    }

    public static interface MyCallback
    extends Callback {
        public void invoke(Pointer var1);
    }

    public static interface MyPointerReturningCallback
    extends Callback {
        public Pointer invoke(Pointer var1);
    }

    public static interface MyBoolReturningCallback
    extends Callback {
        public Boolean invoke(Pointer var1);
    }

    public static interface MyBoolCallback
    extends Callback {
        public void invoke(boolean var1);
    }

    public static interface MyLongCallback
    extends Callback {
        public void invoke(long var1);
    }

    public static interface MyIDCallback
    extends Callback {
        public void invoke(ID var1);
    }

    public static interface MyIDCallback2
    extends Callback {
        public void invoke(ID var1, ID var2);
    }

    public static interface MyIDCallback3
    extends Callback {
        public void invoke(ID var1, ID var2, ID var3);
    }

    public static interface MyCallback2
    extends Callback {
        public void invoke(Pointer var1, @Nullable Pointer var2);
    }

    private static final class ObjCHelperDirect
    implements ObjCHelperLibrary {
        private ObjCHelperDirect() {
        }

        @Override
        public native Pointer cancel_callback(long var1);

        @Override
        public native Pointer create_block(long var1, MyCallback var3);

        @Override
        public native Pointer create_block_returning_pointer(long var1, MyPointerReturningCallback var3);

        @Override
        public native Pointer create_block_returning_bool(long var1, MyBoolReturningCallback var3);

        @Override
        public native Pointer create_block_bool(long var1, MyBoolCallback var3);

        @Override
        public native Pointer create_block_long(long var1, MyLongCallback var3);

        @Override
        public native Pointer create_id_block(long var1, MyIDCallback var3);

        @Override
        public native Pointer create_id_block2(long var1, MyIDCallback2 var3);

        @Override
        public native Pointer create_id_block3(long var1, MyIDCallback3 var3);

        @Override
        public native Pointer create_block2(long var1, MyCallback2 var3);

        static {
            Native.register(ObjCHelperDirect.class, (String)CidrNativeLibraryPaths.libObjCHelper.getPath());
        }
    }
}

