/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PlatformUtils;
import com.intellij.util.system.CpuArch;
import com.jetbrains.cidr.CidrPluginPathMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CidrPathManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + CidrPathManager.class.getPackage().getName()));
    private static volatile Path ourCidrRootPath;
    private static final Map<Class<?>, Ref<Path>> ourPluginPathsCache;
    private static final Map<String, Ref<Path>> ourPluginPathsByIdCache;
    private static final Set<Path> ourFileWithExecutableUpdated;

    public static Path getCidrSourcesRoot() {
        if (ourCidrRootPath == null) {
            String string = null;
            if (AppMode.isDevServer()) {
                string = AppMode.getDevIdeaProjectDir();
            }
            if (string == null) {
                string = PathManager.getHomePath();
            }
            ourCidrRootPath = Paths.get(string, System.getProperty("cidr.root.path", "CIDR")).normalize();
        }
        return ourCidrRootPath;
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String platformPath, @NonNls @NotNull String relativePath, boolean archSpecific) {
        if (platformPath == null) {
            CidrPathManager.j(0);
        }
        if (relativePath == null) {
            CidrPathManager.j(1);
        }
        String string = platformPath + "/" + (String)(archSpecific ? (CpuArch.isArm64() ? "aarch64" : "x64") + "/" : "") + relativePath;
        if (string == null) {
            CidrPathManager.j(2);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String platformPath, @NonNls @NotNull String relativePath) {
        if (platformPath == null) {
            CidrPathManager.j(3);
        }
        if (relativePath == null) {
            CidrPathManager.j(4);
        }
        return CidrPathManager.getPlatformRelativePath(platformPath, relativePath, true);
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String relativePath, boolean archSpecific) {
        if (relativePath == null) {
            CidrPathManager.j(5);
        }
        return CidrPathManager.getPlatformRelativePath(SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux"), relativePath, archSpecific);
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String relativePath) {
        if (relativePath == null) {
            CidrPathManager.j(6);
        }
        return CidrPathManager.getPlatformRelativePath(relativePath, true);
    }

    @NotNull
    public static File getBinFile(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries) {
        if (clazz == null) {
            CidrPathManager.j(7);
        }
        if (inSourcesPath == null) {
            CidrPathManager.j(8);
        }
        if (relativePath == null) {
            CidrPathManager.j(9);
        }
        File file2 = CidrPathManager.getBinPath(clazz, inSourcesPath, relativePath, relativePathToAdditionalBinaries).toFile();
        if (file2 == null) {
            CidrPathManager.j(10);
        }
        return file2;
    }

    @NotNull
    public static Path getBinPath(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries) {
        if (clazz == null) {
            CidrPathManager.j(11);
        }
        if (inSourcesPath == null) {
            CidrPathManager.j(12);
        }
        if (relativePath == null) {
            CidrPathManager.j(13);
        }
        return CidrPathManager.getBinPath(clazz, inSourcesPath, relativePath, relativePathToAdditionalBinaries, true);
    }

    @NotNull
    public static Path getBinPath(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries, boolean ensureIsExecutable) {
        Object object;
        if (clazz == null) {
            CidrPathManager.j(14);
        }
        if (inSourcesPath == null) {
            CidrPathManager.j(15);
        }
        if (relativePath == null) {
            CidrPathManager.j(16);
        }
        Path path = null;
        if (CidrPathManager.j()) {
            path = CidrPathManager.j(clazz);
        }
        Path path2 = null;
        if (path != null) {
            path2 = path.resolve("bin");
        } else if (PluginManagerCore.isRunningFromSources() || AppMode.isDevServer()) {
            path2 = CidrPathManager.getCidrSourcesRoot().resolve(inSourcesPath);
        }
        if ((path2 == null || !Files.isDirectory(path2, new LinkOption[0])) && CidrPathManager.j()) {
            object = CidrPathManager.j(clazz);
            if (object != null && (path = CidrPathManager.j((String)object, clazz.getClassLoader())) != null) {
                path2 = path.resolve("bin");
            }
            path2 = CidrPathManager.j(inSourcesPath, relativePath, path2);
        }
        if (path2 != null) {
            object = path2.resolve(relativePath);
            if (ensureIsExecutable) {
                CidrPathManager.j((Path)object);
                if (relativePathToAdditionalBinaries != null) {
                    CidrPathManager.j(path2.resolve(relativePathToAdditionalBinaries));
                }
            }
            Object object2 = object;
            if (object2 == null) {
                CidrPathManager.j(17);
            }
            return object2;
        }
        Path path3 = Paths.get(PathManager.getBinPath(), relativePath);
        if (path3 == null) {
            CidrPathManager.j(18);
        }
        return path3;
    }

    private static Path j(@NonNls @NotNull String string, @NonNls @NotNull String string2, @Nullable Path path) {
        if (string == null) {
            CidrPathManager.j(19);
        }
        if (string2 == null) {
            CidrPathManager.j(20);
        }
        if (path != null && Files.exists(path.resolve(string2), new LinkOption[0])) {
            return path;
        }
        path = Paths.get(PathManager.getHomePath((boolean)false), new String[0]).resolve("CIDR").resolve(string);
        if (Files.exists(path.resolve(string2), new LinkOption[0])) {
            return path;
        }
        return CidrPathManager.getCidrSourcesRoot().resolve(string);
    }

    private static void j(@NotNull Path path) {
        if (path == null) {
            CidrPathManager.j(21);
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                CidrPathManager.j(path2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static Path j(@NotNull Path path) {
        if (path == null) {
            CidrPathManager.j(22);
        }
        if (ourFileWithExecutableUpdated.contains(path)) {
            Path path2 = path;
            if (path2 == null) {
                CidrPathManager.j(23);
            }
            return path2;
        }
        if (Files.isRegularFile(path, new LinkOption[0]) && !Files.isExecutable(path)) {
            LOG.info("Setting executable flag for " + path);
            EnumSet<PosixFilePermission> enumSet2 = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.GROUP_EXECUTE);
            try {
                enumSet2.addAll(Files.getPosixFilePermissions(path, new LinkOption[0]));
                Files.setPosixFilePermissions(path, enumSet2);
            }
            catch (IOException iOException) {
                LOG.warn("Cannot set executable flag for " + path, (Throwable)iOException);
            }
        }
        ourFileWithExecutableUpdated.add(path);
        Path path3 = path;
        if (path3 == null) {
            CidrPathManager.j(24);
        }
        return path3;
    }

    private static boolean j() {
        return !PlatformUtils.isCidr() && !PlatformUtils.isRustRover();
    }

    @Nullable
    private static Path j(@NotNull Class<?> clazz) {
        Ref ref;
        if (clazz == null) {
            CidrPathManager.j(25);
        }
        if ((ref = ourPluginPathsCache.get(clazz)) == null) {
            PluginId pluginId;
            IdeaPluginDescriptor ideaPluginDescriptor;
            ref = new Ref();
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader instanceof PluginAwareClassLoader && (ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)(pluginId = ((PluginAwareClassLoader)classLoader).getPluginId()))) != null) {
                ref.set((Object)ideaPluginDescriptor.getPluginPath());
            }
            ourPluginPathsCache.putIfAbsent(clazz, (Ref<Path>)ref);
        }
        return (Path)ref.get();
    }

    @Nullable
    private static String j(@NotNull Class<?> clazz) {
        if (clazz == null) {
            CidrPathManager.j(26);
        }
        for (CidrPluginPathMapper cidrPluginPathMapper : CidrPluginPathMapper.EP_NAME.getExtensionList()) {
            String string = cidrPluginPathMapper.getPluginId(clazz);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private static Path j(@NotNull String string, @Nullable ClassLoader classLoader) {
        Ref ref;
        if (string == null) {
            CidrPathManager.j(27);
        }
        if ((ref = ourPluginPathsByIdCache.get(string)) == null) {
            ref = new Ref();
            IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)string));
            if (ideaPluginDescriptor != null) {
                Path path = classLoader instanceof PluginAwareClassLoader ? ideaPluginDescriptor.getPluginPath() : ideaPluginDescriptor.getPluginPath().getParent().getParent();
                ref.set((Object)path);
            }
            ourPluginPathsByIdCache.putIfAbsent(string, (Ref<Path>)ref);
        }
        return (Path)ref.get();
    }

    static {
        ourPluginPathsCache = new ConcurrentHashMap();
        ourPluginPathsByIdCache = new ConcurrentHashMap<String, Ref<Path>>();
        ourFileWithExecutableUpdated = ConcurrentCollectionFactory.createConcurrentSet();
    }

    private static /* synthetic */ void j(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 10, 17, 18, 23, 24 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformPath";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 10: 
            case 17: 
            case 18: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrPathManager";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inSourcesPath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrPathManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformRelativePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFileIsExecutable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformRelativePath";
                break;
            }
            case 2: 
            case 10: 
            case 17: 
            case 18: 
            case 23: 
            case 24: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBinFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCidrFallbackPathIfResourceNotFound";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesInDirAreExecutable";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "ensureFileIsExecutable";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPluginPath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMappedPluginId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 17, 18, 23, 24 -> new IllegalStateException(string);
        };
    }
}

